/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.entity;

import com.mojang.datafixers.util.Pair;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionComponent;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.PocketDimensionPortal;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEntities;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class PocketDimensionPortalComponent
implements Component {
    public static final class_5321<class_1937> POCKET_DIMENSION_WORLD_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Arcanus.id("pocket_dimension"));
    private final class_1657 player;
    private final Map<class_5321<class_1937>, Pair<UUID, class_243>> portalIds = new HashMap<class_5321<class_1937>, Pair<UUID, class_243>>();

    public PocketDimensionPortalComponent(class_1657 player) {
        this.player = player;
    }

    public void readFromNbt(class_2487 tag) {
        class_2499 list = tag.method_10554("PortalIds", 10);
        this.portalIds.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbt = list.method_10602(i);
            this.portalIds.put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("WorldKey"))), (Pair<UUID, class_243>)new Pair((Object)nbt.method_25926("PortalId"), (Object)new class_243((double)tag.method_10550("PortalPosX"), (double)tag.method_10550("PortalPosY"), (double)tag.method_10550("PortalPosZ"))));
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 list = new class_2499();
        for (class_5321<class_1937> levelKey : this.portalIds.keySet()) {
            class_2487 nbt = new class_2487();
            Pair<UUID, class_243> pair = this.portalIds.get(levelKey);
            nbt.method_10582("WorldKey", levelKey.method_29177().toString());
            nbt.method_25927("PortalId", (UUID)pair.getFirst());
            tag.method_10549("PortalPosX", ((class_243)pair.getSecond()).method_10216());
            tag.method_10549("PortalPosY", ((class_243)pair.getSecond()).method_10214());
            tag.method_10549("PortalPosZ", ((class_243)pair.getSecond()).method_10215());
            list.add((Object)nbt);
        }
        tag.method_10566("PortalIds", (class_2520)list);
    }

    public void createPortal(class_3218 level, class_243 pos, double pullStrength) {
        MinecraftServer server = level.method_8503();
        for (class_5321<class_1937> levelKey : this.portalIds.keySet()) {
            class_3218 otherWorld;
            Pair<UUID, class_243> pair = this.portalIds.get(levelKey);
            UUID portalId = (UUID)pair.getFirst();
            if (portalId == class_156.field_25140 || (otherWorld = server.method_3847(levelKey)) == null) continue;
            class_2338 blockPos = class_2338.method_49638((class_2374)((class_2374)pair.getSecond()));
            otherWorld.method_14178().method_17297(class_3230.field_19280, class_4076.method_18682((class_2338)blockPos).method_18692(), 1, (Object)blockPos);
            class_1297 oldPortal = otherWorld.method_14190(portalId);
            if (oldPortal == null) continue;
            oldPortal.method_5650(class_1297.class_5529.field_26999);
        }
        PocketDimensionPortal portal = (PocketDimensionPortal)((class_1299)ArcanusEntities.PORTAL.get()).method_5883((class_1937)level);
        if (portal != null) {
            this.portalIds.put((class_5321<class_1937>)level.method_27983(), (Pair<UUID, class_243>)new Pair((Object)portal.method_5667(), (Object)pos));
            if (level.method_27983() != POCKET_DIMENSION_WORLD_KEY) {
                PocketDimensionComponent.get((class_1937)level).setExit(this.player.method_7334().getId(), (class_1937)level, pos);
            }
            portal.setProperties(this.player.method_5667(), pos, pullStrength);
            ArcanusHelper.copyMagicColor(portal, (class_1297)this.player);
            level.method_8649((class_1297)portal);
        }
    }

    public class_243 getPortalPos(class_1937 level) {
        return (class_243)this.portalIds.get(level.method_27983()).getSecond();
    }
}

