/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.entity;

import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;

public class SizeComponent
implements CommonTickingComponent {
    private static final Set<ScaleType> SUPPORTED_SCALE_TYPES = Set.of(ScaleTypes.HEIGHT, ScaleTypes.WIDTH, ScaleTypes.REACH, ScaleTypes.MOTION);
    private final class_1297 entity;
    private int timer = 0;
    private int scaleTicks = 0;
    private float unmodifiedHeight = 1.0f;
    private float previousScaleMultiplier = 1.0f;
    private float scaleMultiplier = 1.0f;

    public SizeComponent(class_1297 entity) {
        this.entity = entity;
    }

    public void tick() {
        class_1321 tameable;
        class_1297 class_12972;
        if (ArcanusConfig.sizeChangingIsPermanent) {
            return;
        }
        if (this.entity instanceof class_1657 || (class_12972 = this.entity) instanceof class_1321 && (tameable = (class_1321)class_12972).method_6139() != null) {
            if (ScaleTypes.HEIGHT.getScaleData(this.entity).getBaseValueModifiers().contains((Object)ArcanusScaleModifier.INSTANCE)) {
                if (this.timer <= 0) {
                    float normalHeight = this.unmodifiedHeight / ScaleTypes.HEIGHT.getScaleData(this.entity).getScale();
                    if (this.entity.method_17682() > normalHeight || this.entity.method_37908().method_8587(this.entity, new class_238(this.entity.method_5829().field_1323, this.entity.method_5829().field_1322, this.entity.method_5829().field_1321, this.entity.method_5829().field_1320, this.entity.method_5829().field_1325 * (double)normalHeight, this.entity.method_5829().field_1324))) {
                        if (this.scaleTicks <= 0) {
                            this.resetScale();
                        } else {
                            --this.scaleTicks;
                            SUPPORTED_SCALE_TYPES.forEach(scaleType -> scaleType.getScaleData(this.entity).onUpdate());
                        }
                    }
                } else {
                    if (this.scaleTicks < 10) {
                        ++this.scaleTicks;
                        SUPPORTED_SCALE_TYPES.forEach(scaleType -> scaleType.getScaleData(this.entity).onUpdate());
                    }
                    --this.timer;
                }
            } else {
                this.scaleTicks = 0;
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.timer = tag.method_10550("Timer");
        this.scaleTicks = tag.method_10550("ScaleTicks");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("Timer", this.timer);
        tag.method_10569("ScaleTicks", this.scaleTicks);
    }

    public void setScale(SpellEffect effect, double strength) {
        this.previousScaleMultiplier = class_3532.method_16439((float)((float)this.scaleTicks / 10.0f), (float)1.0f, (float)this.scaleMultiplier);
        this.scaleMultiplier = ArcanusSpellComponents.SHRINK.is((Object)effect) ? ArcanusConfig.UtilityEffects.ShrinkEffectProperties.baseShrinkAmount : ArcanusConfig.UtilityEffects.EnlargeEffectProperties.baseEnlargeAmount;
        SUPPORTED_SCALE_TYPES.forEach(scaleType -> {
            ScaleData data = scaleType.getScaleData(this.entity);
            if (!data.getBaseValueModifiers().contains((Object)ArcanusScaleModifier.INSTANCE)) {
                data.getBaseValueModifiers().add(ArcanusScaleModifier.INSTANCE);
                data.onUpdate();
            }
        });
        if ((double)Math.abs(this.previousScaleMultiplier - this.scaleMultiplier) > 0.001) {
            this.scaleTicks = 0;
        }
        this.timer = (int)Math.round((double)(ArcanusSpellComponents.SHRINK.is((Object)effect) ? ArcanusConfig.UtilityEffects.ShrinkEffectProperties.baseEffectDuration : ArcanusConfig.UtilityEffects.EnlargeEffectProperties.baseEffectDuration) * strength);
    }

    public void resetScale() {
        SUPPORTED_SCALE_TYPES.forEach(type -> type.getScaleData(this.entity).getBaseValueModifiers().remove((Object)ArcanusScaleModifier.INSTANCE));
        this.scaleMultiplier = 1.0f;
        this.previousScaleMultiplier = 1.0f;
        this.timer = 0;
    }

    public static class ArcanusScaleModifier
    extends ScaleModifier {
        public static final ArcanusScaleModifier INSTANCE = new ArcanusScaleModifier();

        protected ArcanusScaleModifier() {
        }

        public float modifyScale(ScaleData data, float modifiedScale, float delta) {
            ScaleType type = data.getScaleType();
            class_1297 entity = data.getEntity();
            SizeComponent component = (SizeComponent)entity.getComponent(ArcanusComponents.SIZE);
            if (type == ScaleTypes.HEIGHT) {
                component.unmodifiedHeight = modifiedScale;
            }
            if (component.scaleTicks >= 10) {
                return modifiedScale * component.scaleMultiplier;
            }
            float progress = (float)component.scaleTicks + delta;
            float range = modifiedScale * component.scaleMultiplier - modifiedScale * component.previousScaleMultiplier;
            float perTick = ((Float)data.getScaleType().getDefaultEasing().apply((Object)Float.valueOf(progress / 10.0f))).floatValue();
            return modifiedScale * component.previousScaleMultiplier + perTick * range;
        }

        public float modifyPrevScale(ScaleData data, float modifiedScale) {
            class_1297 entity = data.getEntity();
            SizeComponent component = (SizeComponent)entity.getComponent(ArcanusComponents.SIZE);
            return class_3532.method_16439((float)((float)component.scaleTicks / 10.0f), (float)(modifiedScale * component.previousScaleMultiplier), (float)(modifiedScale * component.scaleMultiplier));
        }
    }
}

