/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.level;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.common.blocks.SpatialRiftExitBlock;
import dev.cammiescorner.arcanuscontinuum.common.blocks.SpatialRiftExitEdgeBlock;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionPlot;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusDimensions;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlocks;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.upcraft.sparkweave.api.util.fakeplayer.FakePlayerHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3829;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PocketDimensionComponent
implements Component {
    private static final int REPLACE_FLAGS = 34;
    private static final int DIMENSION_PADDING_Y = 8;
    private static final int DIMENSION_PADDING_XZ = 24;
    private static final int POCKET_MARGIN = 24;
    private final Map<UUID, PocketDimensionPlot> existingPlots = new HashMap<UUID, PocketDimensionPlot>();
    private final Map<UUID, class_3545<class_5321<class_1937>, class_243>> exitSpot = new HashMap<UUID, class_3545<class_5321<class_1937>, class_243>>();
    private final MinecraftServer server;

    public PocketDimensionComponent(class_269 scoreboard, MinecraftServer server) {
        this.server = server;
    }

    public static PocketDimensionComponent get(MinecraftServer server) {
        return (PocketDimensionComponent)server.method_3845().getComponent(ArcanusComponents.POCKET_DIMENSION_COMPONENT);
    }

    public static PocketDimensionComponent get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return (PocketDimensionComponent)serverWorld.method_14170().getComponent(ArcanusComponents.POCKET_DIMENSION_COMPONENT);
        }
        throw new IllegalStateException("World is not a ServerWorld!");
    }

    public void readFromNbt(class_2487 tag) {
        PocketDimensionPlot entry;
        int i;
        class_2499 plotNbtList = tag.method_10554("PlotMap", 10);
        class_2499 exitNbtList = tag.method_10554("ExitSpots", 10);
        this.existingPlots.clear();
        this.exitSpot.clear();
        for (i = 0; i < plotNbtList.size(); ++i) {
            entry = PocketDimensionPlot.fromNbt(plotNbtList.method_10602(i));
            if (entry == null) continue;
            this.existingPlots.put(entry.ownerId(), entry);
        }
        for (i = 0; i < exitNbtList.size(); ++i) {
            entry = exitNbtList.method_10602(i);
            this.exitSpot.put(entry.method_25926("EntityId"), (class_3545<class_5321<class_1937>, class_243>)new class_3545((Object)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(entry.method_10558("WorldKey"))), (Object)new class_243(entry.method_10574("X"), entry.method_10574("Y"), entry.method_10574("Z"))));
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 plotNbtList = new class_2499();
        class_2499 exitNbtList = new class_2499();
        this.existingPlots.forEach((uuid, plot) -> plotNbtList.add((Object)plot.toNbt()));
        this.exitSpot.forEach((uuid, pair) -> {
            class_2487 entry = new class_2487();
            entry.method_25927("EntityId", uuid);
            entry.method_10582("WorldKey", ((class_5321)pair.method_15442()).method_29177().toString());
            entry.method_10549("X", ((class_243)pair.method_15441()).method_10216());
            entry.method_10549("Y", ((class_243)pair.method_15441()).method_10214());
            entry.method_10549("Z", ((class_243)pair.method_15441()).method_10215());
            exitNbtList.add((Object)entry);
        });
        tag.method_10566("PlotMap", (class_2520)plotNbtList);
        tag.method_10566("ExitSpots", (class_2520)exitNbtList);
    }

    private static boolean chunksExist(PocketDimensionPlot plot, class_3218 pocketDim) {
        class_3215 chunkManager = pocketDim.method_14178();
        return class_2338.method_20437((class_2338)plot.min(), (class_2338)plot.max()).map(class_1923::new).distinct().map(cPos -> chunkManager.method_12126(cPos.field_9181, cPos.field_9180, false)).noneMatch(Objects::isNull);
    }

    public void teleportToPocketDimension(GameProfile pocketOwner, class_1297 entity) {
        if (!entity.method_37908().method_8608()) {
            class_3218 pocketDim = this.server.method_3847(ArcanusDimensions.POCKET_DIMENSION);
            ArcanusComponents.setPortalCoolDown(entity, 200);
            if (pocketDim != null) {
                PocketDimensionPlot plot = this.getAssignedPlotSpace(pocketOwner.getId());
                if (plot == null) {
                    plot = this.assignNewPlot(pocketDim, pocketOwner, entity.method_37908().method_8409());
                    this.replacePlotSpace(pocketOwner.getId(), pocketDim, RegenerateType.FULL);
                } else if (!PocketDimensionComponent.chunksExist(plot, pocketDim)) {
                    Arcanus.LOGGER.warn("Pocket dimension plot for player {} ({}) failed integrity check! regenerating boundary...", (Object)pocketOwner.getName(), (Object)pocketOwner.getId());
                    this.replacePlotSpace(pocketOwner.getId(), pocketDim, RegenerateType.WALLS_ONLY);
                }
                class_243 bottomCenterPos = class_243.method_24955((class_2382)plot.getBounds().method_22874().method_33096(plot.min().method_10264() + 1));
                FabricDimensions.teleport((class_1297)entity, (class_3218)pocketDim, (class_5454)new class_5454(bottomCenterPos, class_243.field_1353, entity.method_36454(), entity.method_36455()));
            }
        }
    }

    public boolean teleportOutOfPocketDimension(class_1297 entity) {
        class_3545<class_5321<class_1937>, class_243> pair;
        class_1657 player;
        if (entity instanceof class_1657 && FakePlayerHelper.isFakePlayer((class_1657)(player = (class_1657)entity)) || entity.method_37908().method_27983() != ArcanusDimensions.POCKET_DIMENSION) {
            return false;
        }
        UUID ownerId = this.existingPlots.values().stream().filter(plot -> entity.method_5829().method_994(class_238.method_19316((class_3341)plot.getBounds()))).map(PocketDimensionPlot::ownerId).findFirst().orElse(null);
        ArcanusComponents.setPortalCoolDown(entity, 200);
        if (ownerId != null && (pair = this.exitSpot.get(ownerId)) != null) {
            class_3218 targetWorld = this.server.method_3847((class_5321)pair.method_15442());
            class_243 targetPos = (class_243)pair.method_15441();
            if (targetWorld == null) {
                Arcanus.LOGGER.error("Unable to find dimension {}, defaulting to overworld", (Object)((class_5321)pair.method_15442()).method_29177());
                targetWorld = this.server.method_30002();
                targetPos = class_243.method_24955((class_2382)targetWorld.method_43126());
            }
            FabricDimensions.teleport((class_1297)entity, (class_3218)targetWorld, (class_5454)new class_5454(targetPos, class_243.field_1353, entity.method_36454(), entity.method_36455()));
            return true;
        }
        if (entity instanceof class_3222) {
            class_3222 player2 = (class_3222)entity;
            GameProfile profile = player2.method_7334();
            Arcanus.LOGGER.warn("Failed to determine pocket dimension exit spot for player {} ({}), sending them to their spawn position!", (Object)profile.getName(), (Object)profile.getId());
            class_2338 spawnPos = player2.method_26280();
            float angle = player2.method_30631();
            class_3218 world = this.server.method_3847(player2.method_26281());
            if (!player2.method_26282() || world == null || spawnPos == null) {
                world = this.server.method_30002();
                spawnPos = world.method_43126();
                angle = entity.method_36454();
            }
            FabricDimensions.teleport((class_1297)entity, (class_3218)world, (class_5454)new class_5454(class_243.method_24955((class_2382)spawnPos), class_243.field_1353, angle, entity.method_36455()));
        }
        Arcanus.LOGGER.warn("Unable to teleport entity out of pocket dimension: {} ({})", (Object)entity.method_5820(), (Object)entity.method_5667());
        return false;
    }

    public PocketDimensionPlot assignNewPlot(class_3218 pocketDimension, GameProfile target, class_5819 random) {
        Preconditions.checkArgument((ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.pocketWidth >= 1 ? 1 : 0) != 0, (Object)"Pocket dimension plots must be at least 1x2, width is too small. Please fix the config values!");
        Preconditions.checkArgument((ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.pocketHeight >= 2 ? 1 : 0) != 0, (Object)"Pocket dimension plots must be at least 1x2, height is too small. Please fix the config values!");
        int pocketWidth = ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.pocketWidth;
        int pocketHeight = ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.pocketHeight;
        int halfWidth = class_3532.method_15386((float)((float)pocketWidth / 2.0f));
        class_3341 originalBox = new class_3341(0, 0, 0, pocketWidth + 1, pocketHeight + 1, pocketWidth + 1).method_19311(-halfWidth, 0, -halfWidth);
        class_2784 worldBorder = pocketDimension.method_8621();
        if (worldBorder.method_11959() - worldBorder.method_11972() - 24 < halfWidth) {
            Arcanus.LOGGER.error("Pocket dimension plot for player {} ({}) failed integrity check! world border too small!", (Object)target.getName(), (Object)target.getId());
            return PocketDimensionPlot.of(target.getId(), originalBox);
        }
        int maxOffsetXZ = worldBorder.method_11959() - worldBorder.method_11972() - halfWidth - 24;
        int minY = pocketDimension.method_31607() + 8;
        int maxY = pocketDimension.method_31600() - 8 - pocketHeight;
        List<class_3341> existingPlotsWithSpacing = this.existingPlots.values().stream().map(existing -> existing.getBounds().method_35410(24)).toList();
        class_3341 box = originalBox;
        for (int attempts = 0; attempts < 100; ++attempts) {
            if (this.isValidBounds(pocketDimension, box, worldBorder)) {
                if (existingPlotsWithSpacing.stream().noneMatch(arg_0 -> ((class_3341)box).method_14657(arg_0))) {
                    PocketDimensionPlot plot = PocketDimensionPlot.of(target.getId(), box);
                    this.existingPlots.put(plot.ownerId(), plot);
                    return plot;
                }
            }
            int dX = random.method_43051(class_3532.method_15357((double)worldBorder.method_11964()) - maxOffsetXZ, class_3532.method_15384((double)worldBorder.method_11964()) + maxOffsetXZ);
            int dZ = random.method_43051(class_3532.method_15357((double)worldBorder.method_11980()) - maxOffsetXZ, class_3532.method_15384((double)worldBorder.method_11980()) + maxOffsetXZ);
            int dY = random.method_43051(minY, maxY);
            box = originalBox.method_19311(dX, dY, dZ);
        }
        Arcanus.LOGGER.error("Unable to assign pocket dimension plot for player {} ({}) after 100 attempts, defaulting to center pos!", (Object)target.getName(), (Object)target.getId());
        return PocketDimensionPlot.of(target.getId(), originalBox);
    }

    private boolean isValidBounds(class_3218 world, class_3341 box, class_2784 worldBorder) {
        int bottomY = world.method_31607() + 8;
        int topY = world.method_31607() + world.method_32819() - 8;
        return box.method_35416() >= bottomY && box.method_35419() <= topY && worldBorder.method_11966(class_238.method_19316((class_3341)box));
    }

    @Nullable
    public PocketDimensionPlot getAssignedPlotSpace(UUID target) {
        return this.existingPlots.get(target);
    }

    public boolean replacePlotSpace(UUID target, class_3218 pocketDim, RegenerateType regenerateType) {
        PocketDimensionPlot plot = this.getAssignedPlotSpace(target);
        if (plot == null) {
            return false;
        }
        if (regenerateType.clearInterior()) {
            pocketDim.method_18467(class_1297.class, class_238.method_19316((class_3341)plot.getBounds())).forEach(entity -> {
                class_3222 player;
                if (!(entity instanceof class_3222) || FakePlayerHelper.isFakePlayer((class_1657)(player = (class_3222)entity))) {
                    entity.method_31472();
                    return;
                }
                class_3218 overworld = this.server.method_30002();
                FabricDimensions.teleport((class_1297)player, (class_3218)overworld, (class_5454)new class_5454(class_243.method_24955((class_2382)overworld.method_43126()), class_243.field_1353, overworld.method_43127(), 0.0f));
                player.method_43496((class_2561)class_2561.method_43471((String)"command.arcanuscontinuum.pocket_dimension.regenerate.warn.teleport"));
            });
        }
        class_2338.method_20437((class_2338)plot.min(), (class_2338)plot.max()).forEach(pos -> {
            boolean isNotWall;
            boolean bl = isNotWall = pos.method_10263() != plot.min().method_10263() && pos.method_10263() != plot.max().method_10263() && pos.method_10264() != plot.min().method_10264() && pos.method_10264() != plot.max().method_10264() && pos.method_10260() != plot.min().method_10260() && pos.method_10260() != plot.max().method_10260();
            if (isNotWall) {
                if (regenerateType.clearInterior()) {
                    class_3829.method_16825((Object)pocketDim.method_8321(pos));
                    pocketDim.method_8652(pos, class_2246.field_10124.method_9564(), 34);
                }
                return;
            }
            if (!regenerateType.placeWalls()) {
                return;
            }
            pocketDim.method_8652(pos, ((class_2248)ArcanusBlocks.SPATIAL_RIFT_WALL.get()).method_9564(), 34);
            Optional.ofNullable(pocketDim.method_8321(pos)).flatMap(arg_0 -> ArcanusComponents.MAGIC_COLOR.maybeGet(arg_0)).ifPresent(component -> component.setSourceId(target));
        });
        if (regenerateType.placeWalls()) {
            class_2338 center = plot.getBounds().method_22874().method_33096(plot.min().method_10264());
            class_2338.class_2339 pos2 = center.method_25503();
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    pos2.method_10103(center.method_10263() + x - 2, center.method_10264(), center.method_10260() + z - 2);
                    if (x == 0) {
                        switch (z) {
                            case 0: {
                                pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.CORNER, (Comparable)Boolean.valueOf(true)), 34);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11039), 34);
                                break;
                            }
                            case 3: {
                                pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11039)).method_11657((class_2769)SpatialRiftExitEdgeBlock.CORNER, (Comparable)Boolean.valueOf(true)), 34);
                            }
                        }
                    } else if (x == 3) {
                        switch (z) {
                            case 0: {
                                pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11034)).method_11657((class_2769)SpatialRiftExitEdgeBlock.CORNER, (Comparable)Boolean.valueOf(true)), 34);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pocketDim.method_8501((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11034));
                                break;
                            }
                            case 3: {
                                pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11035)).method_11657((class_2769)SpatialRiftExitEdgeBlock.CORNER, (Comparable)Boolean.valueOf(true)), 34);
                            }
                        }
                    } else if (z == 0) {
                        pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11043), 34);
                    } else if (z == 3) {
                        pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()).method_9564().method_11657((class_2769)SpatialRiftExitEdgeBlock.field_11177, (Comparable)class_2350.field_11035), 34);
                    } else {
                        pocketDim.method_8652((class_2338)pos2, (class_2680)((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT.get()).method_9564().method_11657((class_2769)SpatialRiftExitBlock.ACTIVE, (Comparable)Boolean.valueOf(x == 1 && z == 1)), 34);
                    }
                    Optional.ofNullable(pocketDim.method_8321((class_2338)pos2)).flatMap(arg_0 -> ArcanusComponents.MAGIC_COLOR.maybeGet(arg_0)).ifPresent(component -> component.setSourceId(target));
                }
            }
        }
        class_2338.method_20437((class_2338)plot.min(), (class_2338)plot.max()).forEach(toUpdate -> {
            class_2248 block = pocketDim.method_8320(toUpdate).method_26204();
            pocketDim.method_8408(toUpdate, block);
        });
        return true;
    }

    public void setExit(UUID ownerId, class_1937 world, class_243 pos) {
        this.exitSpot.put(ownerId, (class_3545<class_5321<class_1937>, class_243>)new class_3545((Object)world.method_27983(), (Object)pos));
    }

    public static enum RegenerateType {
        INTERIOR_ONLY,
        WALLS_ONLY,
        FULL;


        public boolean placeWalls() {
            return this != INTERIOR_ONLY;
        }

        public boolean clearInterior() {
            return this != WALLS_ONLY;
        }
    }
}

