/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.goals;

import dev.cammiescorner.arcanuscontinuum.common.entities.Summon;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class FollowCasterGoal<T extends class_1308>
extends class_1352 {
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final T summon;
    private class_1309 owner;
    private final class_4538 level;
    private final double speedModifier;
    private final class_1408 navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public FollowCasterGoal(T summon, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.summon = summon;
        this.level = summon.method_37908();
        this.speedModifier = speedModifier;
        this.navigation = summon.method_5942();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(summon.method_5942() instanceof class_1409) && !(summon.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowCasterGoal");
        }
    }

    public boolean method_6264() {
        class_1309 livingEntity = ((Summon)this.summon).getCaster();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.method_7325()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.summon.method_5858((class_1297)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.summon.method_5858((class_1297)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.summon.method_5765() || this.summon.method_5934();
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.summon.method_5944(class_7.field_18);
        this.summon.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.summon.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.summon.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.summon.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.method_38847(10);
            if (this.summon.method_5858((class_1297)this.owner) >= 144.0) {
                this.teleportToOwner();
            } else {
                this.navigation.method_6335((class_1297)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        class_2338 blockPos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean bl = this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.summon.method_5808((double)x + 0.5, (double)y, (double)z + 0.5, this.summon.method_36454(), this.summon.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_7 blockPathTypes = class_14.method_23476((class_1922)this.level, (class_2338.class_2339)pos.method_25503());
        if (blockPathTypes != class_7.field_12) {
            return false;
        }
        class_2680 blockState = this.level.method_8320(pos.method_10074());
        if (!this.canFly && blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockPos = pos.method_10059((class_2382)this.summon.method_24515());
        return this.level.method_8587(this.summon, this.summon.method_5829().method_996(blockPos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.summon.method_6051().method_43048(max - min + 1) + min;
    }
}

