/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class Aggressorb
extends class_1682
implements Targetable {
    private static final class_2940<Integer> OWNER_ID = class_2945.method_12791(Aggressorb.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TARGET_ID = class_2945.method_12791(Aggressorb.class, (class_2941)class_2943.field_13327);
    private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
    private final List<SpellGroup> groups = new ArrayList<SpellGroup>();
    private UUID casterId = class_156.field_25140;
    private UUID targetId = class_156.field_25140;
    private class_1799 stack = class_1799.field_8037;
    private int groupIndex = 0;
    private double potency = 1.0;
    private boolean boundToTarget = true;

    public Aggressorb(class_1299<? extends class_1682> variant, class_1937 world) {
        super(variant, world);
        this.field_5960 = true;
        this.method_5875(true);
    }

    public boolean method_32316() {
        return super.method_32316();
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_ID, (Object)-1);
        this.field_6011.method_12784(TARGET_ID, (Object)-1);
    }

    public void method_5773() {
        if (this.getCaster() == null || this.getTarget() == null || this.method_5858((class_1297)this.getTarget()) > 4096.0) {
            this.method_5768();
            return;
        }
        if (!this.method_37908().method_8608() && (Integer)this.field_6011.method_12789(TARGET_ID) == -1 && this.getTarget() != null) {
            this.field_6011.method_12778(TARGET_ID, (Object)this.getTarget().method_5628());
        }
        if (this.isBoundToTarget()) {
            int orbCount = ArcanusComponents.aggressorbCount(this.getTarget());
            int orbIndex = ArcanusComponents.aggressorbIndex(this.getTarget(), this) + 1;
            double angle = Math.toRadians(360.0 / (double)orbCount * (double)orbIndex);
            double cosYaw = Math.cos(Math.toRadians(-this.getTarget().field_6283));
            double sinYaw = Math.sin(Math.toRadians(-this.getTarget().field_6283));
            double radius = (double)this.getTarget().method_17682() / 1.5;
            double rotXZ = Math.sin((double)this.getTarget().field_6012 * 0.1 + angle) * radius;
            double rotY = Math.cos((double)this.getTarget().field_6012 * 0.1 + angle) * radius;
            class_243 bodyYaw = new class_243(sinYaw, 1.0, cosYaw);
            class_243 offset = new class_243(sinYaw, 0.0, cosYaw).method_1021(-0.75);
            class_243 imInSpainWithoutTheA = bodyYaw.method_18805(rotXZ, rotY, rotXZ).method_1024((float)Math.toRadians(90.0));
            class_243 targetPos = this.getTarget().method_19538().method_1031(0.0, radius, 0.0).method_1019(imInSpainWithoutTheA).method_1019(offset);
            class_243 direction = targetPos.method_1020(this.method_19538());
            this.method_5784(class_1313.field_6308, direction);
        } else {
            this.field_5960 = false;
        }
        super.method_5773();
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (!this.isBoundToTarget() && !this.method_37908().method_8608()) {
            for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                effect.effect(this.getCaster(), (class_1297)this, this.method_37908(), (class_239)entityHitResult, this.effects, this.stack, this.potency);
            }
            SpellShape.castNext(this.getCaster(), this.method_19538(), entityHitResult.method_17782(), (class_3218)this.method_37908(), this.stack, this.groups, this.groupIndex, this.potency);
            this.method_5768();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (!this.isBoundToTarget() && !this.method_37908().method_8608()) {
            for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                effect.effect(this.getCaster(), (class_1297)this, this.method_37908(), (class_239)blockHitResult, this.effects, this.stack, this.potency);
            }
            SpellShape.castNext(this.getCaster(), this.method_19538(), (class_1297)this, (class_3218)this.method_37908(), this.stack, this.groups, this.groupIndex, this.potency);
            super.method_24920(blockHitResult);
            this.method_5768();
        }
    }

    public boolean method_5732() {
        return true;
    }

    public float method_5871() {
        return this.isBoundToTarget() ? 0.0f : 0.75f;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_243 dir = this.getTarget().method_33571().method_1020(this.method_19538()).method_1029();
        float pitch = (float)Math.toDegrees(Math.asin(-dir.method_10214()));
        float yaw = (float)Math.toDegrees(-Math.atan2(dir.method_10216(), dir.method_10215()));
        this.setBoundToTarget(false);
        this.method_24919((class_1297)this.getTarget(), pitch, yaw, 0.0f, 3.0f, 1.0f);
        ArcanusComponents.removeAggressorbFromEntity(this.getTarget(), this.method_5667());
        return true;
    }

    public void method_5768() {
        if (!this.method_37908().method_8608() && this.getTarget() != null) {
            ArcanusComponents.removeAggressorbFromEntity(this.getTarget(), this.method_5667());
        }
        super.method_5768();
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5749(class_2487 tag) {
        int i;
        this.effects.clear();
        this.groups.clear();
        this.casterId = tag.method_25926("CasterId");
        this.targetId = tag.method_25926("TargetId");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
        this.groupIndex = tag.method_10550("GroupIndex");
        this.potency = tag.method_10574("Potency");
        this.boundToTarget = tag.method_10577("BoundToTarget");
        class_2499 effectList = tag.method_10554("Effects", 8);
        class_2499 groupsList = tag.method_10554("SpellGroups", 10);
        for (i = 0; i < effectList.size(); ++i) {
            this.effects.add((SpellEffect)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(effectList.method_10608(i))));
        }
        for (i = 0; i < groupsList.size(); ++i) {
            this.groups.add(SpellGroup.fromNbt(groupsList.method_10602(i)));
        }
    }

    public void method_5652(class_2487 tag) {
        class_2499 effectList = new class_2499();
        class_2499 groupsList = new class_2499();
        tag.method_25927("CasterId", this.casterId);
        tag.method_25927("TargetId", this.targetId);
        tag.method_10566("ItemStack", (class_2520)this.stack.method_7953(new class_2487()));
        tag.method_10569("GroupIndex", this.groupIndex);
        tag.method_10549("Potency", this.potency);
        tag.method_10556("BoundToTarget", this.boundToTarget);
        for (SpellEffect effect : this.effects) {
            effectList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (SpellGroup group : this.groups) {
            groupsList.add((Object)group.toNbt());
        }
        tag.method_10566("Effects", (class_2520)effectList);
        tag.method_10566("SpellGroups", (class_2520)groupsList);
    }

    public boolean method_5640(double sqDistance) {
        return sqDistance <= 4096.0;
    }

    public class_1309 getCaster() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.casterId)) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        if (this.method_37908().method_8608() && (class_19372 = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(OWNER_ID)).intValue())) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        return null;
    }

    public class_1309 getTarget() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.targetId)) instanceof class_1309) {
            class_1309 target = (class_1309)class_19372;
            return target;
        }
        if (this.method_37908().method_8608() && (class_19372 = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TARGET_ID)).intValue())) instanceof class_1309) {
            class_1309 target = (class_1309)class_19372;
            return target;
        }
        return null;
    }

    public boolean isBoundToTarget() {
        return this.boundToTarget;
    }

    public void setBoundToTarget(boolean boundToTarget) {
        this.boundToTarget = boundToTarget;
    }

    public void setProperties(@Nullable class_1309 caster, class_1309 target, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> groups, int groupIndex, double potency) {
        this.effects.clear();
        this.groups.clear();
        this.effects.addAll(effects);
        this.groups.addAll(groups);
        if (caster != null) {
            this.casterId = caster.method_5667();
            this.field_6011.method_12778(OWNER_ID, (Object)caster.method_5628());
            ArcanusHelper.copyMagicColor(this, (class_1297)caster);
        }
        ArcanusComponents.addAggressorbToEntity(target, this.method_5667());
        this.setBoundToTarget(true);
        this.targetId = target.method_5667();
        this.field_6011.method_12778(TARGET_ID, (Object)target.method_5628());
        this.stack = stack;
        this.groupIndex = groupIndex;
        this.potency = potency;
    }
}

