/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class AreaOfEffect
extends class_1297
implements Targetable {
    private UUID casterId = class_156.field_25140;
    private class_1799 stack = class_1799.field_8037;
    private List<SpellEffect> effects = new ArrayList<SpellEffect>();
    private List<SpellGroup> spellGroups = new ArrayList<SpellGroup>();
    private int groupIndex;
    private double potency;
    private int trueAge;

    public AreaOfEffect(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    public void method_5773() {
        int i;
        if (!(this.method_37908().method_8608() || this.getCaster() != null && this.getCaster().method_5805())) {
            this.method_5768();
            return;
        }
        List list = this.method_37908().method_8390(AreaOfEffect.class, this.method_5829(), class_1301.field_6154);
        if (!list.isEmpty() && (i = this.method_37908().method_8450().method_8356(class_1928.field_19405)) > 0 && list.size() > i - 1) {
            int j = 0;
            for (AreaOfEffect ignored : list) {
                ++j;
            }
            if (j > i - 1) {
                this.method_5768();
                return;
            }
        }
        if (!this.method_37908().method_8608()) {
            int baseLifeSpan = ArcanusConfig.SpellShapes.AOEShapeProperties.baseLifeSpan;
            int timesToApplyEffects = ArcanusConfig.SpellShapes.AOEShapeProperties.timesToApplyEffects;
            int timesToCastNextShape = this.timesToCastNextShape();
            int actualLifeSpan = (int)((double)baseLifeSpan * 0.9);
            if (this.trueAge > 0 && this.trueAge <= actualLifeSpan) {
                if (this.trueAge % (actualLifeSpan / timesToApplyEffects) == 0) {
                    class_238 box = new class_238(-2.0, 0.0, -2.0, 2.0, 2.5, 2.0).method_997(this.method_19538());
                    for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                        if (effect.singleCastOnly()) continue;
                        this.method_37908().method_8390(class_1297.class, box, entity -> {
                            Targetable targetable;
                            return entity.method_5805() && !entity.method_7325() && entity instanceof Targetable && (targetable = (Targetable)entity).arcanus$canBeTargeted();
                        }).forEach(entity -> effect.effect(this.getCaster(), this, this.method_37908(), (class_239)new class_3966(entity), this.effects, this.stack, this.potency));
                    }
                }
                if (this.trueAge == actualLifeSpan) {
                    for (int i2 = 0; i2 < timesToCastNextShape; ++i2) {
                        SpellShape.castNext(this.getCaster(), this.method_19538(), this, (class_3218)this.method_37908(), this.stack, this.spellGroups, this.groupIndex, this.potency);
                        this.method_36456(this.method_36454() + 360.0f / (float)timesToCastNextShape);
                    }
                    for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                        if (!effect.singleCastOnly()) continue;
                        effect.effect(this.getCaster(), this, this.method_37908(), (class_239)new class_3966((class_1297)this), this.effects, this.stack, this.potency);
                    }
                }
            }
            if (this.trueAge >= baseLifeSpan) {
                this.method_5768();
            }
        }
        super.method_5773();
        ++this.trueAge;
    }

    protected void method_5693() {
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    protected void method_5749(class_2487 tag) {
        int i;
        this.effects.clear();
        this.spellGroups.clear();
        this.casterId = tag.method_25926("CasterId");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
        this.groupIndex = tag.method_10550("GroupIndex");
        this.potency = tag.method_10574("Potency");
        this.trueAge = tag.method_10550("TrueAge");
        class_2499 effectList = tag.method_10554("Effects", 8);
        class_2499 groupsList = tag.method_10554("SpellGroups", 10);
        for (i = 0; i < effectList.size(); ++i) {
            this.effects.add((SpellEffect)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(effectList.method_10608(i))));
        }
        for (i = 0; i < groupsList.size(); ++i) {
            this.spellGroups.add(SpellGroup.fromNbt(groupsList.method_10602(i)));
        }
    }

    protected void method_5652(class_2487 tag) {
        class_2499 effectList = new class_2499();
        class_2499 groupsList = new class_2499();
        tag.method_25927("CasterId", this.casterId);
        tag.method_10566("ItemStack", (class_2520)this.stack.method_7953(new class_2487()));
        tag.method_10569("GroupIndex", this.groupIndex);
        tag.method_10549("Potency", this.potency);
        tag.method_10569("TrueAge", this.trueAge);
        for (SpellEffect effect : this.effects) {
            effectList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (SpellGroup group : this.spellGroups) {
            groupsList.add((Object)group.toNbt());
        }
        tag.method_10566("Effects", (class_2520)effectList);
        tag.method_10566("SpellGroups", (class_2520)groupsList);
    }

    public UUID getCasterId() {
        return this.casterId;
    }

    private class_1309 getCaster() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.casterId)) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        return null;
    }

    public int getTrueAge() {
        return this.trueAge;
    }

    public void setProperties(UUID casterId, class_243 pos, class_1799 stack, List<SpellEffect> effects, double potency, List<SpellGroup> groups, int groupIndex) {
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(pos, pos.method_1031(0.0, -64.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this));
        this.method_33574(pos);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.casterId = casterId;
        this.stack = stack;
        this.effects = effects;
        this.spellGroups = groups;
        this.groupIndex = groupIndex;
        this.potency = potency;
        this.trueAge = this.field_5974.method_43048(3);
    }

    private int timesToCastNextShape() {
        if (this.spellGroups.size() <= this.groupIndex + 1) {
            return 0;
        }
        if (this.spellGroups.get(this.groupIndex + 1).shape().singleCastOnly()) {
            return 1;
        }
        return ArcanusConfig.SpellShapes.AOEShapeProperties.timesToCastNextShape;
    }
}

