/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class Beam
extends class_1297
implements Targetable {
    private static final class_2940<Integer> OWNER_ID = class_2945.method_12791(Beam.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_AGE = class_2945.method_12791(Beam.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_ON_ENTITY = class_2945.method_12791(Beam.class, (class_2941)class_2943.field_13323);
    private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
    private final List<SpellGroup> groups = new ArrayList<SpellGroup>();
    private UUID casterId = class_156.field_25140;
    private class_1799 stack = class_1799.field_8037;
    private int groupIndex = 0;
    private double potency = 1.0;

    public Beam(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_ID, (Object)-1);
        this.field_6011.method_12784(MAX_AGE, (Object)40);
        this.field_6011.method_12784(IS_ON_ENTITY, (Object)false);
    }

    public void method_5773() {
        if (this.field_6012 >= (Integer)this.field_6011.method_12789(MAX_AGE) || this.getCaster() == null || this.method_5858((class_1297)this.getCaster()) > 273.0 || !this.getCaster().method_5805() || ((Boolean)this.field_6011.method_12789(IS_ON_ENTITY) != false ? this.method_5854() == null : this.method_37908().method_22347(this.method_24515()))) {
            if (!this.method_37908().method_8608()) {
                this.method_5768();
            }
            return;
        }
        if (!this.method_37908().method_8608() && (Integer)this.field_6011.method_12789(OWNER_ID) == -1 && this.getCaster() != null) {
            this.field_6011.method_12778(OWNER_ID, (Object)this.getCaster().method_5628());
        }
        super.method_5773();
    }

    public void method_5768() {
        if (!this.method_37908().method_8608() && this.getCaster() != null && this.method_5858((class_1297)this.getCaster()) <= 273.0) {
            class_3965 target = (Boolean)this.field_6011.method_12789(IS_ON_ENTITY) != false && this.method_5854() != null ? new class_3966(this.method_5854()) : new class_3965(this.method_19538(), class_2350.field_11036, this.method_24515(), true);
            for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                effect.effect(this.getCaster(), this, this.method_37908(), (class_239)target, this.effects, this.stack, this.potency + 0.15);
            }
            if (target instanceof class_3966) {
                class_3966 entityHit = (class_3966)target;
                SpellShape.castNext(this.getCaster(), target.method_17784(), entityHit.method_17782(), (class_3218)this.method_37908(), this.stack, this.groups, this.groupIndex, this.potency);
            } else {
                SpellShape.castNext(this.getCaster(), target.method_17784(), this, (class_3218)this.method_37908(), this.stack, this.groups, this.groupIndex, this.potency);
            }
        }
        super.method_5768();
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    protected void method_5749(class_2487 tag) {
        int i;
        this.effects.clear();
        this.groups.clear();
        this.field_6011.method_12778(OWNER_ID, (Object)tag.method_10550("OwnerId"));
        this.field_6011.method_12778(MAX_AGE, (Object)tag.method_10550("MaxAge"));
        this.field_6011.method_12778(IS_ON_ENTITY, (Object)tag.method_10577("IsOnBoolean"));
        this.casterId = tag.method_25926("CasterId");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
        this.groupIndex = tag.method_10550("GroupIndex");
        this.potency = tag.method_10574("Potency");
        class_2499 effectList = tag.method_10554("Effects", 8);
        class_2499 groupsList = tag.method_10554("SpellGroups", 10);
        for (i = 0; i < effectList.size(); ++i) {
            this.effects.add((SpellEffect)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(effectList.method_10608(i))));
        }
        for (i = 0; i < groupsList.size(); ++i) {
            this.groups.add(SpellGroup.fromNbt(groupsList.method_10602(i)));
        }
    }

    protected void method_5652(class_2487 tag) {
        class_2499 effectList = new class_2499();
        class_2499 groupsList = new class_2499();
        tag.method_10569("OwnerId", ((Integer)this.field_6011.method_12789(OWNER_ID)).intValue());
        tag.method_10569("MaxAge", ((Integer)this.field_6011.method_12789(MAX_AGE)).intValue());
        tag.method_10556("IsOnBoolean", ((Boolean)this.field_6011.method_12789(IS_ON_ENTITY)).booleanValue());
        tag.method_25927("CasterId", this.casterId);
        tag.method_10566("ItemStack", (class_2520)this.stack.method_7953(new class_2487()));
        tag.method_10569("GroupIndex", this.groupIndex);
        tag.method_10549("Potency", this.potency);
        for (SpellEffect effect : this.effects) {
            effectList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (SpellGroup group : this.groups) {
            groupsList.add((Object)group.toNbt());
        }
        tag.method_10566("Effects", (class_2520)effectList);
        tag.method_10566("SpellGroups", (class_2520)groupsList);
    }

    public boolean method_5640(double sqDistance) {
        return sqDistance <= 4096.0;
    }

    public class_243 getBeamPos(float tickDelta) {
        return this.method_5854() != null ? this.method_5854().method_30950(tickDelta).method_1031(0.0, (double)(this.method_5854().method_17682() / 2.0f), 0.0) : this.method_30950(tickDelta);
    }

    public float getBeamProgress(float tickDelta) {
        return ((float)this.field_6012 + tickDelta) / (float)((Integer)this.field_6011.method_12789(MAX_AGE)).intValue();
    }

    public class_1309 getCaster() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.casterId)) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        if (this.method_37908().method_8608() && (class_19372 = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(OWNER_ID)).intValue())) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        return null;
    }

    public void setProperties(@Nullable class_1309 caster, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> groups, int groupIndex, int maxAge, double potency, boolean isOnEntity) {
        this.effects.clear();
        this.groups.clear();
        this.effects.addAll(effects);
        this.groups.addAll(groups);
        if (caster != null) {
            this.casterId = caster.method_5667();
            this.field_6011.method_12778(OWNER_ID, (Object)caster.method_5628());
            ArcanusHelper.copyMagicColor(this, (class_1297)caster);
        }
        this.stack = stack;
        this.groupIndex = groupIndex;
        this.field_6011.method_12778(MAX_AGE, (Object)maxAge);
        this.potency = potency;
        this.field_6011.method_12778(IS_ON_ENTITY, (Object)isOnEntity);
    }
}

