/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class EntangledOrb
extends class_1297
implements Targetable {
    private static final class_2940<Integer> OWNER_ID = class_2945.method_12791(EntangledOrb.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TARGET_ID = class_2945.method_12791(EntangledOrb.class, (class_2941)class_2943.field_13327);
    private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
    private final List<SpellGroup> groups = new ArrayList<SpellGroup>();
    private UUID casterId = class_156.field_25140;
    private UUID targetId = class_156.field_25140;
    private class_1799 stack = class_1799.field_8037;
    private int groupIndex = 0;
    private double potency = 1.0;

    public EntangledOrb(class_1299<?> variant, class_1937 world) {
        super(variant, world);
        this.field_5960 = true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_ID, (Object)-1);
        this.field_6011.method_12784(TARGET_ID, (Object)-1);
    }

    public void method_5773() {
        class_1309 caster = this.getCaster();
        class_1309 target = this.getTarget();
        if (caster == null || !this.method_37908().field_9236 && !ArcanusComponents.getGuardianOrbId(caster).equals(this.method_5667()) || target == null || caster.method_5858((class_1297)target) > 1024.0) {
            this.method_5768();
            return;
        }
        if (!this.method_37908().method_8608() && (Integer)this.field_6011.method_12789(TARGET_ID) == -1) {
            this.field_6011.method_12778(TARGET_ID, (Object)target.method_5628());
        }
        this.method_36456(target.method_36454());
        this.method_5636(target.field_6283);
        this.method_5847(target.field_6241);
        this.method_36457(target.method_36455());
        double cosYaw = Math.cos(Math.toRadians(-target.field_6283));
        double sinYaw = Math.sin(Math.toRadians(-target.field_6283));
        class_243 rotation = new class_243(sinYaw, 0.0, cosYaw).method_1021((double)(target.method_17681() / 2.0f) + 0.2).method_1024((float)Math.toRadians(105.0));
        class_243 targetPos = target.method_19538().method_1031(rotation.method_10216(), (double)target.method_18381(target.method_18376()) - 0.2, rotation.method_10215());
        class_243 direction = targetPos.method_1020(this.method_19538());
        this.method_5784(class_1313.field_6308, direction.method_1021(0.25));
        if (this.field_6012 % 8 == 0) {
            class_243 vel = (direction.method_1027() <= 1.0 ? direction : direction.method_1029()).method_1021(0.125);
            this.method_37908().method_8406((class_2394)class_2398.field_11207, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), vel.method_10216(), vel.method_10214(), vel.method_10215());
        }
        if (this.field_6012 % 100 == 0 && ArcanusComponents.drainMana(caster, ArcanusConfig.SpellShapes.EntangledOrbShapeProperties.baseManaDrain * (double)this.effects.size(), false)) {
            class_3966 hitResult = new class_3966((class_1297)target);
            for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                effect.effect(caster, this, this.method_37908(), (class_239)hitResult, this.effects, this.stack, this.potency);
            }
        }
        super.method_5773();
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.method_5768();
        return true;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (reason == class_1297.class_5529.field_26998 && !this.method_37908().method_8608() && this.getCaster() != null && this.getTarget() != null) {
            SpellShape.castNext(this.getCaster(), this.getTarget().method_19538(), (class_1297)this.getTarget(), (class_3218)this.method_37908(), this.stack, this.groups, this.groupIndex, this.potency);
        }
        super.method_5650(reason);
    }

    public boolean method_5862() {
        return false;
    }

    protected void method_5749(class_2487 tag) {
        int i;
        this.effects.clear();
        this.groups.clear();
        this.casterId = tag.method_25926("CasterId");
        this.targetId = tag.method_25926("TargetId");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
        this.groupIndex = tag.method_10550("GroupIndex");
        this.potency = tag.method_10574("Potency");
        class_2499 effectList = tag.method_10554("Effects", 8);
        class_2499 groupsList = tag.method_10554("SpellGroups", 10);
        for (i = 0; i < effectList.size(); ++i) {
            this.effects.add((SpellEffect)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(effectList.method_10608(i))));
        }
        for (i = 0; i < groupsList.size(); ++i) {
            this.groups.add(SpellGroup.fromNbt(groupsList.method_10602(i)));
        }
    }

    protected void method_5652(class_2487 tag) {
        class_2499 effectList = new class_2499();
        class_2499 groupsList = new class_2499();
        tag.method_25927("CasterId", this.casterId);
        tag.method_25927("TargetId", this.targetId);
        tag.method_10566("ItemStack", (class_2520)this.stack.method_7953(new class_2487()));
        tag.method_10569("GroupIndex", this.groupIndex);
        tag.method_10549("Potency", this.potency);
        for (SpellEffect effect : this.effects) {
            effectList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (SpellGroup group : this.groups) {
            groupsList.add((Object)group.toNbt());
        }
        tag.method_10566("Effects", (class_2520)effectList);
        tag.method_10566("SpellGroups", (class_2520)groupsList);
    }

    public boolean method_5640(double sqDistance) {
        return sqDistance <= 4096.0;
    }

    public UUID getCasterId() {
        return this.casterId;
    }

    public class_1309 getCaster() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.getCasterId())) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        if (this.method_37908().method_8608() && (class_19372 = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(OWNER_ID)).intValue())) instanceof class_1309) {
            class_1309 caster = (class_1309)class_19372;
            return caster;
        }
        return null;
    }

    public class_1309 getTarget() {
        class_3218 serverWorld;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_14190(this.targetId)) instanceof class_1309) {
            class_1309 target = (class_1309)class_19372;
            return target;
        }
        if (this.method_37908().method_8608() && (class_19372 = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TARGET_ID)).intValue())) instanceof class_1309) {
            class_1309 target = (class_1309)class_19372;
            return target;
        }
        return null;
    }

    public void setProperties(@Nullable class_1309 caster, class_1309 target, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> groups, int groupIndex, double potency) {
        this.effects.clear();
        this.groups.clear();
        this.effects.addAll(effects);
        this.groups.addAll(groups);
        if (caster != null) {
            this.casterId = caster.method_5667();
            this.field_6011.method_12778(OWNER_ID, (Object)caster.method_5628());
            ArcanusComponents.setGuardianOrbManaLock(caster, this.method_5667(), effects.size());
            ArcanusHelper.copyMagicColor(this, (class_1297)caster);
        }
        this.targetId = target.method_5667();
        this.field_6011.method_12778(TARGET_ID, (Object)target.method_5628());
        this.stack = stack;
        this.groupIndex = groupIndex;
        this.potency = potency;
    }
}

