/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.entities.magic;

import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.PocketDimensionPortalComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionComponent;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusEntityTags;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.upcraft.sparkweave.api.util.fakeplayer.FakePlayerHelper;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PocketDimensionPortal
extends class_1297
implements Targetable {
    private static final class_2940<Integer> TRUE_AGE = class_2945.method_12791(PocketDimensionPortal.class, (class_2941)class_2943.field_13327);
    private UUID casterId = class_156.field_25140;
    private double pullStrength;

    public PocketDimensionPortal(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    public void method_5773() {
        block3: {
            double boxRadiusSq;
            double boxRadius;
            block4: {
                class_1657 caster = this.getCaster();
                if (!this.method_37908().method_8608() && (caster == null || !caster.method_5805()) || this.getTrueAge() > ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.baseLifeSpan + 20) {
                    this.method_5768();
                    return;
                }
                if (this.getTrueAge() > ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.baseLifeSpan) break block3;
                class_238 box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).method_1014(4.0 + this.pullStrength).method_997(this.method_19538());
                boxRadius = box.method_17939() / 2.0;
                boxRadiusSq = boxRadius * boxRadius;
                if (!(caster instanceof class_3222)) break block4;
                class_3222 serverCaster = (class_3222)caster;
                if (this.getTrueAge() <= ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.portalGrowTime) break block3;
                this.method_37908().method_8333((class_1297)this, this.method_5829(), entity -> PocketDimensionPortal.canTeleportSafely(entity) && !ArcanusComponents.hasPortalCoolDown(entity)).forEach(entity -> {
                    if (this.method_37908().method_27983() != PocketDimensionPortalComponent.POCKET_DIMENSION_WORLD_KEY) {
                        PocketDimensionComponent.get(this.method_5682()).teleportToPocketDimension(serverCaster.method_7334(), (class_1297)entity);
                    } else {
                        PocketDimensionComponent.get(this.method_37908()).teleportOutOfPocketDimension((class_1297)entity);
                    }
                });
                if (!ArcanusConfig.UtilityEffects.SpatialRiftEffectProperties.canSuckEntitiesIn) break block3;
                this.method_37908().method_8333((class_1297)this, box, entity -> PocketDimensionPortal.canTeleportSafely(entity) && !ArcanusComponents.hasPortalCoolDown(entity)).forEach(entity -> {
                    double distanceSq = this.method_19538().method_1025(entity.method_19538());
                    if (distanceSq <= boxRadiusSq && distanceSq != 0.0) {
                        class_243 direction = this.method_19538().method_1020(entity.method_19538()).method_1029();
                        double inverseSq = 1.0 / distanceSq;
                        entity.method_45319(direction.method_1021(inverseSq));
                        entity.field_6037 = true;
                    }
                });
                break block3;
            }
            int i = 0;
            while ((double)i < boxRadius * 2.0) {
                double particleX = this.method_19538().method_10216() + this.field_5974.method_43059() * boxRadius;
                double particleY = this.method_19538().method_10214();
                double particleZ = this.method_19538().method_10215() + this.field_5974.method_43059() * boxRadius;
                class_243 particlePos = new class_243(particleX, particleY, particleZ);
                class_243 particleVelocity = particlePos.method_1020(this.method_19538());
                if (particlePos.method_1025(this.method_19538()) <= boxRadiusSq) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11214, particleX, particleY, particleZ, particleVelocity.method_10216(), particleVelocity.method_10214(), particleVelocity.method_10215());
                }
                ++i;
            }
        }
        super.method_5773();
        this.field_6011.method_12778(TRUE_AGE, (Object)(this.getTrueAge() + 1));
    }

    protected void method_5693() {
        this.field_6011.method_12784(TRUE_AGE, (Object)0);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    protected void method_5749(class_2487 tag) {
        this.casterId = tag.method_25926("CasterId");
        this.pullStrength = tag.method_10574("PullStrength");
        this.field_6011.method_12778(TRUE_AGE, (Object)tag.method_10550("TrueAge"));
    }

    protected void method_5652(class_2487 tag) {
        tag.method_25927("CasterId", this.casterId);
        tag.method_10549("PullStrength", this.pullStrength);
        tag.method_10569("TrueAge", ((Integer)this.field_6011.method_12789(TRUE_AGE)).intValue());
    }

    private class_1657 getCaster() {
        MinecraftServer server = this.method_5682();
        if (server != null) {
            for (class_3218 serverWorld : server.method_3738()) {
                class_1297 class_12972 = serverWorld.method_14190(this.casterId);
                if (!(class_12972 instanceof class_1657)) continue;
                class_1657 caster = (class_1657)class_12972;
                return caster;
            }
        }
        return null;
    }

    public int getTrueAge() {
        return (Integer)this.field_6011.method_12789(TRUE_AGE);
    }

    public void setProperties(UUID casterId, class_243 pos, double pullStrength) {
        this.method_33574(pos);
        this.casterId = casterId;
        this.pullStrength = pullStrength;
    }

    private static boolean canTeleportSafely(class_1297 entity) {
        class_1657 player;
        if (entity.method_7325() || !entity.method_5805() || !entity.method_5822() || entity instanceof class_1657 && FakePlayerHelper.isFakePlayer((class_1657)(player = (class_1657)entity))) {
            return false;
        }
        return !entity.method_5864().method_20210(ArcanusEntityTags.SPATIAL_RIFT_IMMUNE);
    }
}

