/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.cammiescorner.arcanuscontinuum.common.util.StaffType;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class StaffItem
extends class_1792 {
    public static final UUID ATTACK_RANGE_MODIFIER_ID = UUID.fromString("05869d86-c861-4954-9079-68c380ad063c");
    private final Supplier<Multimap<class_1320, class_1322>> attributeModifiers = Suppliers.memoize(() -> ImmutableMultimap.builder().put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", -1.0, class_1322.class_1323.field_6328)).put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(ATTACK_RANGE_MODIFIER_ID, "Weapon modifier", 0.5, class_1322.class_1323.field_6328)).build());
    public final StaffType staffType;
    public final Color defaultPrimaryColor;
    public final Color defaultSecondaryColor;
    public final boolean isDonorOnly;

    public StaffItem(StaffType staffType, Color defaultPrimaryColor, Color defaultSecondaryColor) {
        this(staffType, defaultPrimaryColor, defaultSecondaryColor, false);
    }

    public StaffItem(StaffType staffType, Color defaultPrimaryColor, Color defaultSecondaryColor, boolean isDonorOnly) {
        super(new class_1792.class_1793().method_7889(1));
        this.staffType = staffType;
        this.defaultPrimaryColor = defaultPrimaryColor;
        this.defaultSecondaryColor = defaultSecondaryColor;
        this.isDonorOnly = isDonorOnly;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        class_2487 tag;
        if (!world.method_8608() && (tag = stack.method_7911("arcanuscontinuum")).method_33133()) {
            class_2499 list = new class_2499();
            for (int i = 0; i < 8; ++i) {
                list.method_10531(i, (class_2520)new Spell().toNbt());
            }
            tag.method_10566("Spells", (class_2520)list);
        }
        super.method_7843(stack, world, player);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2487 tag;
        if (!world.method_8608() && (tag = stack.method_7911("arcanuscontinuum")).method_33133()) {
            class_2499 list = new class_2499();
            for (int i = 0; i < 8; ++i) {
                list.method_10531(i, (class_2520)new Spell().toNbt());
            }
            tag.method_10566("Spells", (class_2520)list);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 tag = stack.method_7941("arcanuscontinuum");
        int primaryColour = StaffItem.getPrimaryColorRGB(stack);
        int secondaryColour = StaffItem.getSecondaryColorRGB(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"staff.arcanuscontinuum.primary_color").method_27694(style -> style.method_36139(primaryColour)).method_10852((class_2561)class_2561.method_43470((String)(": " + String.format(Locale.ROOT, "#%06X", primaryColour))).method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43471((String)"staff.arcanuscontinuum.secondary_color").method_27694(style -> style.method_36139(secondaryColour)).method_10852((class_2561)class_2561.method_43470((String)(": " + String.format(Locale.ROOT, "#%06X", secondaryColour))).method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43473());
        if (tag != null && !tag.method_33133()) {
            class_2499 list = tag.method_10554("Spells", 10);
            for (int i = 0; i < list.size(); ++i) {
                Spell spell = Spell.fromNbt(list.method_10602(i));
                if (spell.getComponentGroups().isEmpty()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"staff.arcanuscontinuum.invalid_data").method_27692(class_124.field_1079));
                    return;
                }
                class_5250 text = class_2561.method_43470((String)spell.getName()).method_27692(spell.isEmpty() ? class_124.field_1080 : class_124.field_1060);
                tooltip.add((class_2561)text.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063)).method_10852((class_2561)Arcanus.getSpellPatternAsText(i).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)));
            }
        }
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers.get() : super.method_7844(slot);
    }

    public static void setPrimaryColor(class_1799 stack, Color color) {
        stack.method_7911("arcanuscontinuum").method_10569("PrimaryColor", color.asInt(Color.Ordering.RGB));
    }

    public static Color getPrimaryColor(class_1799 stack) {
        Color color = ((StaffItem)stack.method_7909()).defaultPrimaryColor;
        class_2487 tag = stack.method_7941("arcanuscontinuum");
        if (tag != null && tag.method_10573("PrimaryColor", 3)) {
            color = Color.fromInt(tag.method_10550("PrimaryColor"), Color.Ordering.RGB);
        }
        return color;
    }

    public static int getPrimaryColorRGB(class_1799 stack) {
        return StaffItem.getPrimaryColor(stack).asInt(Color.Ordering.RGB);
    }

    public static void setSecondaryColor(class_1799 stack, Color color) {
        stack.method_7911("arcanuscontinuum").method_10569("SecondaryColor", color.asInt(Color.Ordering.RGB));
    }

    public static Color getSecondaryColor(class_1799 stack) {
        Color color = ((StaffItem)stack.method_7909()).defaultSecondaryColor;
        class_2487 tag = stack.method_7941("arcanuscontinuum");
        if (tag != null && tag.method_10573("SecondaryColor", 3)) {
            color = Color.fromInt(tag.method_10550("SecondaryColor"), Color.Ordering.RGB);
        }
        return color;
    }

    public static int getSecondaryColorRGB(class_1799 stack) {
        return StaffItem.getSecondaryColor(stack).asInt(Color.Ordering.RGB);
    }

    public static class_1799 setCraftedBy(class_1799 stack, UUID uuid) {
        class_2487 tag = stack.method_7911("arcanuscontinuum");
        tag.method_25927("OwnerId", uuid);
        return stack;
    }
}

