/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.packets.c2s;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.api.spells.Pattern;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.WizardLevelComponent;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusItemTags;
import dev.cammiescorner.arcanuscontinuum.common.items.StaffItem;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class SyncPatternPacket {
    public static final class_2960 ID = Arcanus.id("sync_pattern");

    public static void send(List<Pattern> pattern) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(pattern.size());
        for (int i = 0; i < pattern.size(); ++i) {
            buf.writeInt(pattern.get(i).ordinal());
        }
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void handler(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        ArrayList<Pattern> pattern = new ArrayList<Pattern>();
        int listSize = buf.readInt();
        for (int i = 0; i < listSize; ++i) {
            pattern.add(Pattern.values()[buf.readInt()]);
        }
        server.execute(() -> {
            ArcanusComponents.setPattern((class_1309)player, pattern);
            if (pattern.size() >= 3) {
                class_1799 stack = player.method_6047();
                class_2487 tag = stack.method_7911("arcanuscontinuum");
                int index = Arcanus.getSpellIndex(pattern);
                class_1792 patt2485$temp = stack.method_7909();
                if (patt2485$temp instanceof StaffItem) {
                    StaffItem staff = (StaffItem)patt2485$temp;
                    class_2499 list = tag.method_10554("Spells", 10);
                    if (!list.isEmpty() && player.method_7357().method_7905((class_1792)staff, 1.0f) == 0.0f) {
                        Spell spell = Spell.fromNbt(list.method_10602(index));
                        if (spell.getComponentGroups().stream().flatMap(SpellGroup::getAllComponents).mapToInt(SpellComponent::getMinLevel).max().orElse(1) > ((WizardLevelComponent)ArcanusComponents.WIZARD_LEVEL_COMPONENT.get((Object)player)).getLevel()) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"spell.arcanuscontinuum.too_low_level"), true);
                            return;
                        }
                        if (spell.getComponentGroups().stream().flatMap(SpellGroup::getAllComponents).count() > (long)ArcanusComponents.maxSpellSize((class_1309)player)) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"spell.arcanuscontinuum.too_many_components"), true);
                            return;
                        }
                        if (!ArcanusComponents.drainMana((class_1309)player, spell.getManaCost(), player.method_7337())) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"spell.arcanuscontinuum.not_enough_mana"), true);
                            return;
                        }
                        ArcanusComponents.setPattern((class_1309)player, Arcanus.getSpellPattern(index));
                        ArcanusComponents.setLastCastTime((class_1309)player, player.method_37908().method_8510());
                        spell.cast((class_1309)player, player.method_51469(), stack);
                        player.method_7353((class_2561)class_2561.method_43471((String)spell.getName()).method_27692(class_124.field_1060), true);
                        for (class_6880 holder : class_7923.field_41178.method_40286(ArcanusItemTags.STAVES)) {
                            player.method_7357().method_7906((class_1792)holder.comp_349(), (int)((double)spell.getCoolDown() * player.method_26825((class_1320)ArcanusEntityAttributes.SPELL_COOL_DOWN.get())));
                        }
                    }
                }
            }
        });
    }
}

