/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.recipes;

import com.google.common.collect.Lists;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusItemTags;
import dev.cammiescorner.arcanuscontinuum.common.items.SpellBookItem;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class SpellBindingRecipe
extends class_1852 {
    private static final int[] INDICES = new int[]{7, 0, 1, 6, 0, 2, 5, 4, 3};

    public SpellBindingRecipe(class_2960 identifier, class_7710 category) {
        super(identifier, category);
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inventory) {
        class_2371 list = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31573(ArcanusItemTags.CRAFTING_SPELLBINDING_SPELLBOOKS)) continue;
            list.set(i, (Object)stack.method_7972());
        }
        return list;
    }

    public boolean matches(class_8566 inv, class_1937 world) {
        ArrayList spellBooks = Lists.newArrayList();
        class_1799 result = class_1799.field_8037;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31573(ArcanusItemTags.STAVES)) {
                if (i != 4) {
                    return false;
                }
                result = stack.method_7972();
                continue;
            }
            if (stack.method_31573(ArcanusItemTags.CRAFTING_SPELLBINDING_SPELLBOOKS)) {
                spellBooks.add(stack);
                continue;
            }
            return false;
        }
        return !result.method_7960() && !spellBooks.isEmpty();
    }

    public class_1799 assemble(class_8566 inv, class_5455 manager) {
        class_1799 result = inv.method_5438(4).method_7972();
        if (!result.method_31573(ArcanusItemTags.STAVES)) {
            return class_1799.field_8037;
        }
        class_2487 tag = result.method_7911("arcanuscontinuum");
        class_2499 list = tag.method_10554("Spells", 10);
        Object[] spells = new Spell[8];
        Arrays.fill(spells, new Spell());
        for (int i = 0; i < list.size(); ++i) {
            try {
                spells[i] = Spell.fromNbt(list.method_10602(i));
                continue;
            }
            catch (Exception e) {
                Arcanus.LOGGER.error("Failed to load spell from NBT", (Throwable)e);
            }
        }
        int count = 0;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack;
            if (i == 4 || !(stack = inv.method_5438(i)).method_31573(ArcanusItemTags.CRAFTING_SPELLBINDING_SPELLBOOKS)) continue;
            spells[SpellBindingRecipe.INDICES[i]] = SpellBookItem.getSpell(stack);
            ++count;
        }
        if (count == 0 || result.method_7960()) {
            return class_1799.field_8037;
        }
        list.clear();
        for (Object spell : spells) {
            list.add((Object)((Spell)spell).toNbt());
        }
        tag.method_10566("Spells", (class_2520)list);
        return result;
    }

    public boolean method_8113(int width, int height) {
        return width == 3 && height == 3;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ArcanusRecipes.SPELL_BINDING.get();
    }
}

