/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.registry;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Pattern;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.blocks.entities.AbstractMagicBlockEntity;
import dev.cammiescorner.arcanuscontinuum.common.compat.ArcanusCompat;
import dev.cammiescorner.arcanuscontinuum.common.compat.PehkuiCompat;
import dev.cammiescorner.arcanuscontinuum.common.components.MagicColorComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.chunk.WardedBlocksComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.color.GenericMagicColorComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.color.PlayerMagicColorComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.AggressorbComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.BoltTargetComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.BurnoutComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.CastingComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.CounterComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.GuardianOrbComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.LastCastTimeComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.ManaComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.PatternComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.PocketDimensionPortalComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.PortalCoolDownComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.QuestComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.SizeComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.SpellShapeComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.StunComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.entity.WizardLevelComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionComponent;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Aggressorb;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.AreaOfEffect;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Beam;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.EntangledOrb;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.MagicRune;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.ManaShield;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Missile;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.PocketDimensionPortal;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Smite;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.TemporalDilationField;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.onyxstudios.cca.api.v3.block.BlockComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.block.BlockComponentInitializer;
import dev.onyxstudios.cca.api.v3.chunk.ChunkComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.chunk.ChunkComponentInitializer;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentInitializer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ArcanusComponents
implements BlockComponentInitializer,
ChunkComponentInitializer,
EntityComponentInitializer,
ScoreboardComponentInitializer {
    public static final ComponentKey<MagicColorComponent> MAGIC_COLOR = ArcanusComponents.createComponent("magic_color", MagicColorComponent.class);
    public static final ComponentKey<PocketDimensionComponent> POCKET_DIMENSION_COMPONENT = ArcanusComponents.createComponent("pocket_dimension", PocketDimensionComponent.class);
    public static final ComponentKey<WardedBlocksComponent> WARDED_BLOCKS_COMPONENT = ArcanusComponents.createComponent("warded_blocks", WardedBlocksComponent.class);
    public static final ComponentKey<WizardLevelComponent> WIZARD_LEVEL_COMPONENT = ArcanusComponents.createComponent("wizard_level", WizardLevelComponent.class);
    public static final ComponentKey<ManaComponent> MANA_COMPONENT = ArcanusComponents.createComponent("mana", ManaComponent.class);
    public static final ComponentKey<BurnoutComponent> BURNOUT_COMPONENT = ArcanusComponents.createComponent("burnout", BurnoutComponent.class);
    public static final ComponentKey<CastingComponent> CASTING_COMPONENT = ArcanusComponents.createComponent("casting", CastingComponent.class);
    public static final ComponentKey<PatternComponent> PATTERN_COMPONENT = ArcanusComponents.createComponent("casting_pattern", PatternComponent.class);
    public static final ComponentKey<LastCastTimeComponent> LAST_CAST_TIME_COMPONENT = ArcanusComponents.createComponent("last_cast_time", LastCastTimeComponent.class);
    public static final ComponentKey<StunComponent> STUN_COMPONENT = ArcanusComponents.createComponent("stun", StunComponent.class);
    public static final ComponentKey<QuestComponent> QUEST_COMPONENT = ArcanusComponents.createComponent("quests", QuestComponent.class);
    public static final ComponentKey<BoltTargetComponent> BOLT_TARGET = ArcanusComponents.createComponent("bolt_target", BoltTargetComponent.class);
    public static final ComponentKey<SpellShapeComponent> SPELL_SHAPE = ArcanusComponents.createComponent("spell_shape", SpellShapeComponent.class);
    public static final ComponentKey<SizeComponent> SIZE = ArcanusComponents.createComponent("size", SizeComponent.class);
    public static final ComponentKey<PocketDimensionPortalComponent> POCKET_DIMENSION_PORTAL_COMPONENT = ArcanusComponents.createComponent("pocket_dimension_portal", PocketDimensionPortalComponent.class);
    public static final ComponentKey<AggressorbComponent> AGGRESSORB_COMPONENT = ArcanusComponents.createComponent("aggressorb", AggressorbComponent.class);
    public static final ComponentKey<GuardianOrbComponent> GUARDIAN_ORB_COMPONENT = ArcanusComponents.createComponent("guardian_orb", GuardianOrbComponent.class);
    public static final ComponentKey<PortalCoolDownComponent> PORTAL_COOL_DOWN_COMPONENT = ArcanusComponents.createComponent("portal_cool_down", PortalCoolDownComponent.class);
    public static final ComponentKey<CounterComponent> COUNTER_COMPONENT = ArcanusComponents.createComponent("counter", CounterComponent.class);

    public void registerBlockComponentFactories(BlockComponentFactoryRegistry registry) {
        registry.beginRegistration(AbstractMagicBlockEntity.class, MAGIC_COLOR).impl(GenericMagicColorComponent.class).end(GenericMagicColorComponent::new);
    }

    public void registerChunkComponentFactories(ChunkComponentFactoryRegistry registry) {
        registry.register(WARDED_BLOCKS_COMPONENT, WardedBlocksComponent::new);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.beginRegistration(class_1657.class, WIZARD_LEVEL_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(WizardLevelComponent::new);
        registry.beginRegistration(class_1309.class, MANA_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(ManaComponent::new);
        registry.beginRegistration(class_1309.class, BURNOUT_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(BurnoutComponent::new);
        registry.beginRegistration(class_1657.class, CASTING_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(CastingComponent::new);
        registry.beginRegistration(class_1657.class, PATTERN_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(PatternComponent::new);
        registry.beginRegistration(class_1657.class, POCKET_DIMENSION_PORTAL_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(PocketDimensionPortalComponent::new);
        registry.beginRegistration(class_1309.class, LAST_CAST_TIME_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(LastCastTimeComponent::new);
        registry.beginRegistration(class_1309.class, STUN_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(StunComponent::new);
        registry.beginRegistration(class_1657.class, QUEST_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(QuestComponent::new);
        registry.beginRegistration(class_1309.class, BOLT_TARGET).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(BoltTargetComponent::new);
        registry.beginRegistration(class_1309.class, AGGRESSORB_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(AggressorbComponent::new);
        registry.beginRegistration(class_1309.class, GUARDIAN_ORB_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(GuardianOrbComponent::new);
        registry.beginRegistration(class_1657.class, PORTAL_COOL_DOWN_COMPONENT).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(PortalCoolDownComponent::new);
        registry.beginRegistration(class_1309.class, COUNTER_COMPONENT).respawnStrategy(RespawnCopyStrategy.NEVER_COPY).end(CounterComponent::new);
        List.of(Aggressorb.class, AreaOfEffect.class, Beam.class, EntangledOrb.class, Missile.class, MagicRune.class, ManaShield.class, PocketDimensionPortal.class, Smite.class, TemporalDilationField.class).forEach(type -> registry.beginRegistration(type, MAGIC_COLOR).impl(GenericMagicColorComponent.class).end(x$0 -> new GenericMagicColorComponent(x$0)));
        registry.registerForPlayers(MAGIC_COLOR, PlayerMagicColorComponent::new, RespawnCopyStrategy.NEVER_COPY);
        ArcanusCompat.PEHKUI.ifEnabled(() -> () -> {
            PehkuiCompat.registerEntityComponents(registry);
            PehkuiCompat.registerModifiers();
        });
    }

    private static <T extends Component> ComponentKey<T> createComponent(String name, Class<T> component) {
        return ComponentRegistry.getOrCreate((class_2960)Arcanus.id(name), component);
    }

    @Nullable
    private static WardedBlocksComponent getWardedBlocksComponent(class_1937 world, class_2338 pos) {
        class_2791 chunk = world.method_22350(pos);
        return !(chunk instanceof class_2812) ? (WardedBlocksComponent)chunk.getComponent(WARDED_BLOCKS_COMPONENT) : null;
    }

    public static void addWardedBlock(class_1657 player, class_2338 pos) {
        WardedBlocksComponent component = ArcanusComponents.getWardedBlocksComponent(player.method_37908(), pos);
        if (component != null) {
            component.addWardedBlock(player, pos);
        }
    }

    public static void removeWardedBlock(class_1657 player, class_2338 pos) {
        WardedBlocksComponent component = ArcanusComponents.getWardedBlocksComponent(player.method_37908(), pos);
        if (component != null) {
            component.removeWardedBlock(player, pos);
        }
    }

    public static boolean isOwnerOfBlock(class_1657 player, class_2338 pos) {
        WardedBlocksComponent component = ArcanusComponents.getWardedBlocksComponent(player.method_37908(), pos);
        return component != null && component.isOwnerOfBlock(player, pos);
    }

    public static boolean isBlockWarded(class_1937 world, class_2338 pos) {
        WardedBlocksComponent component = ArcanusComponents.getWardedBlocksComponent(world, pos);
        return component != null && component.isBlockWarded(pos);
    }

    public static Map<class_2338, UUID> getWardedBlocks(class_2791 chunk) {
        if (chunk instanceof class_2812) {
            return Map.of();
        }
        return ((WardedBlocksComponent)chunk.getComponent(WARDED_BLOCKS_COMPONENT)).getWardedBlocks();
    }

    public static double getMaxMana(class_1309 entity) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).getMaxMana();
    }

    public static double getManaLock(class_1309 entity) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).getManaLock();
    }

    public static double getTrueMaxMana(class_1309 entity) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).getTrueMaxMana();
    }

    public static double getMana(class_1309 entity) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).getMana();
    }

    public static void setMana(class_1309 entity, double amount) {
        ((ManaComponent)entity.getComponent(MANA_COMPONENT)).setMana(amount);
    }

    public static boolean addMana(class_1309 entity, double amount, boolean simulate) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).addMana(amount, simulate);
    }

    public static boolean drainMana(class_1309 entity, double amount, boolean simulate) {
        return ((ManaComponent)entity.getComponent(MANA_COMPONENT)).drainMana(amount, simulate);
    }

    public static double getBurnout(class_1309 entity) {
        return ((BurnoutComponent)BURNOUT_COMPONENT.get((Object)entity)).getBurnout();
    }

    public static void setBurnout(class_1309 entity, double amount) {
        ((BurnoutComponent)BURNOUT_COMPONENT.get((Object)entity)).setBurnout(amount);
    }

    public static boolean addBurnout(class_1309 entity, double amount, boolean simulate) {
        return ((BurnoutComponent)BURNOUT_COMPONENT.get((Object)entity)).addBurnout(amount, simulate);
    }

    public static boolean drainBurnout(class_1309 entity, double amount, boolean simulate) {
        return ((BurnoutComponent)BURNOUT_COMPONENT.get((Object)entity)).drainBurnout(amount, simulate);
    }

    public static int getWizardLevel(class_1309 entity) {
        return ((WizardLevelComponent)WIZARD_LEVEL_COMPONENT.get((Object)entity)).getLevel();
    }

    public static void setWizardLevel(class_1309 entity, int level) {
        ((WizardLevelComponent)WIZARD_LEVEL_COMPONENT.get((Object)entity)).setLevel(level);
    }

    public static int maxSpellSize(class_1309 entity) {
        int level = ArcanusComponents.getWizardLevel(entity);
        return level > 0 ? (level == 1 ? 2 : 2 + level) : 0;
    }

    public static void increaseWizardLevel(class_1309 entity, int amount) {
        ArcanusComponents.setWizardLevel(entity, ArcanusComponents.getWizardLevel(entity) + amount);
    }

    public static boolean isCasting(class_1309 entity) {
        return ((CastingComponent)CASTING_COMPONENT.get((Object)entity)).isCasting();
    }

    public static void setCasting(class_1309 entity, boolean casting) {
        ((CastingComponent)CASTING_COMPONENT.get((Object)entity)).setCasting(casting);
    }

    public static List<Pattern> getPattern(class_1309 entity) {
        return ((PatternComponent)PATTERN_COMPONENT.get((Object)entity)).getPattern();
    }

    public static void setPattern(class_1309 entity, List<Pattern> pattern) {
        ((PatternComponent)PATTERN_COMPONENT.get((Object)entity)).setPattern(pattern);
    }

    public static void clearPattern(class_1309 entity) {
        ((PatternComponent)PATTERN_COMPONENT.get((Object)entity)).clearPattern();
    }

    public static long getLastCastTime(class_1309 entity) {
        return ((LastCastTimeComponent)LAST_CAST_TIME_COMPONENT.get((Object)entity)).getLastCastTime();
    }

    public static void setLastCastTime(class_1309 entity, long time) {
        ((LastCastTimeComponent)LAST_CAST_TIME_COMPONENT.get((Object)entity)).setLastCastTime(time);
    }

    public static int getStunTimer(class_1309 entity) {
        return ((StunComponent)STUN_COMPONENT.get((Object)entity)).getStunTimer();
    }

    public static void setStunTimer(class_1309 entity, int timer) {
        ((StunComponent)STUN_COMPONENT.get((Object)entity)).setStunTimer(timer);
    }

    public static List<class_2960> getQuestIds(class_1657 player) {
        return ((QuestComponent)QUEST_COMPONENT.get((Object)player)).getQuestIds();
    }

    public static long getLastCompletedQuestTime(class_1657 player) {
        return ((QuestComponent)QUEST_COMPONENT.get((Object)player)).getLastCompletedQuestTime();
    }

    public static void setLastCompletedQuestTime(class_1657 player, long time) {
        ((QuestComponent)QUEST_COMPONENT.get((Object)player)).setLastCompletedQuestTime(time);
    }

    public static Color getColor(class_1297 entity) {
        return ((MagicColorComponent)MAGIC_COLOR.get((Object)entity)).getColor();
    }

    public static class_243 getBoltPos(class_1309 entity) {
        return ((BoltTargetComponent)BOLT_TARGET.get((Object)entity)).getPos();
    }

    public static void setBoltPos(class_1309 entity, class_243 pos) {
        ((BoltTargetComponent)BOLT_TARGET.get((Object)entity)).setPos(pos);
    }

    public static boolean shouldRenderBolt(class_1309 entity) {
        return ((BoltTargetComponent)BOLT_TARGET.get((Object)entity)).shouldRender();
    }

    public static void setShouldRenderBolt(class_1309 entity, boolean shouldRender) {
        ((BoltTargetComponent)BOLT_TARGET.get((Object)entity)).setShouldRender(shouldRender);
    }

    public static void setBoltAge(class_1309 entity, int timer) {
        ((BoltTargetComponent)BOLT_TARGET.get((Object)entity)).setAge(timer);
    }

    public static SpellShape getSpellShape(class_1297 entity) {
        return ((SpellShapeComponent)SPELL_SHAPE.get((Object)entity)).getSpellShape();
    }

    public static void setSpellShape(class_1297 entity, SpellShape shape) {
        ((SpellShapeComponent)SPELL_SHAPE.get((Object)entity)).setSpellShape(shape);
    }

    public static void setScale(class_1297 entity, SpellEffect effect, double strength) {
        SIZE.maybeGet((Object)entity).ifPresent(size -> size.setScale(effect, strength));
    }

    public static void resetScale(class_1297 entity) {
        SIZE.maybeGet((Object)entity).ifPresent(SizeComponent::resetScale);
    }

    public static void createPortal(class_1657 player, class_3218 world, class_243 pos, double pullStrength) {
        ((PocketDimensionPortalComponent)POCKET_DIMENSION_PORTAL_COMPONENT.get((Object)player)).createPortal(world, pos, pullStrength);
    }

    public static class_243 getPortalPos(class_1657 player, class_1937 level) {
        return ((PocketDimensionPortalComponent)POCKET_DIMENSION_PORTAL_COMPONENT.get((Object)player)).getPortalPos(level);
    }

    public static int aggressorbCount(class_1309 entity) {
        return ((AggressorbComponent)entity.getComponent(AGGRESSORB_COMPONENT)).orbCount();
    }

    public static int aggressorbIndex(class_1309 entity, Aggressorb orb) {
        return ((AggressorbComponent)entity.getComponent(AGGRESSORB_COMPONENT)).orbIndex(orb);
    }

    public static void addAggressorbToEntity(class_1309 entity, UUID orbId) {
        ((AggressorbComponent)entity.getComponent(AGGRESSORB_COMPONENT)).addOrbToEntity(orbId);
    }

    public static void removeAggressorbFromEntity(class_1309 entity, UUID orbId) {
        ((AggressorbComponent)entity.getComponent(AGGRESSORB_COMPONENT)).removeOrbFromEntity(orbId);
    }

    public static UUID getGuardianOrbId(class_1309 entity) {
        return ((GuardianOrbComponent)entity.getComponent(GUARDIAN_ORB_COMPONENT)).getOrbId();
    }

    public static void setGuardianOrbManaLock(class_1309 entity, UUID orbId, int strength) {
        ((GuardianOrbComponent)entity.getComponent(GUARDIAN_ORB_COMPONENT)).setManaLock(orbId, strength);
    }

    public static void setPortalCoolDown(class_1297 entity, int cooldownTicks) {
        PORTAL_COOL_DOWN_COMPONENT.maybeGet((Object)entity).ifPresent(component -> component.setCoolDown(cooldownTicks));
    }

    public static boolean hasPortalCoolDown(class_1297 entity) {
        return PORTAL_COOL_DOWN_COMPONENT.maybeGet((Object)entity).map(PortalCoolDownComponent::hasCoolDown).orElse(false);
    }

    public static void setCounterProperties(class_1309 entity, @Nullable class_1309 caster, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> groups, int groupIndex, Color color, double potency, long worldTime) {
        ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).setProperties(caster, stack, effects, groups, groupIndex, color, potency, worldTime);
    }

    public static void removeCounter(class_1309 entity) {
        ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).removeCounter();
    }

    public static void castCounter(class_1309 entity, class_1309 attackingEntity) {
        ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).castCounter(attackingEntity);
    }

    public static boolean isCounterActive(class_1309 entity) {
        return ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).hasCounterActive(entity.method_37908());
    }

    public static Color getCounterColor(class_1309 entity) {
        return ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).getColor();
    }

    public static long getCounterEnd(class_1309 entity) {
        return ((CounterComponent)entity.getComponent(COUNTER_COMPONENT)).getEndTime();
    }

    public void registerScoreboardComponentFactories(ScoreboardComponentFactoryRegistry registry) {
        registry.registerScoreboardComponent(POCKET_DIMENSION_COMPONENT, PocketDimensionComponent::new);
    }
}

