/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.spell_components.shapes;

import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class BoltSpellShape
extends SpellShape {
    public BoltSpellShape() {
        super(ArcanusConfig.SpellShapes.BoltShapeProperties.enabled, ArcanusConfig.SpellShapes.BoltShapeProperties.weight, ArcanusConfig.SpellShapes.BoltShapeProperties.manaCost, ArcanusConfig.SpellShapes.BoltShapeProperties.manaMultiplier, ArcanusConfig.SpellShapes.BoltShapeProperties.coolDown, ArcanusConfig.SpellShapes.BoltShapeProperties.minimumLevel, ArcanusConfig.SpellShapes.BoltShapeProperties.potencyModifier, ArcanusConfig.SpellShapes.BoltShapeProperties.procsOnce);
    }

    @Override
    public void cast(@Nullable class_1309 caster, class_243 castFrom, @Nullable class_1297 castSource, class_3218 level, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> spellGroups, int groupIndex, double potency) {
        Object livingEntity;
        potency += this.getPotencyModifier();
        double range = ArcanusConfig.SpellShapes.BoltShapeProperties.range;
        class_1297 sourceEntity = castSource != null ? castSource : caster;
        class_238 box = new class_238(castFrom.method_1031(-range, -range, -range), castFrom.method_1031(range, range, range));
        List affectedEntities = level.method_8335(sourceEntity, box);
        Predicate<class_1297> predicate = entity -> {
            class_1309 livingEntity;
            if (entity.method_5829().method_994(sourceEntity.method_5829())) {
                return true;
            }
            if (sourceEntity instanceof class_1309 && !(livingEntity = (class_1309)sourceEntity).method_6057(entity)) {
                return false;
            }
            class_243 look = sourceEntity.method_5720();
            Optional vecOptional = entity.method_5829().method_1014(0.75).method_992(castFrom, castFrom.method_1019(look.method_1021(range)));
            return vecOptional.isPresent();
        };
        class_1297 entityTarget = BoltSpellShape.getClosestEntity(affectedEntities, range, castFrom, sourceEntity == caster ? predicate : entity -> true);
        class_243 castAt = castFrom;
        if (entityTarget != null) {
            castAt = entityTarget.method_19538();
            if (sourceEntity instanceof class_1309) {
                livingEntity = (class_1309)sourceEntity;
                ArcanusComponents.setBoltPos((class_1309)livingEntity, entityTarget.method_5829().method_1005());
            }
            for (SpellEffect effect : new HashSet<SpellEffect>(effects)) {
                effect.effect(caster, sourceEntity, (class_1937)level, (class_239)new class_3966(entityTarget), effects, stack, potency);
            }
        } else if (sourceEntity != null) {
            class_239 target = ArcanusHelper.raycast(sourceEntity, range, false, true);
            if (target.method_17783() == class_239.class_240.field_1332) {
                for (SpellEffect effect : new HashSet<SpellEffect>(effects)) {
                    effect.effect(caster, sourceEntity, (class_1937)level, target, effects, stack, potency);
                }
                castAt = target.method_17784();
            }
            if (target.method_17783() != class_239.class_240.field_1331 && sourceEntity instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)sourceEntity;
                ArcanusComponents.setBoltPos(livingEntity2, target.method_17784());
            }
        }
        if (sourceEntity instanceof class_1309) {
            livingEntity = (class_1309)sourceEntity;
            ArcanusComponents.setShouldRenderBolt((class_1309)livingEntity, true);
            ArcanusComponents.setBoltAge((class_1309)livingEntity, 0);
        }
        BoltSpellShape.castNext(caster, castAt, entityTarget, level, stack, spellGroups, groupIndex, potency);
    }

    @Nullable
    private static class_1297 getClosestEntity(List<class_1297> entityList, double range, class_243 pos, Predicate<class_1297> predicate) {
        double d = -1.0;
        class_1297 value = null;
        for (class_1297 entity : entityList) {
            double e;
            if (!predicate.test(entity) || !((e = entity.method_19538().method_1022(pos)) <= range) || d != -1.0 && !(e < d)) continue;
            d = e;
            value = entity;
        }
        return value;
    }
}

