/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.util;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.common.components.MagicColorComponent;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusEntityTags;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.TemporalDilationField;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.cammiescorner.arcanuscontinuum.common.util.supporters.WizardData;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class ArcanusHelper {
    public static boolean shouldTimeDilate(class_1297 target, class_1937 level) {
        return !target.method_5864().method_20210(ArcanusEntityTags.TEMPORAL_DILATION_IMMUNE) && !level.method_8333(target, target.method_5829(), entity -> entity instanceof TemporalDilationField && entity.method_19538().method_1031(0.0, 4.5, 0.0).method_1022(target.method_19538()) <= (double)(entity.method_17681() / 2.0f)).isEmpty();
    }

    public static Color getMagicColor(@Nullable Object provider) {
        class_8046 ownable;
        class_1297 owner;
        if (provider == null) {
            return Arcanus.DEFAULT_MAGIC_COLOUR;
        }
        MagicColorComponent component = (MagicColorComponent)ArcanusComponents.MAGIC_COLOR.getNullable(provider);
        if (component != null) {
            return component.getColor();
        }
        if (provider instanceof class_8046 && (owner = (ownable = (class_8046)provider).method_24921()) != null) {
            return ArcanusHelper.getMagicColor(owner);
        }
        return Arcanus.DEFAULT_MAGIC_COLOUR;
    }

    public static Color getPocketDimensionColor(@Nullable Object provider) {
        class_8046 ownable;
        class_1297 owner;
        if (provider == null) {
            return Arcanus.DEFAULT_MAGIC_COLOUR;
        }
        MagicColorComponent component = (MagicColorComponent)ArcanusComponents.MAGIC_COLOR.getNullable(provider);
        if (component != null) {
            return component.getPocketDimensionColor();
        }
        if (provider instanceof class_8046 && (owner = (ownable = (class_8046)provider).method_24921()) != null) {
            return ArcanusHelper.getPocketDimensionColor(owner);
        }
        return Arcanus.DEFAULT_MAGIC_COLOUR;
    }

    public static Color getMagicColor(@Nullable UUID playerId) {
        if (playerId == null || class_156.field_25140.equals(playerId)) {
            return Arcanus.DEFAULT_MAGIC_COLOUR;
        }
        return WizardData.getOrEmpty(playerId).magicColor();
    }

    public static Color getPocketDimensionColor(@Nullable UUID playerId) {
        if (playerId == null || class_156.field_25140.equals(playerId)) {
            return Arcanus.DEFAULT_MAGIC_COLOUR;
        }
        return WizardData.getOrEmpty(playerId).pocketDimensionColor();
    }

    public static class_239 raycast(class_1297 origin, double maxDistance, boolean includeEntities, boolean includeFluids) {
        class_3966 entityHitResult;
        class_243 startPos = origin.method_5836(1.0f);
        class_243 rotation = origin.method_5828(1.0f);
        class_243 endPos = startPos.method_1019(rotation.method_1021(maxDistance));
        class_3965 hitResult = origin.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, includeFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, origin));
        endPos = hitResult.method_17784();
        maxDistance *= maxDistance;
        if (includeEntities && (entityHitResult = class_1675.method_18075((class_1297)origin, (class_243)startPos, (class_243)endPos, (class_238)origin.method_5829().method_18804(rotation.method_1021(maxDistance)).method_1009(1.0, 1.0, 1.0), entity -> {
            Targetable targetable;
            return !entity.method_7325() && entity instanceof Targetable && (targetable = (Targetable)entity).arcanus$canBeTargeted();
        }, (double)maxDistance)) != null) {
            return entityHitResult;
        }
        return hitResult;
    }

    public static class_1799 applyColorToItem(class_1799 stack, int color) {
        stack.method_7911("display").method_10569("color", color);
        return stack;
    }

    public static void setMagicColorSource(Object obj, UUID sourceId) {
        ArcanusComponents.MAGIC_COLOR.maybeGet(obj).ifPresent(component -> component.setSourceId(sourceId));
    }

    public static void copyMagicColor(Object to, class_1297 from) {
        ArcanusComponents.MAGIC_COLOR.maybeGet((Object)from).ifPresent(sourceComponent -> ArcanusHelper.setMagicColorSource(to, sourceComponent.getSourceId()));
    }
}

