/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.util;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.cammiescorner.arcanuscontinuum.common.util.CodecHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Color {
    public static final Ordering DEFAULT_ORDERING = Ordering.RGBA;
    private final byte[] rgba;
    public static final Codec<Color> CODEC_ARGB = Codec.INT.xmap(intValue -> Color.fromInt(intValue, Ordering.ARGB), Color::asIntARGB);
    public static final Codec<Color> CODEC = Codec.either(CODEC_ARGB, (Codec)Ordering.CODEC.dispatch("ordering", c -> DEFAULT_ORDERING, Ordering::dispatchedCodec)).xmap(CodecHelper::unwrapEither, Either::left);

    private Color(int red, int green, int blue, int alpha) {
        this.rgba = new byte[]{(byte)red, (byte)green, (byte)blue, (byte)alpha};
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Objects.deepEquals(this.rgba, color.rgba);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rgba);
    }

    private static Color fromRGBA(int red, int green, int blue, int alpha) {
        Color.validateRange(red, "red");
        Color.validateRange(green, "green");
        Color.validateRange(blue, "blue");
        Color.validateRange(alpha, "alpha");
        return new Color(red, green, blue, alpha);
    }

    public static Color fromRGB(int red, int green, int blue) {
        Color.validateRange(red, "red");
        Color.validateRange(green, "green");
        Color.validateRange(blue, "blue");
        return new Color(red, green, blue, 255);
    }

    public static Color fromFloatsRGBA(float red, float green, float blue, float alpha) {
        return Color.fromRGBA((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static Color fromFloatsRGB(float red, float green, float blue) {
        return Color.fromRGB((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static Color fromIntArray(Ordering ordering, int ... values) {
        Preconditions.checkElementIndex((int)(ordering.expectedLength() - 1), (int)values.length);
        int red = ordering.hasRed() ? values[ordering.iR()] : 0;
        int green = ordering.hasGreen() ? values[ordering.iG()] : 0;
        int blue = ordering.hasBlue() ? values[ordering.iB()] : 0;
        int alpha = ordering.hasAlpha() ? values[ordering.iA()] : 255;
        return Color.fromRGBA(red, green, blue, alpha);
    }

    public static Color fromFloatArray(Ordering ordering, float ... values) {
        Preconditions.checkElementIndex((int)(ordering.expectedLength() - 1), (int)values.length);
        int red = ordering.hasRed() ? (int)(values[ordering.iR()] * 255.0f) : 0;
        int green = ordering.hasGreen() ? (int)(values[ordering.iG()] * 255.0f) : 0;
        int blue = ordering.hasBlue() ? (int)(values[ordering.iB()] * 255.0f) : 0;
        int alpha = ordering.hasAlpha() ? (int)(values[ordering.iA()] * 255.0f) : 255;
        return Color.fromRGBA(red, green, blue, alpha);
    }

    public int red() {
        return Byte.toUnsignedInt(this.rgba[0]);
    }

    public float redF() {
        return (float)this.red() / 255.0f;
    }

    public int green() {
        return Byte.toUnsignedInt(this.rgba[1]);
    }

    public float greenF() {
        return (float)this.green() / 255.0f;
    }

    public int blue() {
        return Byte.toUnsignedInt(this.rgba[2]);
    }

    public float blueF() {
        return (float)this.blue() / 255.0f;
    }

    public int alpha() {
        return Byte.toUnsignedInt(this.rgba[3]);
    }

    public float alphaF() {
        return (float)this.alpha() / 255.0f;
    }

    public float[] asFloatsRGBA() {
        return this.asFloats(Ordering.RGBA);
    }

    public float[] asFloats(Ordering ordering) {
        float[] values = new float[ordering.expectedLength];
        if (ordering.hasRed()) {
            values[ordering.iR()] = this.redF();
        }
        if (ordering.hasGreen()) {
            values[ordering.iG()] = this.greenF();
        }
        if (ordering.hasBlue()) {
            values[ordering.iB()] = this.blueF();
        }
        if (ordering.hasAlpha()) {
            values[ordering.iA()] = this.alphaF();
        }
        return values;
    }

    public int asIntARGB() {
        return this.asInt(Ordering.ARGB);
    }

    public int asInt(Ordering ordering) {
        int value = 0;
        int maxIdx = ordering.expectedLength() - 1;
        if (ordering.hasRed()) {
            assert (ordering.iR() <= maxIdx);
            value |= this.red() << (maxIdx - ordering.iR()) * 8;
        }
        if (ordering.hasGreen()) {
            assert (ordering.iG() <= maxIdx);
            value |= this.green() << (maxIdx - ordering.iG()) * 8;
        }
        if (ordering.hasBlue()) {
            assert (ordering.iB() <= maxIdx);
            value |= this.blue() << (maxIdx - ordering.iB()) * 8;
        }
        if (ordering.hasAlpha()) {
            assert (ordering.iA() <= maxIdx);
            value |= this.alpha() << (maxIdx - ordering.iA()) * 8;
        }
        return value;
    }

    public Vector4fc asVec() {
        return new Vector4f(this.redF(), this.greenF(), this.blueF(), this.alphaF());
    }

    public Vector3fc asVec3() {
        return new Vector3f(this.redF(), this.greenF(), this.blueF());
    }

    public static Color fromInt(int intValue, Ordering ordering) {
        int[] nArray;
        int c1 = intValue >> 24 & 0xFF;
        int c2 = intValue >> 16 & 0xFF;
        int c3 = intValue >> 8 & 0xFF;
        int c4 = intValue & 0xFF;
        if (ordering.expectedLength == 3) {
            int[] nArray2 = new int[3];
            nArray2[0] = c2;
            nArray2[1] = c3;
            nArray = nArray2;
            nArray2[2] = c4;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = c1;
            nArray3[1] = c2;
            nArray3[2] = c3;
            nArray = nArray3;
            nArray3[3] = c4;
        }
        int[] array = nArray;
        return Color.fromIntArray(ordering, array);
    }

    public static Color fromARGB(int argb) {
        return Color.fromInt(argb, Ordering.ARGB);
    }

    public static Color fromHSV(float hue, float saturation, float value) {
        int argb = class_3532.method_15369((float)hue, (float)saturation, (float)value);
        return Color.fromInt(argb, Ordering.ARGB);
    }

    public int placeAt(int value, int length, int idx) {
        return value << (length - idx) * 8;
    }

    private static void validateRange(int value, String name) {
        Preconditions.checkArgument((value >= 0 && value <= 255 ? 1 : 0) != 0, (Object)(name + " is not within [0, 255]"));
    }

    public static enum Ordering implements class_3542
    {
        RGBA("rgba", 0, 1, 2, 3),
        ARGB("argb", 1, 2, 3, 0),
        RGB("rgb", 0, 1, 2, -1),
        BGR("bgr", 2, 1, 0, -1);

        private final String name;
        private final int redIndex;
        private final int greenIndex;
        private final int blueIndex;
        private final int alphaIndex;
        private final int expectedLength;
        public static final Codec<Ordering> CODEC;
        private final Codec<Color> dispatchedCodec = class_5699.method_39240(() -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("value").forGetter(color -> color.asInt(this))).apply((Applicative)instance, intValue -> Color.fromInt(intValue, this))));

        private Ordering(String name, int redIndex, int greenIndex, int blueIndex, int alphaIndex) {
            this.name = name;
            this.redIndex = redIndex;
            this.greenIndex = greenIndex;
            this.blueIndex = blueIndex;
            this.alphaIndex = alphaIndex;
            this.expectedLength = (int)IntStream.of(redIndex, greenIndex, blueIndex, alphaIndex).filter(v -> v >= 0).count();
        }

        public int iR() {
            Preconditions.checkArgument((boolean)this.hasRed(), (Object)(String.valueOf((Object)this) + " does not have a RED component!"));
            return this.redIndex;
        }

        public int iG() {
            Preconditions.checkArgument((boolean)this.hasGreen(), (Object)(String.valueOf((Object)this) + " does not have a GREEN component!"));
            return this.greenIndex;
        }

        public int iB() {
            Preconditions.checkArgument((boolean)this.hasBlue(), (Object)(String.valueOf((Object)this) + " does not have a BLUE component!"));
            return this.blueIndex;
        }

        public int iA() {
            Preconditions.checkArgument((boolean)this.hasAlpha(), (Object)(String.valueOf((Object)this) + " does not have an ALPHA component!"));
            return this.alphaIndex;
        }

        public boolean hasRed() {
            return this.redIndex != -1;
        }

        public boolean hasGreen() {
            return this.greenIndex != -1;
        }

        public boolean hasBlue() {
            return this.blueIndex != -1;
        }

        public boolean hasAlpha() {
            return this.alphaIndex != -1;
        }

        public int expectedLength() {
            return this.expectedLength;
        }

        public String toString() {
            return "Color.Ordering." + this.name().toUpperCase(Locale.ROOT);
        }

        public String method_15434() {
            return this.name;
        }

        public Codec<Color> dispatchedCodec() {
            return this.dispatchedCodec;
        }

        static {
            CODEC = class_3542.method_28140(Ordering::values);
        }
    }
}

