/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.datagen.client;

import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusAdvancements;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusBiomeTags;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusBiomes;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusBlockTags;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusDimensionTags;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusEnchantmentTags;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusEntityTags;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusItemTags;
import dev.cammiescorner.arcanuscontinuum.common.items.BattleMageArmorItem;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlocks;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusDamageTypes;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEnchantments;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEntities;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusItems;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusMobEffects;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import dev.upcraft.sparkweave.api.registry.RegistrySupplier;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8112;
import org.jetbrains.annotations.Nullable;

public class ArcanusEnglishLanguageProvider
extends FabricLanguageProvider {
    private final CompletableFuture<class_7225.class_7874> registriesFuture;

    public ArcanusEnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(dataOutput);
        this.registriesFuture = registriesFuture;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        builder.add(ArcanusItems.ITEM_GROUP.getRegistryKey(), "Arcanus: Continuum");
        builder.add((class_1792)ArcanusItems.WOODEN_STAFF.get(), "Wooden Staff");
        builder.add((class_1792)ArcanusItems.CRYSTAL_STAFF.get(), "Crystal Staff");
        builder.add((class_1792)ArcanusItems.DIVINATION_STAFF.get(), "Divination Staff");
        builder.add((class_1792)ArcanusItems.CRESCENT_STAFF.get(), "Crescent Staff");
        builder.add((class_1792)ArcanusItems.ANCIENT_STAFF.get(), "Ancient Staff");
        builder.add((class_1792)ArcanusItems.WAND.get(), "Wand");
        builder.add((class_1792)ArcanusItems.THAUMATURGES_GAUNTLET.get(), "Thaumaturge's Gauntlet");
        builder.add((class_1792)ArcanusItems.MIND_STAFF.get(), "Mind Staff");
        builder.add((class_1792)ArcanusItems.MAGIC_TOME.get(), "Magic Tome");
        builder.add((class_1792)ArcanusItems.MAGE_PISTOL.get(), "Mage Pistol");
        builder.add((class_1792)ArcanusItems.WIZARD_HAT.get(), "Wizard Hat");
        builder.add((class_1792)ArcanusItems.WIZARD_ROBES.get(), "Wizard Robes");
        builder.add((class_1792)ArcanusItems.WIZARD_PANTS.get(), "Wizard Pants");
        builder.add((class_1792)ArcanusItems.WIZARD_BOOTS.get(), "Wizard Boots");
        builder.add((class_1792)ArcanusItems.SPELL_BOOK.get(), "Spell Book");
        builder.add((class_1792)ArcanusItems.SCROLL_OF_KNOWLEDGE.get(), "Scroll of Knowledge");
        builder.add((class_1792)ArcanusItems.WIZARD_SPAWN_EGG.get(), "Wizard Spawn Egg");
        builder.add((class_1792)ArcanusItems.OPOSSUM_SPAWN_EGG.get(), "Opossum Spawn Egg");
        builder.add((class_1792)ArcanusItems.BATTLE_MAGE_UPGRADE_SMITHING_TEMPLATE.get(), "Smithing Template");
        builder.add("upgrade.arcanuscontinuum.battle_mage_upgrade", "Battle Mage Upgrade");
        builder.add("item.arcanuscontinuum.smithing_template.battle_mage_upgrade.applies_to", "Diamond Armor");
        builder.add("item.arcanuscontinuum.smithing_template.battle_mage_upgrade.ingredients", "Amethyst Shard");
        builder.add("item.arcanuscontinuum.smithing_template.battle_mage_upgrade.base_slot_description", "Add diamond armor");
        builder.add("item.arcanuscontinuum.smithing_template.battle_mage_upgrade.additions_slot_description", "Add Amethyst Shard");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28704, false), "Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28704, true), "Waxed Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28705, false), "Exposed Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28705, true), "Waxed Exposed Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28706, false), "Weathered Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28706, true), "Waxed Weathered Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28707, false), "Oxidized Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_HELMET, class_5955.class_5811.field_28707, true), "Waxed Oxidized Battle Mage Helmet");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28704, false), "Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28704, true), "Waxed Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28705, false), "Exposed Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28705, true), "Waxed Exposed Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28706, false), "Weathered Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28706, true), "Waxed Weathered Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28707, false), "Oxidized Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_CHESTPLATE, class_5955.class_5811.field_28707, true), "Waxed Oxidized Battle Mage Chestplate");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28704, false), "Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28704, true), "Waxed Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28705, false), "Exposed Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28705, true), "Waxed Exposed Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28706, false), "Weathered Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28706, true), "Waxed Weathered Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28707, false), "Oxidized Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_LEGGINGS, class_5955.class_5811.field_28707, true), "Waxed Oxidized Battle Mage Leggings");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28704, false), "Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28704, true), "Waxed Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28705, false), "Exposed Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28705, true), "Waxed Exposed Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28706, false), "Weathered Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28706, true), "Waxed Weathered Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28707, false), "Oxidized Battle Mage Boots");
        this.itemStack(builder, BattleMageArmorItem.getStack(ArcanusItems.BATTLE_MAGE_BOOTS, class_5955.class_5811.field_28707, true), "Waxed Oxidized Battle Mage Boots");
        this.biome(builder, ArcanusBiomes.POCKET_DIMENSION, "Pocket Dimension");
        builder.add((class_2248)ArcanusBlocks.ARCANE_WORKBENCH.get(), "Arcane Workbench");
        builder.add((class_2248)ArcanusBlocks.DUMMY_BOOKSHELF.get(), "[DEVELOPER ONLY] Dummy Chiseled Bookshelf");
        builder.add((class_2248)ArcanusBlocks.MAGIC_BLOCK.get(), "Magic Block");
        builder.add((class_2248)ArcanusBlocks.MAGIC_DOOR.get(), "Magic Door");
        builder.add((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT.get(), "Spatial Rift Exit");
        builder.add((class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get(), "Spatial Rift Wall");
        builder.add((class_2248)ArcanusBlocks.SPATIAL_RIFT_WALL.get(), "Spatial Rift Wall");
        builder.add((class_1299)ArcanusEntities.AGGRESSORB.get(), "Aggressorb");
        builder.add((class_1299)ArcanusEntities.AOE.get(), "Area Of Effect");
        builder.add((class_1299)ArcanusEntities.BEAM.get(), "Beam");
        builder.add((class_1299)ArcanusEntities.ENTANGLED_ORB.get(), "Entangled Orb");
        builder.add((class_1299)ArcanusEntities.MISSILE.get(), "Missile");
        builder.add((class_1299)ArcanusEntities.LOB.get(), "Lob");
        builder.add((class_1299)ArcanusEntities.MAGIC_RUNE.get(), "Magic Rune");
        builder.add((class_1299)ArcanusEntities.MANA_SHIELD.get(), "Mana Shield");
        builder.add((class_1299)ArcanusEntities.NECRO_SKELETON.get(), "Necro Skeleton");
        builder.add((class_1299)ArcanusEntities.OPOSSUM.get(), "Opossum");
        builder.add((class_1299)ArcanusEntities.PORTAL.get(), "Pocket Dimension Portal");
        builder.add((class_1299)ArcanusEntities.SMITE.get(), "Smite");
        builder.add((class_1299)ArcanusEntities.WIZARD.get(), "Wizard");
        builder.add((class_1887)ArcanusEnchantments.MANA_POOL.get(), "Mana Pool");
        builder.add((class_1291)ArcanusMobEffects.ANONYMITY.get(), "Anonymity");
        builder.add((class_1291)ArcanusMobEffects.BOUNCY.get(), "Bouncy");
        builder.add((class_1291)ArcanusMobEffects.COPPER_CURSE.get(), "Copper Curse");
        builder.add((class_1291)ArcanusMobEffects.DANGER_SENSE.get(), "Danger Sense");
        builder.add((class_1291)ArcanusMobEffects.DISCOMBOBULATE.get(), "Discombobulate");
        builder.add((class_1291)ArcanusMobEffects.FLOAT.get(), "Float");
        builder.add((class_1291)ArcanusMobEffects.FORTIFY.get(), "Fortify");
        builder.add((class_1291)ArcanusMobEffects.MANA_LOCK.get(), "Mana Lock");
        builder.add((class_1291)ArcanusMobEffects.MANA_WINGS.get(), "Mana Wings");
        builder.add((class_1291)ArcanusMobEffects.STOCKPILE.get(), "Stockpile");
        builder.add((class_1291)ArcanusMobEffects.VULNERABILITY.get(), "Vulnerability");
        builder.add((class_1291)ArcanusMobEffects.SHRINK.get(), "Shrink");
        builder.add((class_1291)ArcanusMobEffects.ENLARGE.get(), "Enlarge");
        this.tag(builder, ArcanusBiomeTags.C_HAS_VILLAGE, "Has Village");
        this.tag(builder, ArcanusBiomeTags.HAS_WIZARD_TOWER, "Has Wizard Tower");
        this.tag(builder, ArcanusBiomeTags.IS_POCKET_DIMENSION, "Is Pocket Dimension");
        this.tag(builder, ArcanusBlockTags.WARDING_NOT_ALLOWED, "Warding Not Allowed");
        this.tag(builder, ArcanusDimensionTags.WARDING_NOT_ALLOWED, "Warding Not Allowed");
        this.tag(builder, ArcanusEntityTags.C_IMMOVABLE, "Immovable");
        this.tag(builder, ArcanusEntityTags.DISPELLABLE, "Dispellable");
        this.tag(builder, ArcanusEntityTags.RUNE_TRIGGER_IGNORED, "Does not trigger Magic Runes");
        this.tag(builder, ArcanusEntityTags.SPATIAL_RIFT_IMMUNE, "Immune to Spatial Rifts");
        this.tag(builder, ArcanusEntityTags.TEMPORAL_DILATION_IMMUNE, "Immune to Temporal Dilation Fields");
        this.tag(builder, ArcanusEnchantmentTags.MANA_POOL_COMPATIBLE_WITH, "Compatible enchantments for Mana Pool");
        this.tag(builder, ArcanusItemTags.C_FEATHERS, "Feathers");
        this.tag(builder, ArcanusItemTags.CRAFTING_SPELLBINDING_SPELLBOOKS, "Spellbooks");
        this.tag(builder, ArcanusItemTags.COPPER_CURSE_IMMUNE, "Ignored by Copper Curse");
        this.tag(builder, ArcanusItemTags.STAVES, "Staves");
        this.tag(builder, ArcanusItemTags.STAVES_FOR_WIZARDS, "Staves for Wizards");
        this.tag(builder, ArcanusItemTags.WIZARD_ARMOR, "Wizard Armor");
        builder.add("text.arcanuscontinuum.block_is_warded", "This block is warded.");
        builder.add("text.arcanuscontinuum.cannot_ward_in_dimension", "Cannot ward blocks in this dimension!");
        builder.add("text.arcanuscontinuum.cannot_ward_block", "Cannot ward this block!");
        builder.add("text.arcanuscontinuum.disabled_component", "This spell contains one or more disabled spell components. Aborting spell.");
        builder.add("text.arcanuscontinuum.too_many_orbs", "That target already has the maximum amount of Aggressorbs!");
        builder.add("text.arcanuscontinuum.use_item.scroll_of_knowledge", "You feel a little smarter...");
        builder.add("text.arcanuscontinuum.use_item.scroll_of_knowledge.max_level", "You have learned everything you can.");
        builder.add("text.arcanuscontinuum.wizard_dialogue.no_wizard_armor", "Come back to me when you look like a wizard.");
        builder.add("tooltip.arcanuscontinuum.wizard_dialogue.no_wizard_armor", "Maybe wearing Wizard Robes will help...");
        builder.add("door.arcanuscontinuum.access_granted", "Access Granted...");
        builder.add("door.arcanuscontinuum.not_owner", "You do not own this door");
        builder.add("door.arcanuscontinuum.say_magic_word", "This door needs a magic word to open");
        builder.add("door.arcanuscontinuum.password_set", "Password set to %s");
        builder.add("staff.arcanuscontinuum.invalid_data", "!!! INVALID DATA !!!");
        builder.add("staff.arcanuscontinuum.primary_color", "Focus Color");
        builder.add("staff.arcanuscontinuum.secondary_color", "Body Color");
        builder.add("command.arcanuscontinuum.pocket_dimension.regenerate.success.walls_only", "Repaired the walls of %s's pocket dimension");
        builder.add("command.arcanuscontinuum.pocket_dimension.regenerate.success.full", "Regenerated %s's pocket dimension");
        builder.add("command.arcanuscontinuum.pocket_dimension.regenerate.warn.teleport", "The pocket dimension plot you were in has been cleared by an admin.");
        builder.add("command.arcanuscontinuum.pocket_dimension.export.success", "Successfully exported %s's pocket dimension");
        builder.add("command.arcanuscontinuum.pocket_dimension.export.error.dimension_not_found", "unable to find %s!");
        builder.add("command.arcanuscontinuum.pocket_dimension.export.error.pocket_not_found", "Pocket dimension for player %s has not been created yet!");
        builder.add("command.arcanuscontinuum.wizard_level.get.success", "%s's wizard level is %s");
        builder.add("command.arcanuscontinuum.wizard_level.set.success", "Set %s's wizard level to %s");
        this.advancement(builder, ArcanusAdvancements.ARCANE_ROOT, "Arcanus: Continuum", "[insert witty sales pitch for something you're already playing]");
        this.advancement(builder, ArcanusAdvancements.A_MAGICAL_CRYSTAL, "A Magical Crystal", "Find an Amethyst Shard");
        this.advancement(builder, ArcanusAdvancements.ARCANE_ARTIFICE, "Arcane Artifice", "Craft an Arcane Workbench");
        this.advancement(builder, ArcanusAdvancements.MAGICAL_MEET_AND_GREET, "Magical Meet & Greet", "Find a Wizard Tower and meet the residents");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_1, "First Steps", "Obtain your first Scroll of Knowledge from a Wizard");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_2, "Wizard Level 2", "Use a Scroll of Knowledge to reach level 2");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_3, "Wizard Level 3", "Use a Scroll of Knowledge to reach level 3");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_4, "Wizard Level 4", "Use a Scroll of Knowledge to reach level 4");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_5, "Wizard Level 5", "Use a Scroll of Knowledge to reach level 5");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_6, "Wizard Level 6", "Use a Scroll of Knowledge to reach level 6");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_7, "Wizard Level 7", "Use a Scroll of Knowledge to reach level 7");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_8, "Wizard Level 8", "Use a Scroll of Knowledge to reach level 8");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_9, "Wizard Level 9", "Use a Scroll of Knowledge to reach level 9");
        this.advancement(builder, ArcanusAdvancements.WIZARD_LEVEL_10, "Master of The Arcane", "Achieve maximum magical power!");
        this.damageType(builder, ArcanusDamageTypes.MAGIC, "%s was killed by %s using magic", null, "%s was killed by %s using magic with %s");
        this.damageType(builder, ArcanusDamageTypes.MAGIC_PROJECTILE, "%s was shot by %s using magic", null, "%s was shot by %s using magic with %s");
        builder.add((class_1320)ArcanusEntityAttributes.MAX_MANA.get(), "Max Mana");
        builder.add((class_1320)ArcanusEntityAttributes.MANA_REGEN.get(), "Mana Regeneration");
        builder.add((class_1320)ArcanusEntityAttributes.BURNOUT_REGEN.get(), "Burnout Regeneration");
        builder.add((class_1320)ArcanusEntityAttributes.MANA_LOCK.get(), "Mana Lock");
        builder.add((class_1320)ArcanusEntityAttributes.SPELL_POTENCY.get(), "Spell Potency");
        builder.add((class_1320)ArcanusEntityAttributes.MANA_COST.get(), "Mana Cost");
        builder.add((class_1320)ArcanusEntityAttributes.MAGIC_RESISTANCE.get(), "Magic Resistance");
        builder.add((class_1320)ArcanusEntityAttributes.SPELL_COOL_DOWN.get(), "Spell Cooldown");
        builder.add(SpellComponent.DISABLED_TRANSLATION_KEY, "Unreadable Text");
        this.spell(builder, ArcanusSpellComponents.EMPTY, "EMPTY");
        this.spell(builder, ArcanusSpellComponents.SELF, "Self Shape");
        this.spell(builder, ArcanusSpellComponents.TOUCH, "Touch Shape");
        this.spell(builder, ArcanusSpellComponents.MISSILE, "Missile Shape");
        this.spell(builder, ArcanusSpellComponents.LOB, "Lob Shape");
        this.spell(builder, ArcanusSpellComponents.BOLT, "Bolt Shape");
        this.spell(builder, ArcanusSpellComponents.BEAM, "Beam Shape");
        this.spell(builder, ArcanusSpellComponents.RUNE, "Rune Shape");
        this.spell(builder, ArcanusSpellComponents.SMITE, "Smite Shape");
        this.spell(builder, ArcanusSpellComponents.AOE, "Area Of Effect Shape");
        this.spell(builder, ArcanusSpellComponents.BURST, "Burst Shape");
        this.spell(builder, ArcanusSpellComponents.GUIDED_SHOT, "Guided Shot Shape");
        this.spell(builder, ArcanusSpellComponents.COUNTER, "Counter Shape");
        this.spell(builder, ArcanusSpellComponents.ENTANGLED_ORB, "Entangled Orb Shape");
        this.spell(builder, ArcanusSpellComponents.AGGRESSORB, "Aggressorb Shape");
        this.spell(builder, ArcanusSpellComponents.DAMAGE, "Damage Effect");
        this.spell(builder, ArcanusSpellComponents.HEAL, "Heal Effect");
        this.spell(builder, ArcanusSpellComponents.FIRE, "Fire Effect");
        this.spell(builder, ArcanusSpellComponents.ELECTRIC, "Electric Effect");
        this.spell(builder, ArcanusSpellComponents.ICE, "Ice Effect");
        this.spell(builder, ArcanusSpellComponents.PUSH, "Push Effect");
        this.spell(builder, ArcanusSpellComponents.PULL, "Pull Effect");
        this.spell(builder, ArcanusSpellComponents.TELEPORT, "Teleport Effect");
        this.spell(builder, ArcanusSpellComponents.DISPEL, "Dispel Effect");
        this.spell(builder, ArcanusSpellComponents.MANA_LOCK, "Mana Lock Effect");
        this.spell(builder, ArcanusSpellComponents.WITHERING, "Withering Effect");
        this.spell(builder, ArcanusSpellComponents.REGENERATE, "Regenerate Effect");
        this.spell(builder, ArcanusSpellComponents.VULNERABILITY, "Vulnerability Effect");
        this.spell(builder, ArcanusSpellComponents.FORTIFY, "Fortify Effect");
        this.spell(builder, ArcanusSpellComponents.BOUNCY, "Bouncy Effect");
        this.spell(builder, ArcanusSpellComponents.FEATHER, "Feather Effect");
        this.spell(builder, ArcanusSpellComponents.POWER, "Power Effect");
        this.spell(builder, ArcanusSpellComponents.NECROMANCY, "Necromancy Effect");
        this.spell(builder, ArcanusSpellComponents.MANA_SPLIT, "Mana Split Effect");
        this.spell(builder, ArcanusSpellComponents.ANONYMITY, "Anonymity Effect");
        this.spell(builder, ArcanusSpellComponents.MINE, "Mine Effect");
        this.spell(builder, ArcanusSpellComponents.BUILD, "Build Effect");
        this.spell(builder, ArcanusSpellComponents.LEVITATE, "Levitate Effect");
        this.spell(builder, ArcanusSpellComponents.GROWTH, "Growth Effect");
        this.spell(builder, ArcanusSpellComponents.MANA_SHIELD, "Mana Shield Effect");
        this.spell(builder, ArcanusSpellComponents.TEMPORAL_DILATION, "Temporal Dilation Effect");
        this.spell(builder, ArcanusSpellComponents.SPEED, "Speed Effect");
        this.spell(builder, ArcanusSpellComponents.SHRINK, "Shrink Effect");
        this.spell(builder, ArcanusSpellComponents.ENLARGE, "Enlarge Effect");
        this.spell(builder, ArcanusSpellComponents.COPPER_CURSE, "Copper Curse Effect");
        this.spell(builder, ArcanusSpellComponents.SPATIAL_RIFT, "Spatial Rift Effect");
        this.spell(builder, ArcanusSpellComponents.WARDING, "Warding Effect");
        this.spell(builder, ArcanusSpellComponents.DISCOMBOBULATE, "Discombobulate Effect");
        this.spell(builder, ArcanusSpellComponents.HASTE, "Haste Effect");
        this.spell(builder, ArcanusSpellComponents.FLOAT, "Float Effect");
        this.spell(builder, ArcanusSpellComponents.MANA_WINGS, "Mana Wings Effect");
        this.spell(builder, ArcanusSpellComponents.STOCKPILE, "Stockpile Effect");
        this.spell(builder, ArcanusSpellComponents.DANGER_SENSE, "Danger Sense Effect");
        builder.add("screen.arcanuscontinuum.tooltip.component_count", "Spell Components");
        builder.add("screen.arcanuscontinuum.tooltip.change_screens", "Change Mode");
        builder.add("screen.arcanuscontinuum.tooltip.cycle_up", "Previous Skin");
        builder.add("screen.arcanuscontinuum.tooltip.cycle_down", "Next Skin");
        builder.add("screen.arcanuscontinuum.tooltip.undo", "Undo");
        builder.add("screen.arcanuscontinuum.tooltip.redo", "Redo");
        builder.add("screen.arcanuscontinuum.check.enabled", "\u2713");
        builder.add("screen.arcanuscontinuum.check.disabled", "\u2718");
        builder.add("screen.arcanuscontinuum.support_us.title", "Support %s");
        builder.add("screen.arcanuscontinuum.support_us.title2", "Arcanus: Continuum");
        builder.add("screen.arcanuscontinuum.support_us.welcome_message", "Hey there, %s! If you wish to support the development of our many mods, please consider donating.");
        builder.add("screen.arcanuscontinuum.support_us.perks_message", "Monthly subscribers get various perks across our mods, like being able to customize your magic color as well as access to more staves/wands!");
        builder.add("screen.arcanuscontinuum.support_us.button_support_cammie", "Support Cammie!");
        builder.add("screen.arcanuscontinuum.support_us.button_support_up", "Support Up!");
        builder.add("spell_book.arcanuscontinuum.weight", "Weight");
        builder.add("spell_book.arcanuscontinuum.weight.none", "None");
        builder.add("spell_book.arcanuscontinuum.weight.very_light", "Very Light");
        builder.add("spell_book.arcanuscontinuum.weight.light", "Light");
        builder.add("spell_book.arcanuscontinuum.weight.medium", "Medium");
        builder.add("spell_book.arcanuscontinuum.weight.heavy", "Heavy");
        builder.add("spell_book.arcanuscontinuum.weight.very_heavy", "Very Heavy");
        builder.add("spell_book.arcanuscontinuum.mana_cost", "Mana Cost");
        builder.add("spell_book.arcanuscontinuum.mana_multiplier", "Mana Multiplier");
        builder.add("spell_book.arcanuscontinuum.potency_modifier", "Potency Modifier");
        builder.add("spell_book.arcanuscontinuum.cool_down", "Cool Down");
        builder.add("spell_book.arcanuscontinuum.seconds", "s");
        builder.add("spell.arcanuscontinuum.too_many_components", "Too many components!");
        builder.add("spell.arcanuscontinuum.too_low_level", "Wizard level too low!");
        builder.add("spell.arcanuscontinuum.not_enough_mana", "Not enough mana!");
        builder.add("item.arcanuscontinuum.compendium_arcanus", "Compendium Arcanus");
        builder.add("item.arcanuscontinuum.compendium_arcanus.landing_text", "Arcanus: Continuum introduces a new magic system to the world of Minecraft. Players can create their own custom spells to suit however they like to play the game!");
        builder.add("config.arcanuscontinuum.supporter_settings", "Supporter Perks");
        builder.add("config.arcanuscontinuum.supporter_settings.magic_color", "Magic Color");
        builder.add("config.arcanuscontinuum.supporter_settings.pocket_dimension_color", "Pocket Dimension Color");
        builder.add("config.arcanuscontinuum.supporter_settings.halo_color", "Halo Color");
        builder.add("config.arcanuscontinuum.supporter_settings.halo_enabled", "Halo Enabled");
        builder.add("config.arcanuscontinuum.supporter_settings.halo_disabled", "Halo Disabled");
        builder.add("config.arcanuscontinuum.supporter_settings.save_and_exit", "Save and Exit");
        builder.add("config.arcanuscontinuum.supporter_settings.saving", "Saving...");
        builder.add("config.arcanuscontinuum.enchantments_category", "Enchantments");
        builder.add("config.arcanuscontinuum.mana_pool", "Mana Pool");
        builder.add("config.arcanuscontinuum.spellShapesCategory", "Spell Shapes");
        builder.add("config.arcanuscontinuum.attackEffectsCategory", "Attack Effects");
        builder.add("config.arcanuscontinuum.supportEffectsCategory", "Support Effects");
        builder.add("config.arcanuscontinuum.utilityEffectsCategory", "Utility Effects");
        builder.add("config.arcanuscontinuum.movementEffectsCategory", "Movement Effects");
        builder.add("config.arcanuscontinuum.casting_has_speed_limit", "Use Attack Cool Down for Casting?");
        builder.add("config.arcanuscontinuum.sizeChangingIsPermanent", "Size Changing Effects are Permanent for Players and Tamed Animals (Requires Pehkui)");
        builder.add("config.arcanuscontinuum.max_enchantment_level", "Max Enchantment Level");
        builder.add("config.arcanuscontinuum.mana_per_level", "Extra Mana Per Level");
        builder.add("config.arcanuscontinuum.mana_modifier_operation", "Mana Modifier Operation");
        builder.add("config.arcanuscontinuum.enabled", "Enabled (Requires Restart)");
        builder.add("config.arcanuscontinuum.weight", "Weight (Requires Restart)");
        builder.add("config.arcanuscontinuum.manaCost", "Mana Cost (Requires Restart)");
        builder.add("config.arcanuscontinuum.manaMultiplier", "Mana Multiplier (Requires Restart)");
        builder.add("config.arcanuscontinuum.coolDown", "Cool Down (Requires Restart)");
        builder.add("config.arcanuscontinuum.minimumLevel", "Minimum Level (Requires Restart)");
        builder.add("config.arcanuscontinuum.procsOnce", "Only Procs Once When Chained (Requires Restart)");
        builder.add("config.arcanuscontinuum.potencyModifier", "Potency Modifier (Requires Restart)");
        builder.add("config.arcanuscontinuum.projectileSpeed", "Projectile Speed");
        builder.add("config.arcanuscontinuum.baseLifeSpan", "Base Life Span");
        builder.add("config.arcanuscontinuum.lifeSpanModifier", "Life Span Modifier");
        builder.add("config.arcanuscontinuum.range", "Range");
        builder.add("config.arcanuscontinuum.delay", "Delay");
        builder.add("config.arcanuscontinuum.burstShape.radius", "Burst Radius");
        builder.add("config.arcanuscontinuum.maximumManaLock", "Maximum Mana Lock");
        builder.add("config.arcanuscontinuum.maximumAggressorbs", "Maximum Aggressorbs");
        builder.add("config.arcanuscontinuum.aggressorbsPerCast", "How Many Aggressorbs Spawn per Cast");
        builder.add("config.arcanuscontinuum.baseDamage", "Base Damage");
        builder.add("config.arcanuscontinuum.baseTimeOnFire", "Base Time On Fire");
        builder.add("config.arcanuscontinuum.baseStunTime", "Base Stun Time");
        builder.add("config.arcanuscontinuum.wetEntityDamageMultiplier", "Damage Multiplier Against Wet Entities");
        builder.add("config.arcanuscontinuum.baseFreezingTime", "Base Freezing Time");
        builder.add("config.arcanuscontinuum.baseEffectDuration", "Base Effect Duration");
        builder.add("config.arcanuscontinuum.baseHealth", "Base Health");
        builder.add("config.arcanuscontinuum.effectDurationModifier", "Effect Duration Modifier");
        builder.add("config.arcanuscontinuum.damageNeededToIncrease", "Damage Needed To Increase");
        builder.add("config.arcanuscontinuum.baseHealAmount", "Base Heal Amount");
        builder.add("config.arcanuscontinuum.baseChanceToActivate", "Base Chance To Activate");
        builder.add("config.arcanuscontinuum.basePower", "Base Power");
        builder.add("config.arcanuscontinuum.baseShrinkAmount", "Base Shrink Amount");
        builder.add("config.arcanuscontinuum.baseEnlargeAmount", "Base Enlarge Amount");
        builder.add("config.arcanuscontinuum.canSuckEntitiesIn", "Can Suck Entities In");
        builder.add("config.arcanuscontinuum.portalGrowTime", "Spatial Rift Grow Time");
        builder.add("config.arcanuscontinuum.pocketWidth", "Pocket Dimension Width");
        builder.add("config.arcanuscontinuum.pocketHeight", "Pocket Dimension Height");
        builder.add("config.arcanuscontinuum.canBeRemovedByOthers", "Can Be Removed By Other Players");
        builder.add("config.arcanuscontinuum.basePushAmount", "Base Push Strength");
        builder.add("config.arcanuscontinuum.basePullAmount", "Base Pull Strength");
        builder.add("config.arcanuscontinuum.baseTeleportDistance", "Base Teleport Distance");
        builder.add("config.arcanuscontinuum.removedUponTakingDamage", "Removed Upon Taking Damage");
        builder.add("config.arcanuscontinuum.baseMovementSpeed", "Base Movement Speed");
        builder.add("config.arcanuscontinuum.baseManaDrain", "Base Mana Drain");
        builder.add("config.arcanuscontinuum.timesToApplyEffects", "Number of Times to Apply Spell Effects");
        builder.add("config.arcanuscontinuum.timesToCastNextShape", "Number of Times to Cast Next Spell Shape");
        builder.add("config.arcanuscontinuum.selfShapeProperties", "Self Shape");
        builder.add("config.arcanuscontinuum.touchShapeProperties", "Touch Shape");
        builder.add("config.arcanuscontinuum.missileShapeProperties", "Missile Shape");
        builder.add("config.arcanuscontinuum.lobShapeProperties", "Lob Shape");
        builder.add("config.arcanuscontinuum.boltShapeProperties", "Bolt Shape");
        builder.add("config.arcanuscontinuum.beamShapeProperties", "Beam Shape");
        builder.add("config.arcanuscontinuum.runeShapeProperties", "Rune Shape");
        builder.add("config.arcanuscontinuum.burstShapeProperties", "Burst Shape");
        builder.add("config.arcanuscontinuum.counterShapeProperties", "Counter Shape");
        builder.add("config.arcanuscontinuum.aoeShapeProperties", "Area Of Effect Shape");
        builder.add("config.arcanuscontinuum.smiteShapeProperties", "Smite Shape");
        builder.add("config.arcanuscontinuum.entangledOrbShapeProperties", "Entangled Orb Shape");
        builder.add("config.arcanuscontinuum.aggressorbShapeProperties", "Aggressorb Shape");
        builder.add("config.arcanuscontinuum.damageEffectProperties", "Damage Effect");
        builder.add("config.arcanuscontinuum.fireEffectProperties", "Fire Effect");
        builder.add("config.arcanuscontinuum.electricEffectProperties", "Electric Effect");
        builder.add("config.arcanuscontinuum.iceEffectProperties", "Ice Effect");
        builder.add("config.arcanuscontinuum.vulnerabilityEffectProperties", "Vulnerability Effect");
        builder.add("config.arcanuscontinuum.manaLockEffectProperties", "Mana Lock Effect");
        builder.add("config.arcanuscontinuum.witheringEffectProperties", "Withering Effect");
        builder.add("config.arcanuscontinuum.necromancyEffectProperties", "Necromancy Effect");
        builder.add("config.arcanuscontinuum.manaSplitEffectProperties", "Mana Split Effect");
        builder.add("config.arcanuscontinuum.copperCurseEffectProperties", "Copper Curse Effect");
        builder.add("config.arcanuscontinuum.discombobulateEffectProperties", "Discombobulate Effect");
        builder.add("config.arcanuscontinuum.stockpileEffectProperties", "Stockpile Effect");
        builder.add("config.arcanuscontinuum.healEffectProperties", "Heal Effect");
        builder.add("config.arcanuscontinuum.dispelEffectProperties", "Dispel Effect");
        builder.add("config.arcanuscontinuum.regenerateEffectProperties", "Regenerate Effect");
        builder.add("config.arcanuscontinuum.fortifyEffectProperties", "Fortify Effect");
        builder.add("config.arcanuscontinuum.hasteEffectProperties", "Haste Effect");
        builder.add("config.arcanuscontinuum.manaShieldEffectProperties", "Mana Shield Effect");
        builder.add("config.arcanuscontinuum.dangerSenseEffectProperties", "Danger Sense Effect");
        builder.add("config.arcanuscontinuum.temporalDilationEffectProperties", "Temporal Dilation Effect");
        builder.add("config.arcanuscontinuum.pushEffectProperties", "Push Effect");
        builder.add("config.arcanuscontinuum.pullEffectProperties", "Pull Effect");
        builder.add("config.arcanuscontinuum.powerEffectProperties", "Power Effect");
        builder.add("config.arcanuscontinuum.anonymityEffectProperties", "Anonymity Effect");
        builder.add("config.arcanuscontinuum.mineEffectProperties", "Mine Effect");
        builder.add("config.arcanuscontinuum.growthEffectProperties", "Growth Effect");
        builder.add("config.arcanuscontinuum.shrinkEffectProperties", "Shrink Effect");
        builder.add("config.arcanuscontinuum.enlargeEffectProperties", "Enlarge Effect");
        builder.add("config.arcanuscontinuum.spatialRiftEffectProperties", "Spatial Rift Effect");
        builder.add("config.arcanuscontinuum.wardingEffectProperties", "Warding Effect");
        builder.add("config.arcanuscontinuum.buildEffectProperties", "Build Effect");
        builder.add("config.arcanuscontinuum.levitateEffectProperties", "Levitate Effect");
        builder.add("config.arcanuscontinuum.speedEffectProperties", "Speed Effect");
        builder.add("config.arcanuscontinuum.teleportEffectProperties", "Teleport Effect");
        builder.add("config.arcanuscontinuum.bouncyEffectProperties", "Bouncy Effect");
        builder.add("config.arcanuscontinuum.featherEffectProperties", "Feather Effect");
        builder.add("config.arcanuscontinuum.floatEffectProperties", "Float Effect");
        builder.add("config.arcanuscontinuum.manaWingsEffectProperties", "Mana Wings Effect");
    }

    private void damageType(FabricLanguageProvider.TranslationBuilder builder, class_5321<class_8110> typeKey, String defaultTranslation, @Nullable String killedByTranslation, @Nullable String killedWithItemTranslation) {
        this.registriesFuture.thenAccept(registries -> {
            class_7225.class_7226 damageTypes = registries.method_46762(class_7924.field_42534);
            class_8110 type = (class_8110)damageTypes.method_46747(typeKey).comp_349();
            if (type.comp_1246() != class_8112.field_42361) {
                throw new IllegalArgumentException("Death message type not currently supported: " + String.valueOf(type.comp_1246()));
            }
            String translationKey = "death.attack." + type.comp_1242();
            builder.add(translationKey, defaultTranslation);
            builder.add(translationKey + ".player", killedByTranslation != null ? killedByTranslation : defaultTranslation);
            builder.add(translationKey + ".item", killedWithItemTranslation != null ? killedWithItemTranslation : defaultTranslation);
        });
    }

    private void itemStack(FabricLanguageProvider.TranslationBuilder builder, class_1799 stack, String translationValue) {
        builder.add(stack.method_7922(), translationValue);
    }

    private void advancement(FabricLanguageProvider.TranslationBuilder builder, class_2960 advancementId, String title, String description) {
        builder.add(class_156.method_646((String)"advancements", (class_2960)advancementId.method_48331(".title")), title);
        builder.add(class_156.method_646((String)"advancements", (class_2960)advancementId.method_48331(".description")), description);
    }

    private void spell(FabricLanguageProvider.TranslationBuilder builder, RegistrySupplier<? extends SpellComponent> component, String translation) {
        builder.add(((SpellComponent)component.get()).getTranslationKey(), translation);
    }

    private void tag(FabricLanguageProvider.TranslationBuilder builder, class_6862<?> tag, String translation) {
        String registryName = tag.comp_326().method_29177().method_43903().replace('/', '.');
        String tagName = class_156.method_646((String)("tag." + registryName), (class_2960)tag.comp_327());
        builder.add(tagName, translation);
    }

    private void biome(FabricLanguageProvider.TranslationBuilder builder, class_5321<class_1959> biome, String translation) {
        builder.add(class_156.method_646((String)"biome", (class_2960)biome.method_29177()), translation);
    }
}

