/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.api.entities.Targetable;
import dev.cammiescorner.arcanuscontinuum.api.spells.Pattern;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.common.items.StaffItem;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusMobEffects;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements Targetable {
    @Unique
    private final class_1309 self = (class_1309)this;
    @Unique
    private class_243 prevVelocity;
    @Shadow
    protected boolean field_6282;

    @Shadow
    @Nullable
    public abstract class_1324 method_5996(class_1320 var1);

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    @Shadow
    public abstract boolean method_6061(class_1282 var1);

    @Shadow
    public abstract boolean method_6012();

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract float method_6029();

    @Shadow
    public abstract boolean method_6082(double var1, double var3, double var5, boolean var7);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (amount > 0.0f && !this.method_6061(source)) {
            class_1293 stockpile;
            class_1297 class_12972;
            if (ArcanusComponents.isCounterActive(this.self) && (class_12972 = source.method_5526()) instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                ArcanusComponents.castCounter(this.self, attacker);
            }
            if (this.method_6059((class_1291)ArcanusMobEffects.MANA_WINGS.get()) && ArcanusConfig.MovementEffects.ManaWingsEffectProperties.removedUponTakingDamage) {
                this.method_6016((class_1291)ArcanusMobEffects.MANA_WINGS.get());
            }
            if (this.method_6059((class_1291)ArcanusMobEffects.FLOAT.get()) && ArcanusConfig.MovementEffects.FloatEffectProperties.removedUponTakingDamage) {
                this.method_6016((class_1291)ArcanusMobEffects.FLOAT.get());
            }
            if (this.method_6059((class_1291)ArcanusMobEffects.STOCKPILE.get()) && amount >= ArcanusConfig.AttackEffects.StockpileEffectProperties.damageNeededToIncrease && (stockpile = this.method_6112((class_1291)ArcanusMobEffects.STOCKPILE.get())).method_5578() < 9) {
                this.method_6012();
                this.method_6092(new class_1293(stockpile.method_5579(), stockpile.method_5584(), stockpile.method_5578() + class_3532.method_15375((float)((float)Math.round(amount) / 10.0f))));
            }
            if (this.method_6059((class_1291)ArcanusMobEffects.DANGER_SENSE.get()) && (source.method_48789(class_8103.field_42247) || source.method_48789(class_8103.field_42249))) {
                class_1293 dangerSense = this.method_6112((class_1291)ArcanusMobEffects.DANGER_SENSE.get());
                if ((double)this.field_5974.method_43057() < ArcanusConfig.SupportEffects.DangerSenseEffectProperties.baseChanceToActivate * (double)(dangerSense.method_5578() + 1)) {
                    class_1937 class_19372 = this.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 world = (class_3218)class_19372;
                        double d = this.method_23317();
                        double e = this.method_23318();
                        double f = this.method_23321();
                        for (int i = 0; i < 16; ++i) {
                            double g = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 16.0;
                            double h = class_3532.method_15350((double)(this.method_23318() + (double)this.field_5974.method_43048(16) - 8.0), (double)world.method_31607(), (double)(world.method_31607() + world.method_32819() - 1));
                            double j = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 16.0;
                            if (this.method_5765()) {
                                this.method_5848();
                            }
                            class_243 vec3d = this.method_19538();
                            if (!this.method_6082(g, h, j, true)) continue;
                            world.method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)this.self));
                            class_3414 soundEvent = this.self instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                            world.method_43128(null, d, e, f, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
                            this.method_5783(soundEvent, 1.0f, 1.0f);
                            break;
                        }
                    }
                    this.method_6016((class_1291)ArcanusMobEffects.DANGER_SENSE.get());
                    info.setReturnValue((Object)false);
                }
            }
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyDamage(float amount, class_1282 source) {
        class_1309 attacker;
        class_1297 class_12972;
        class_1324 attributeInstance = this.method_5996((class_1320)ArcanusEntityAttributes.MAGIC_RESISTANCE.get());
        if (attributeInstance != null && source.method_48789(class_8103.field_42248)) {
            amount /= Math.max((float)attributeInstance.method_6194(), 1.0E-6f);
        }
        if (this.method_6059((class_1291)ArcanusMobEffects.FORTIFY.get())) {
            amount /= 1.0f + (float)(this.method_6112((class_1291)ArcanusMobEffects.FORTIFY.get()).method_5578() + 1) * 0.25f;
        }
        if (this.method_6059((class_1291)ArcanusMobEffects.VULNERABILITY.get())) {
            amount *= 1.0f + 0.8f * ((float)(this.method_6112((class_1291)ArcanusMobEffects.VULNERABILITY.get()).method_5578() + 1) / 10.0f);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1309 && (attacker = (class_1309)class_12972).method_6059((class_1291)ArcanusMobEffects.STOCKPILE.get())) {
            amount *= (float)(attacker.method_6112((class_1291)ArcanusMobEffects.STOCKPILE.get()).method_5578() + 1);
            attacker.method_6016((class_1291)ArcanusMobEffects.STOCKPILE.get());
        }
        return amount;
    }

    @ModifyArg(method={"checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/particles/BlockParticleOption;<init>(Lnet/minecraft/core/particles/ParticleType;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private class_2680 bouncy(class_2680 value) {
        if (this.method_6059((class_1291)ArcanusMobEffects.BOUNCY.get())) {
            return class_2246.field_10030.method_9564();
        }
        if (this.method_6059((class_1291)ArcanusMobEffects.FLOAT.get())) {
            this.field_6017 = 0.0f;
        }
        return value;
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void negateFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> info) {
        if (this.prevVelocity != null && !this.method_48923().method_48795(class_8111.field_42355).equals(damageSource) && fallDistance > (float)this.method_5850() && this.method_6059((class_1291)ArcanusMobEffects.BOUNCY.get())) {
            if (!this.method_37908().field_9236) {
                this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14560, this.method_5634(), 1.0f, 1.0f);
                if (!this.method_21750()) {
                    this.method_18800(this.method_18798().method_10216(), -this.prevVelocity.method_10214() * 0.99, this.method_18798().method_10215());
                    this.field_6037 = true;
                }
            }
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo info) {
        if (!this.method_37908().method_8608() && ArcanusComponents.PATTERN_COMPONENT.isProvidedBy((Object)this) && ArcanusComponents.CASTING_COMPONENT.isProvidedBy((Object)this)) {
            this.prevVelocity = this.method_18798();
            class_1324 speedAttr = this.method_5996(class_5134.field_23719);
            List<Pattern> pattern = ArcanusComponents.getPattern((class_1309)this);
            class_1799 stack = this.method_6047();
            if (speedAttr != null) {
                if (stack.method_7909() instanceof StaffItem && ArcanusComponents.isCasting((class_1309)this) && pattern.size() == 3) {
                    Spell spell;
                    class_1322 speedMod;
                    int index = Arcanus.getSpellIndex(pattern);
                    class_2487 tag = stack.method_7911("arcanuscontinuum");
                    class_2499 list = tag.method_10554("Spells", 10);
                    if (!list.isEmpty() && index < list.size() && !speedAttr.method_6196(speedMod = new class_1322(Arcanus.SPELL_SPEED_MODIFIER_ID, "Spell Speed Modifier", (spell = Spell.fromNbt(list.method_10602(index))).getWeight().getSlowdown(), class_1322.class_1323.field_6331))) {
                        speedAttr.method_26835(speedMod);
                    }
                } else if (speedAttr.method_6199(Arcanus.SPELL_SPEED_MODIFIER_ID) != null) {
                    speedAttr.method_6200(Arcanus.SPELL_SPEED_MODIFIER_ID);
                }
            }
        }
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static class_5132.class_5133 createPlayerAttributes(class_5132.class_5133 builder) {
        ArcanusEntityAttributes.registerAll();
        return builder.method_26867((class_1320)ArcanusEntityAttributes.MAX_MANA.get()).method_26867((class_1320)ArcanusEntityAttributes.MANA_REGEN.get()).method_26867((class_1320)ArcanusEntityAttributes.BURNOUT_REGEN.get()).method_26867((class_1320)ArcanusEntityAttributes.MANA_LOCK.get()).method_26867((class_1320)ArcanusEntityAttributes.SPELL_POTENCY.get()).method_26867((class_1320)ArcanusEntityAttributes.MAGIC_RESISTANCE.get()).method_26867((class_1320)ArcanusEntityAttributes.MANA_COST.get()).method_26867((class_1320)ArcanusEntityAttributes.SPELL_COOL_DOWN.get());
    }

    @WrapOperation(method={"handleRelativeFrictionAndCalculateMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;", ordinal=1)})
    private class_243 floatAround(class_1309 livingEntity, Operation<class_243> original, class_243 movementInput, float slipperiness) {
        if (this.method_6059((class_1291)ArcanusMobEffects.FLOAT.get())) {
            return this.method_18798().method_1031(0.0, this.field_6282 ? (double)this.method_6029() : (this.method_5715() ? (double)(-this.method_6029()) : 0.0), 0.0);
        }
        return (class_243)original.call(new Object[]{livingEntity});
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    private void cantRemoveCurse(class_1293 effect, CallbackInfo info) {
        if (effect.method_5579() == ArcanusMobEffects.COPPER_CURSE.get()) {
            info.cancel();
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="HEAD"), argsOnly=true)
    public class_243 invertInput(class_243 movementInput) {
        if (!(this.self instanceof class_1657) && this.method_6059((class_1291)ArcanusMobEffects.DISCOMBOBULATE.get())) {
            movementInput = movementInput.method_18805(-1.0, 1.0, -1.0);
        }
        return movementInput;
    }
}

