/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import mypals.ml.blockOutline.OutlineManager;
import mypals.ml.config.GlowModeManager;
import mypals.ml.config.GlowMyBlocksConfig;
import mypals.ml.config.GlowMyBlocksKeybinds;
import mypals.ml.config.GlowMyBlocksScreenGenerator;
import mypals.ml.wandSystem.SelectedManager;
import mypals.ml.wandSystem.WandActionsManager;
import mypals.ml.wandSystem.WandTooltipRenderer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlowMyBlocks
implements ModInitializer {
    public static final String MOD_ID = "glowmyblocks";
    public static boolean needRebuildOutlineMesh = false;
    public static boolean finishedLoadingWorld = false;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"glowmyblocks");

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void renderBlockOutlines(class_4587 stack, class_9779 counter, Matrix4f projectionMatrix) {
        if (needRebuildOutlineMesh) {
            OutlineManager.buildMeshes(counter);
        }
    }

    public static void renderBlockEntitiesOutlines(class_4587 stack, class_9779 counter, Matrix4f projectionMatrix) {
        if (needRebuildOutlineMesh) {
            OutlineManager.buildMeshes(counter);
        }
        OutlineManager.renderBlocks(stack, counter, projectionMatrix);
        OutlineManager.renderBlockEntities(stack, counter, projectionMatrix);
    }

    public void onInitialize() {
        GlowMyBlocksKeybinds.init();
        needRebuildOutlineMesh = true;
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            WandTooltipRenderer.renderWandTooltip(context);
            WandTooltipRenderer.renderWandModeIcon(context);
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> GlowMyBlocks.updateConfig());
        WorldRenderEvents.AFTER_ENTITIES.register(context -> GlowMyBlocks.renderBlockEntitiesOutlines(context.matrixStack(), context.tickCounter(), context.projectionMatrix()));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            WandActionsManager.wandActions(client);
            while (GlowMyBlocksKeybinds.openConfigKey.method_1436()) {
                client.method_1507(GlowMyBlocksScreenGenerator.getConfigScreen(client.field_1755));
            }
            if (!finishedLoadingWorld && client.method_1562() != null && client.method_1562().field_46578 != null && client.method_1562().field_46578.method_54136()) {
                finishedLoadingWorld = true;
                GlowMyBlocks.resolveSettings();
                needRebuildOutlineMesh = true;
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, pos) -> {
            if (world.field_9236 && player.method_5998(hand).method_7909() == SelectedManager.wand && player.method_7337()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, dir) -> {
            if (world.field_9236 && player.method_5998(hand).method_7909() == SelectedManager.wand && player.method_7337()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public static void onConfigUpdated() {
        try {
            GlowMyBlocks.updateConfig();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            e.printStackTrace();
        }
    }

    public static void updateConfig() {
        ConfigClassHandler<GlowMyBlocksConfig> instance = GlowMyBlocksConfig.CONFIG_HANDLER;
        instance.load();
        GlowMyBlocks.resolveSettings();
        needRebuildOutlineMesh = true;
    }

    private static void resolveSettings() {
        GlowModeManager.resolveSelectedBlockStatesFromString(GlowMyBlocksConfig.selectedBlockTypes);
        SelectedManager.resolveSelectedAreasFromString(GlowMyBlocksConfig.selectedAreasSaved);
        SelectedManager.resolveSelectedWandFromString(GlowMyBlocksConfig.wand);
        OutlineManager.resolveBlocks();
    }
}

