/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.blockOutline;

import mypals.ml.blockOutline.OutlineManager;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;

public class CustomFluidOutlineRenderer {
    public static void render(class_1920 world, class_2338 pos, class_287 vertexConsumer, class_2680 blockState, class_3610 fluidState, class_4587 matrixStack, float r, float g, float b) {
        matrixStack.method_22903();
        matrixStack.method_46416((float)(-pos.method_10263()), (float)(-pos.method_10264()), (float)(-pos.method_10260()));
        class_2680 downState = world.method_8320(pos.method_10093(class_2350.field_11033));
        class_3610 downFluidState = downState.method_26227();
        class_2680 upState = world.method_8320(pos.method_10093(class_2350.field_11036));
        class_3610 upFluidState = upState.method_26227();
        class_2680 northState = world.method_8320(pos.method_10093(class_2350.field_11043));
        class_3610 northFluidState = northState.method_26227();
        class_2680 southState = world.method_8320(pos.method_10093(class_2350.field_11035));
        class_3610 southFluidState = southState.method_26227();
        class_2680 westState = world.method_8320(pos.method_10093(class_2350.field_11039));
        class_3610 westFluidState = westState.method_26227();
        class_2680 eastState = world.method_8320(pos.method_10093(class_2350.field_11034));
        class_3610 eastFluidState = eastState.method_26227();
        boolean renderUp = !CustomFluidOutlineRenderer.isSameFluid(fluidState, upFluidState);
        boolean renderDown = CustomFluidOutlineRenderer.shouldRenderSide(world, pos, fluidState, blockState, class_2350.field_11033, downFluidState) && !CustomFluidOutlineRenderer.isSideCovered(world, pos, class_2350.field_11033, 0.8888889f, downState);
        boolean renderNorth = CustomFluidOutlineRenderer.shouldRenderSide(world, pos, fluidState, blockState, class_2350.field_11043, northFluidState);
        boolean renderSouth = CustomFluidOutlineRenderer.shouldRenderSide(world, pos, fluidState, blockState, class_2350.field_11035, southFluidState);
        boolean renderWest = CustomFluidOutlineRenderer.shouldRenderSide(world, pos, fluidState, blockState, class_2350.field_11039, westFluidState);
        boolean renderEast = CustomFluidOutlineRenderer.shouldRenderSide(world, pos, fluidState, blockState, class_2350.field_11034, eastFluidState);
        if (renderUp || renderDown || renderEast || renderWest || renderNorth || renderSouth) {
            float downOffset;
            float hNW;
            float hSW;
            float hSE;
            float hNE;
            class_3611 fluid = fluidState.method_15772();
            float fluidHeight = CustomFluidOutlineRenderer.getFluidHeight(world, fluid, pos, blockState, fluidState);
            if (fluidHeight >= 1.0f) {
                hNE = 1.0f;
                hSE = 1.0f;
                hSW = 1.0f;
                hNW = 1.0f;
            } else {
                float northHeight = CustomFluidOutlineRenderer.getFluidHeight(world, fluid, pos.method_10095(), northState, northFluidState);
                float southHeight = CustomFluidOutlineRenderer.getFluidHeight(world, fluid, pos.method_10072(), southState, southFluidState);
                float eastHeight = CustomFluidOutlineRenderer.getFluidHeight(world, fluid, pos.method_10078(), eastState, eastFluidState);
                float westHeight = CustomFluidOutlineRenderer.getFluidHeight(world, fluid, pos.method_10067(), westState, westFluidState);
                hNW = CustomFluidOutlineRenderer.calculateFluidHeight(fluidHeight, northHeight, westHeight);
                hNE = CustomFluidOutlineRenderer.calculateFluidHeight(fluidHeight, northHeight, eastHeight);
                hSE = CustomFluidOutlineRenderer.calculateFluidHeight(fluidHeight, southHeight, eastHeight);
                hSW = CustomFluidOutlineRenderer.calculateFluidHeight(fluidHeight, southHeight, westHeight);
            }
            float x = pos.method_10263();
            float y = pos.method_10264();
            float z = pos.method_10260();
            float offset = 0.001f;
            float f = downOffset = renderDown ? 0.001f : 0.0f;
            if (renderUp && !CustomFluidOutlineRenderer.isSideCovered(world, pos, class_2350.field_11036, Math.min(Math.min(hNW, hSW), Math.min(hSE, hNE)), upState)) {
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + (hNW -= 0.001f), z, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + (hSW -= 0.001f), z + 1.0f, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + (hSE -= 0.001f), z + 1.0f, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + (hNE -= 0.001f), z, r, g, b);
                if (fluidState.method_15756((class_1922)world, pos.method_10084())) {
                    CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + hNW, z, r, g, b);
                    CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + hNE, z, r, g, b);
                    CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + hSE, z + 1.0f, r, g, b);
                    CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + hSW, z + 1.0f, r, g, b);
                }
            }
            if (renderDown) {
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + downOffset, z + 1.0f, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x, y + downOffset, z, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + downOffset, z, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x + 1.0f, y + downOffset, z + 1.0f, r, g, b);
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                float z2;
                float z1;
                float x2;
                float x1;
                float h2;
                float h1;
                if (!(switch (direction) {
                    case class_2350.field_11043 -> {
                        h1 = hNW;
                        h2 = hNE;
                        x1 = x;
                        x2 = x + 1.0f;
                        z1 = z + offset;
                        z2 = z + offset;
                        yield renderNorth;
                    }
                    case class_2350.field_11035 -> {
                        h1 = hSE;
                        h2 = hSW;
                        x1 = x + 1.0f;
                        x2 = x;
                        z1 = z + 1.0f - offset;
                        z2 = z + 1.0f - offset;
                        yield renderSouth;
                    }
                    case class_2350.field_11039 -> {
                        h1 = hSW;
                        h2 = hNW;
                        x1 = x + offset;
                        x2 = x + offset;
                        z1 = z + 1.0f;
                        z2 = z;
                        yield renderWest;
                    }
                    default -> {
                        h1 = hNE;
                        h2 = hSE;
                        x1 = x + 1.0f - offset;
                        x2 = x + 1.0f - offset;
                        z1 = z;
                        z2 = z + 1.0f;
                        yield renderEast;
                    }
                }) || CustomFluidOutlineRenderer.isSideCovered(world, pos, direction, Math.max(h1, h2), world.method_8320(pos.method_10093(direction)))) continue;
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x1, y + h1, z1, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x2, y + h2, z2, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x2, y + downOffset, z2, r, g, b);
                CustomFluidOutlineRenderer.vertex(vertexConsumer, matrixStack, x1, y + downOffset, z1, r, g, b);
            }
        }
        matrixStack.method_22909();
    }

    private static void vertex(class_287 vertexConsumer, class_4587 matrixStack, float x, float y, float z, float r, float g, float b) {
        vertexConsumer.method_22918(matrixStack.method_23760().method_23761(), x, y, z).method_22915(r / 255.0f, g / 255.0f, b / 255.0f, 1.0f);
    }

    private static float getFluidHeight(class_1920 world, class_3611 fluid, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        if (fluid.method_15780(fluidState.method_15772())) {
            return fluid.method_15780(world.method_8320(pos.method_10084()).method_26227().method_15772()) ? 1.0f : fluidState.method_20785();
        }
        return !blockState.method_51367() ? 0.0f : -1.0f;
    }

    private static float calculateFluidHeight(float originHeight, float height1, float height2) {
        if (height1 >= 1.0f || height2 >= 1.0f) {
            return 1.0f;
        }
        float sum = 0.0f;
        float count = 0.0f;
        if (height1 > 0.0f) {
            sum += height1;
            count += 1.0f;
        }
        if (height2 > 0.0f) {
            sum += height2;
            count += 1.0f;
        }
        if (originHeight > 0.0f) {
            sum += originHeight;
            count += 1.0f;
        }
        return count > 0.0f ? sum / count : originHeight;
    }

    private static boolean shouldRenderSide(class_1920 world, class_2338 pos, class_3610 fluidState, class_2680 blockState, class_2350 direction, class_3610 neighborFluidState) {
        return !CustomFluidOutlineRenderer.isSameFluid(fluidState, neighborFluidState) || !blockState.method_26206((class_1922)world, pos, direction) || !OutlineManager.blockToRenderer.containsKey(pos.method_10093(direction));
    }

    private static boolean isSameFluid(class_3610 fluidState, class_3610 other) {
        return fluidState.method_15772().method_15780(other.method_15772());
    }

    private static boolean isSideCovered(class_1920 world, class_2338 pos, class_2350 direction, float height, class_2680 neighborState) {
        return neighborState.method_26206((class_1922)world, pos.method_10093(direction), direction.method_10153()) && height >= 1.0f;
    }
}

