/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.blockOutline;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.GlowMyBlocks;
import mypals.ml.blockOutline.CustomBlockOutlineRenderer;
import mypals.ml.blockOutline.CustomFluidOutlineRenderer;
import mypals.ml.config.GlowModeManager;
import mypals.ml.wandSystem.AreaBox;
import mypals.ml.wandSystem.SelectedManager;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_4668;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class OutlineManager {
    public static Map<class_2338, Color> blockToRenderer = new HashMap<class_2338, Color>();
    public static ArrayList<class_2338> targetedBlocks = new ArrayList();
    public static Map<AreaBox, AreaRenderData> areaVbos = new ConcurrentHashMap<AreaBox, AreaRenderData>();
    private static final class_4668.class_4685 STO = new class_4668.class_4685("sto", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_1921 GLOWING_OUTLINE_RENDER = class_1921.method_24049((String)"block_glow_outline", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(STO).method_23604(class_4668.field_21346).method_23603(class_4668.field_21345).method_34578(class_4668.field_29442).method_23608(class_4668.field_21384).method_23616(class_4668.field_21349).method_34577(class_4668.field_21378).method_23617(true));

    public static void buildMeshes(class_9779 counter) {
        if (SelectedManager.selectedAreas.isEmpty() && blockToRenderer.isEmpty()) {
            return;
        }
        for (AreaRenderData data : areaVbos.values()) {
            for (ChunkRenderData chunk : data.sectionData.values()) {
                if (chunk.vbo == null) continue;
                chunk.vbo.close();
            }
        }
        areaVbos.clear();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        float delta = counter.method_60637(false);
        for (AreaBox area : SelectedManager.selectedAreas) {
            AreaRenderData renderData = new AreaRenderData();
            for (int x = area.minPos.method_10263(); x <= area.maxPos.method_10263(); ++x) {
                for (int y = area.minPos.method_10264(); y <= area.maxPos.method_10264(); ++y) {
                    for (int z = area.minPos.method_10260(); z <= area.maxPos.method_10260(); ++z) {
                        class_2338 blockPos = new class_2338(x, y, z);
                        class_2680 state = world.method_8320(blockPos);
                        if (state.method_26215()) continue;
                        class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
                        ChunkRenderData chunkData = renderData.sectionData.computeIfAbsent(sectionPos, k -> new ChunkRenderData());
                        if (chunkData.vbo == null) {
                            chunkData.vbo = OutlineManager.buildMeshForChunk(area, sectionPos, delta);
                        }
                        if (!(state.method_26204() instanceof class_2237)) continue;
                        class_2586 be = world.method_8321(blockPos);
                        if (!GlowModeManager.shouldGlow(blockPos, world.method_8320(blockPos), area) || be == null) continue;
                        chunkData.blockEntities.put(be.method_11016(), area.color);
                    }
                }
            }
            areaVbos.put(area, renderData);
        }
        GlowMyBlocks.needRebuildOutlineMesh = false;
    }

    private static class_291 buildMeshForChunk(AreaBox area, class_4076 sectionPos, float delta) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_638 world = mc.field_1687;
        if (world == null) {
            return null;
        }
        class_287 buffer = class_289.method_1348().method_60827(GLOWING_OUTLINE_RENDER.method_23033(), GLOWING_OUTLINE_RENDER.method_23031());
        int startX = sectionPos.method_19527();
        int endX = sectionPos.method_19530();
        int startY = sectionPos.method_19528();
        int endY = sectionPos.method_19531();
        int startZ = sectionPos.method_19529();
        int endZ = sectionPos.method_19532();
        for (int x = startX; x <= endX && x <= area.maxPos.method_10263(); ++x) {
            for (int y = startY; y <= endY && y <= area.maxPos.method_10264(); ++y) {
                block2: for (int z = startZ; z <= endZ && z <= area.maxPos.method_10260(); ++z) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(blockPos);
                    if (state.method_26215() || !GlowModeManager.shouldGlow(blockPos, state, area)) continue;
                    for (class_2350 direction : class_2350.values()) {
                        class_2338 offsetPos = blockPos.method_10093(direction);
                        boolean isSideBlocked = false;
                        if (OutlineManager.isBlockInsideArea(offsetPos, area)) {
                            isSideBlocked = world.method_8320(offsetPos).method_26234((class_1922)world, offsetPos);
                        }
                        if (isSideBlocked) continue;
                        class_4587 stack = new class_4587();
                        stack.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
                        OutlineManager.renderBlockOutline(new AbstractMap.SimpleEntry<class_2338, class_2680>(blockPos, state), delta, camera, stack, area.color, buffer);
                        continue block2;
                    }
                }
            }
        }
        class_9801 builtBuffer = buffer.method_60794();
        if (builtBuffer == null) {
            return null;
        }
        class_291 vbo = new class_291(class_291.class_8555.field_44794);
        vbo.method_1353();
        vbo.method_1352(builtBuffer);
        class_291.method_1354();
        return vbo;
    }

    public static void onBlockStateChange(class_2338 blockPos) {
        for (AreaBox area : SelectedManager.selectedAreas) {
            if (!OutlineManager.isBlockInsideArea(blockPos, area)) continue;
            class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
            OutlineManager.rebuildChunkSection(area, sectionPos);
        }
    }

    private static void rebuildChunkSection(AreaBox area, class_4076 sectionPos) {
        AreaRenderData areaData = areaVbos.get(area);
        if (areaData == null) {
            return;
        }
        ChunkRenderData old = areaData.sectionData.get(sectionPos);
        if (old != null && old.vbo != null) {
            old.vbo.close();
        }
        ChunkRenderData newData = new ChunkRenderData();
        newData.vbo = OutlineManager.buildMeshForChunk(area, sectionPos, 0.0f);
        newData.blockEntities = OutlineManager.collectBlockEntitiesForChunk(sectionPos, area);
        areaData.sectionData.put(sectionPos, newData);
    }

    private static Map<class_2338, Color> collectBlockEntitiesForChunk(class_4076 sectionPos, AreaBox area) {
        HashMap<class_2338, Color> blockEntities = new HashMap<class_2338, Color>();
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        if (world == null) {
            return blockEntities;
        }
        int startX = sectionPos.method_19527();
        int endX = sectionPos.method_19530();
        int startY = sectionPos.method_19528();
        int endY = sectionPos.method_19531();
        int startZ = sectionPos.method_19529();
        int endZ = sectionPos.method_19532();
        for (int x = startX; x <= endX && x <= area.maxPos.method_10263(); ++x) {
            for (int y = startY; y <= endY && y <= area.maxPos.method_10264(); ++y) {
                for (int z = startZ; z <= endZ && z <= area.maxPos.method_10260(); ++z) {
                    class_2586 be;
                    class_2338 blockPos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(blockPos);
                    if (!GlowModeManager.shouldGlow(blockPos, state, area) || !(state.method_26204() instanceof class_2237) || (be = world.method_8321(blockPos)) == null) continue;
                    blockEntities.put(be.method_11016(), area.color);
                }
            }
        }
        return blockEntities;
    }

    public static void renderBlocks(class_4587 stack, class_9779 counter, Matrix4f projectionMatrix) {
        if (SelectedManager.selectedAreas.isEmpty() && blockToRenderer.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        for (AreaRenderData areaData : areaVbos.values()) {
            for (ChunkRenderData chunk : areaData.sectionData.values()) {
                if (chunk.vbo == null) continue;
                OutlineManager.renderAreaVbo(chunk.vbo, cameraPos);
            }
        }
        class_4618 consumer = mc.field_1769.field_20951.method_23003();
        class_5819 random = mc.method_1560().method_59922();
        class_4587 tempStack = new class_4587();
        tempStack.method_46416(0.0f, 0.0f, 0.0f);
        tempStack.method_22905(0.0f, 0.0f, 0.0f);
        class_310.method_1551().method_1541().method_3355(class_2246.field_10340.method_9564(), new class_2338(0, 0, 0), (class_1920)class_310.method_1551().field_1687, tempStack, consumer.getBuffer(class_1921.method_23287((class_2960)class_1059.field_5275)), true, random);
    }

    public static void renderBlockEntities(class_4587 stack, class_9779 counter, Matrix4f projectionMatrix) {
        if (SelectedManager.selectedAreas.isEmpty() && blockToRenderer.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        for (AreaRenderData areaData : areaVbos.values()) {
            for (ChunkRenderData chunk : areaData.sectionData.values()) {
                if (chunk.blockEntities.isEmpty()) continue;
                OutlineManager.renderAreaBlockEntities(stack, chunk.blockEntities, counter, cameraPos);
            }
        }
    }

    private static void renderAreaVbo(class_291 vbo, class_243 cameraPos) {
        vbo.method_1353();
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().translate((float)(-cameraPos.field_1352), (float)(-cameraPos.field_1351), (float)(-cameraPos.field_1350));
        RenderSystem.applyModelViewMatrix();
        class_310.method_1551().field_1769.method_22990().method_1235(false);
        vbo.method_34427((Matrix4f)RenderSystem.getModelViewStack(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderAreaBlockEntities(class_4587 stack, Map<class_2338, Color> blockEntities, class_9779 counter, class_243 cameraPos) {
        class_310 mc = class_310.method_1551();
        class_824 blockEntityRenderer = mc.method_31975();
        class_4618 outlineProvider = mc.field_1769.field_20951.method_23003();
        float delta = counter.method_60637(false);
        for (Map.Entry<class_2338, Color> entry : blockEntities.entrySet()) {
            class_2338 blockPos = entry.getKey();
            Color color = entry.getValue();
            double x1 = (double)blockPos.method_10263() - cameraPos.field_1352;
            double y1 = (double)blockPos.method_10264() - cameraPos.field_1351;
            double z1 = (double)blockPos.method_10260() - cameraPos.field_1350;
            stack.method_22903();
            stack.method_22904(x1, y1, z1);
            outlineProvider.method_23286(color.getRed(), color.getGreen(), color.getBlue(), 1);
            class_2586 blockEntity = mc.field_1687.method_8321(blockPos);
            if (blockEntity != null) {
                blockEntityRenderer.method_3555(blockEntity, delta, stack, (class_4597)outlineProvider);
            }
            stack.method_22909();
        }
    }

    public static boolean isBlockInsideArea(class_2338 pos, AreaBox area) {
        return pos.method_10263() >= area.minPos.method_10263() && pos.method_10263() <= area.maxPos.method_10263() && pos.method_10264() >= area.minPos.method_10264() && pos.method_10264() <= area.maxPos.method_10264() && pos.method_10260() >= area.minPos.method_10260() && pos.method_10260() <= area.maxPos.method_10260();
    }

    private static void renderBlockOutline(Map.Entry<class_2338, class_2680> entry, float delta, class_4184 camera, class_4587 matrixStack, Color color, class_287 bufferBuilder) {
        class_310 mc = class_310.method_1551();
        class_776 dispatcher = mc.method_1541();
        class_2338 blockPos = entry.getKey();
        class_2680 blockState = entry.getValue();
        matrixStack.method_22903();
        if (!blockState.method_26227().method_15769()) {
            CustomFluidOutlineRenderer.render((class_1920)mc.field_1687, blockPos, bufferBuilder, blockState, blockState.method_26227(), matrixStack, color.getRed(), color.getGreen(), color.getBlue());
        }
        if (blockState.method_26217() == class_2464.field_11458) {
            CustomBlockOutlineRenderer.render((class_1920)mc.field_1687, dispatcher.method_3349(blockState), blockState, blockPos, matrixStack, bufferBuilder, mc.method_1560().method_59922(), blockState.method_26190(blockPos), class_4608.field_21444, color.getRed(), color.getGreen(), color.getBlue());
        }
        matrixStack.method_22909();
    }

    public static void resolveBlocks() {
        blockToRenderer.clear();
        targetedBlocks.clear();
    }

    public static class AreaRenderData {
        public Map<class_4076, ChunkRenderData> sectionData = new HashMap<class_4076, ChunkRenderData>();
    }

    public static class ChunkRenderData {
        public class_291 vbo;
        public Map<class_2338, Color> blockEntities = new HashMap<class_2338, Color>();
    }
}

