/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import mypals.ml.blockOutline.OutlineManager;
import mypals.ml.config.GlowMyBlocksConfig;
import mypals.ml.wandSystem.AreaBox;
import mypals.ml.wandSystem.SelectedManager;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GlowModeManager {
    public static Map<Integer, Map<class_2769, Object>> selectedBlockTypes = new HashMap<Integer, Map<class_2769, Object>>();
    public static GlowRenderMode currentGlowRenderMode = GlowRenderMode.OFF;

    public static String resolveSelectiveBlockRenderingMode(int index) {
        return GlowModeManager.resolveSelectiveRenderingMode(index, GlowRenderMode.values(), mode -> {
            currentGlowRenderMode = mode;
        });
    }

    public static String resolveSelectiveRenderingMode(int index, GlowRenderMode[] modes, Consumer<GlowRenderMode> modeSetter) {
        if (index >= 0 && index < modes.length) {
            GlowRenderMode mode = modes[index];
            modeSetter.accept(mode);
            return mode.getTranslationKey();
        }
        return "-";
    }

    public static void resolveSelectedBlockStatesFromString(List<String> blockStrings) {
        selectedBlockTypes.clear();
        GlowMyBlocksConfig.CONFIG_HANDLER.instance();
        blockStrings.forEach(blockString -> {
            try {
                blockString = blockString.replace(" ", "");
                String[] parts = blockString.split("\\[", 2);
                Object blockIdString = parts[0];
                if (!((String)blockIdString).contains(":")) {
                    blockIdString = "minecraft:" + (String)blockIdString;
                }
                class_2960 blockId = class_2960.method_60654((String)blockIdString);
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
                HashMap<class_2769, String> states = new HashMap<class_2769, String>();
                boolean hasState = false;
                if (parts.length > 1) {
                    String[] properties;
                    String propertiesString = parts[1].replace("]", "");
                    for (String property : properties = propertiesString.split(",")) {
                        String[] keyValue = property.split("=");
                        if (keyValue.length != 2) continue;
                        String key = keyValue[0];
                        String value = keyValue[1];
                        class_2769 blockProperty = block.method_9595().method_11663(key);
                        if (blockProperty == null) continue;
                        states.put(blockProperty, value);
                        hasState = true;
                    }
                }
                if (hasState) {
                    selectedBlockTypes.put(class_7923.field_41175.method_10206((Object)block), states);
                } else {
                    selectedBlockTypes.put(class_7923.field_41175.method_10206((Object)block), null);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse block state: " + blockString);
            }
        });
    }

    public static boolean isSelectedArea(class_2338 pos) {
        for (AreaBox box : SelectedManager.selectedAreas) {
            if (!OutlineManager.isBlockInsideArea(pos, box)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlowModeActive() {
        return currentGlowRenderMode != GlowRenderMode.OFF;
    }

    public static boolean isSelectedTypeAndState(class_2680 state, Map<Integer, Map<class_2769, Object>> selectedTypes) {
        for (Map.Entry<Integer, Map<class_2769, Object>> entry : selectedTypes.entrySet()) {
            Integer blockId = entry.getKey();
            Map<class_2769, Object> properties = entry.getValue();
            if (!blockId.equals(class_7923.field_41175.method_10206((Object)state.method_26204()))) continue;
            if ((properties == null || properties.isEmpty()) && class_7923.field_41175.method_10206((Object)state.method_26204()) == blockId.intValue()) {
                return true;
            }
            boolean hasAllProperties = true;
            for (Map.Entry<class_2769, Object> property : properties.entrySet()) {
                Optional stateProperty = state.method_28500(property.getKey());
                if (!stateProperty.isPresent()) {
                    hasAllProperties = false;
                    break;
                }
                if (stateProperty.get().toString().equals(property.getValue())) continue;
                hasAllProperties = false;
                break;
            }
            if (!hasAllProperties) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldGlow(class_2338 pos, class_2680 state, @Nullable AreaBox areaBox) {
        if (currentGlowRenderMode == GlowRenderMode.OFF) {
            return false;
        }
        boolean isSelected = GlowModeManager.isSelectedTypeAndState(state, selectedBlockTypes);
        boolean isInArea = areaBox == null ? GlowModeManager.isSelectedArea(pos) : OutlineManager.isBlockInsideArea(pos, areaBox);
        switch (currentGlowRenderMode.ordinal()) {
            case 1: {
                return isInArea && isSelected;
            }
            case 2: {
                return isInArea && !isSelected;
            }
            case 3: {
                return isInArea;
            }
        }
        return true;
    }

    public static enum GlowRenderMode {
        OFF("config.blockOutline.render_mode.off", "textures/gui/rendering_mode/render_mode_off.png"),
        GLOW_INSIDE_ONLY_SPECIFIC("config.blockOutline.render_mode.render_inside_include", "textures/gui/rendering_mode/render_mode_1.png"),
        GLOW_INSIDE_EXCLUDE_SPECIFIC("config.blockOutline.render_mode.render_inside_exclude", "textures/gui/rendering_mode/render_mode_3.png"),
        GLOW_INSIDE_ALL("config.blockOutline.render_mode.render_inside_all", "textures/gui/rendering_mode/render_mode_7.png");

        private final String translationKey;
        private final String icon;

        private GlowRenderMode(String translationKey, String icon) {
            this.translationKey = translationKey;
            this.icon = icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

