/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.wandSystem;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import mypals.ml.wandSystem.AreaBox;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SelectedManager {
    public static Map<Integer, Map<class_2769, Object>> selectedBlockTypes = new HashMap<Integer, Map<class_2769, Object>>();
    public static List<AreaBox> selectedAreas = new CopyOnWriteArrayList<AreaBox>();
    public static class_1792 wand;

    public static void resolveSelectedWandFromString(String name) {
        class_2960 id;
        class_1792 nweWand;
        class_1792 last_wind = wand;
        if (!((String)name).contains(":")) {
            name = "minecraft:" + (String)name;
        }
        wand = (nweWand = (class_1792)class_7923.field_41178.method_10223(id = class_2960.method_60654((String)name))) == null ? last_wind : nweWand;
    }

    public static void resolveSelectedAreasFromString(List<String> areaStrings) {
        selectedAreas.clear();
        areaStrings.forEach(areaString -> {
            try {
                AreaBox area = SelectedManager.parseAABB(areaString);
                selectedAreas.add(area);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to parse area: " + areaString + " -> " + e.getMessage());
            }
        });
    }

    private static AreaBox parseAABB(String areaString) throws IllegalArgumentException {
        String[] parts = areaString.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid format. Expected x1,y1,z1:x2,y2,z2:color");
        }
        String[] startCoords = parts[0].split(",");
        String[] endCoords = parts[1].split(",");
        String colorString = parts[2];
        Color color = Color.white;
        try {
            int c = Integer.parseInt(colorString);
            color = new Color(c);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        if (startCoords.length != 3 || endCoords.length != 3) {
            throw new IllegalArgumentException("Invalid coordinates. Expected x1,y1,z1:x2,y2,z2:color");
        }
        try {
            int x1 = Integer.parseInt(startCoords[0].trim());
            int y1 = Integer.parseInt(startCoords[1].trim());
            int z1 = Integer.parseInt(startCoords[2].trim());
            int x2 = Integer.parseInt(endCoords[0].trim());
            int y2 = Integer.parseInt(endCoords[1].trim());
            int z2 = Integer.parseInt(endCoords[2].trim());
            return new AreaBox(new class_2338(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2)), new class_2338(Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2)), color, 0.2f, false);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in input: " + areaString, e);
        }
    }

    public static boolean isInsideArea(class_243 pos, AreaBox areaBox) {
        return (double)areaBox.minPos.method_10263() <= pos.method_10216() && pos.method_10216() <= (double)areaBox.maxPos.method_10263() && (double)areaBox.minPos.method_10264() <= pos.method_10214() && pos.method_10214() <= (double)areaBox.maxPos.method_10264() && (double)areaBox.minPos.method_10260() <= pos.method_10215() && pos.method_10215() <= (double)areaBox.maxPos.method_10260();
    }
}

