/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.wandSystem;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mypals.ml.config.GlowModeManager;
import mypals.ml.config.GlowMyBlocksConfig;
import mypals.ml.config.GlowMyBlocksKeybinds;
import mypals.ml.wandSystem.SelectedManager;
import mypals.ml.wandSystem.WandActionsManager;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class WandTooltipRenderer {
    private static final List<ToolTipItem> hudItems = new ArrayList<ToolTipItem>();

    public static void addTooltip(String text, Color color, class_2960 icon) {
        hudItems.add(new ToolTipItem(text, color, icon));
    }

    public static void generateTooltip() {
        hudItems.clear();
        TriConsumer addTooltip = (key, color, icon) -> WandTooltipRenderer.addTooltip(class_2561.method_43471((String)key).getString(), color, class_2960.method_60655((String)"glowmyblocks", (String)icon));
        TriConsumer addKeyTooltip = (key, color, icon) -> addTooltip.accept((Object)(class_2561.method_43471((String)key.method_1431()).getString() + "(" + key.method_16007().getString() + ")"), color, icon);
        if (class_310.method_1551().field_1690.field_1867.method_1434()) {
            addTooltip.accept((Object)"config.wand.switchMode", (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/mouse_middle.png");
        } else if (WandActionsManager.pos1 == null && WandActionsManager.pos2 == null) {
            addTooltip.accept((Object)"config.wand.holdSprint", (Object)new Color(200, 200, 200, 150), (Object)"textures/gui/hotkey.png");
        }
        if (GlowMyBlocksKeybinds.addOutlineArea.method_1434()) {
            addKeyTooltip.accept((Object)GlowMyBlocksKeybinds.addOutlineArea, (Object)new Color(200, 255, 200, 200), (Object)"textures/gui/hotkey.png");
            if (WandActionsManager.pos1 != null && WandActionsManager.pos2 != null) {
                addTooltip.accept((Object)"config.wand.addArea", (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/mouse_left.png");
            }
        } else if (GlowMyBlocksKeybinds.deleteOutlineArea.method_1434()) {
            addKeyTooltip.accept((Object)GlowMyBlocksKeybinds.deleteOutlineArea, (Object)new Color(200, 255, 200, 200), (Object)"textures/gui/hotkey.png");
            addTooltip.accept((Object)"config.wand.delete", (Object)new Color(255, 180, 180, 200), (Object)"textures/gui/mouse_right.png");
            if (WandActionsManager.pos1 != null && WandActionsManager.pos2 != null) {
                addTooltip.accept((Object)"config.wand.cut", (Object)new Color(255, 200, 200, 200), (Object)"textures/gui/mouse_left.png");
            }
        } else {
            if (WandActionsManager.pos1 == null) {
                addTooltip.accept((Object)"config.wand.selectP1", (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/mouse_left.png");
            }
            if (WandActionsManager.pos2 == null) {
                addTooltip.accept((Object)"config.wand.selectP2", (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/mouse_right.png");
            }
            if (WandActionsManager.pos1 != null && WandActionsManager.pos2 != null) {
                if (!GlowMyBlocksKeybinds.addOutlineArea.method_1434()) {
                    addKeyTooltip.accept((Object)GlowMyBlocksKeybinds.addOutlineArea, (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/hotkey.png");
                }
                if (!GlowMyBlocksKeybinds.deleteOutlineArea.method_1434()) {
                    addKeyTooltip.accept((Object)GlowMyBlocksKeybinds.deleteOutlineArea, (Object)new Color(255, 255, 255, 200), (Object)"textures/gui/hotkey.png");
                }
            }
        }
    }

    public static void renderWandTooltip(class_332 context) {
        boolean shouldSelect;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        boolean bl = shouldSelect = player.method_6047().method_7909() == SelectedManager.wand || GlowMyBlocksConfig.selectInSpectator != false && player.method_7325();
        if (!shouldSelect || client.field_1690.field_1842) {
            return;
        }
        WandTooltipRenderer.generateTooltip();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int x = centerX - 50;
        int y = centerY + 5;
        int lineHeight = 10;
        int maxTextWidth = 0;
        for (ToolTipItem item : hudItems) {
            int textWidth = client.field_1772.method_1727(item.text);
            maxTextWidth = Math.max(maxTextWidth, textWidth);
        }
        x = centerX - maxTextWidth / 2;
        for (ToolTipItem item : hudItems) {
            if (item.icon != null) {
                RenderSystem.enableBlend();
                context.method_25290(item.icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.disableBlend();
            }
            int textX = x + (item.icon != null ? 20 : 0);
            context.method_51433(client.field_1772, item.text, textX, y + 4, item.color, true);
            y += lineHeight;
        }
    }

    public static void renderWandModeIcon(class_332 context) {
        int screenHeight;
        boolean shouldSelect;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        boolean bl = shouldSelect = player.method_6047().method_7909() == SelectedManager.wand || GlowMyBlocksConfig.selectInSpectator != false && player.method_7325();
        if (!shouldSelect) {
            return;
        }
        int centerY = screenHeight = client.method_22683().method_4502();
        int iconWidth = 32;
        int x = 0;
        int y = centerY - 60;
        RenderSystem.enableBlend();
        context.method_25290(class_2960.method_60655((String)"glowmyblocks", (String)GlowModeManager.currentGlowRenderMode.getIcon()), x, y, 0.0f, 0.0f, iconWidth, iconWidth, iconWidth, iconWidth);
        RenderSystem.disableBlend();
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)GlowModeManager.currentGlowRenderMode.getTranslationKey()), x + iconWidth + 2, y + iconWidth / 2, -32, true);
    }

    private static class ToolTipItem {
        String text;
        int color;
        @Nullable
        class_2960 icon;

        public ToolTipItem(String text, Color color, class_2960 icon) {
            this.text = text;
            this.color = color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            this.icon = icon;
        }
    }
}

