package com.nad2040.elytrabombing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.Gson;

import java.io.*;
import java.util.Objects;

public class ElytraBombingMod implements ModInitializer {
	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
    public static final String MODID = "elytrabombing";
	public static final Logger LOGGER = LoggerFactory.getLogger(MODID);
	public static final Boolean SHOULD_LOG = Objects.requireNonNull(load_config("should_log")).getAsBoolean();

	@Override
	public void onInitialize() {
        LOGGER.info("Elytra Bombing Mod initialized!");
	}

	public static void log(class_1268 hand, class_1268 other_hand, class_1799 usedItemStack, class_1799 otherItemStack, class_243 position, class_243 velocity) {
		LOGGER.info("right click action detected");
		LOGGER.info("hand is " + ((hand == class_1268.field_5808) ? "main hand" : "off hand"));
		LOGGER.info("other hand is " + ((other_hand == class_1268.field_5808) ? "main hand" : "off hand"));
		LOGGER.info("used item: " + usedItemStack);
		LOGGER.info("other item: " + otherItemStack);
		LOGGER.info("player pos: " + position);
		LOGGER.info("player vel: " + velocity);
	}

	private static JsonElement load_config(String key) {
		Gson gson = new Gson();
		File dir = new File("config");
		if (dir.mkdir()) LOGGER.info("created config directory");
		File f = new File(dir, MODID+".json");
		if (!f.exists()) {
			try (FileWriter fw = new FileWriter(f)) {
				JsonObject new_conf = new JsonObject();
				new_conf.addProperty("should_log",true);
				gson.toJson(new_conf, new JsonWriter(fw));
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
		try (FileReader fr = new FileReader(f)) {
			JsonObject json = gson.fromJson(new JsonReader(fr), JsonObject.class);
			return json.has(key) ? json.get(key) : null;
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public interface FBEInterface {
		void setBlock(class_2680 state);
	}
}
