/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.enchantmentsunbound;

import com.notcharrow.enchantmentsunbound.config.ConfigManager;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EnchantmentsUnboundModMenu
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this::createConfigScreen;
    }

    private class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(class_2561.method_30163((String)"Enchantments Unbound Config"));
        ConfigCategory general = builder.getOrCreateCategory(class_2561.method_30163((String)"General Settings"));
        this.addBoolean(general, "Static Cost", "Use static cost instead of vanilla scaling", ConfigManager.config.staticCost, value -> {
            ConfigManager.config.staticCost = value;
        });
        this.addIntField(general, "Level Cost", "The level cost if Static Cost is enabled", ConfigManager.config.levelCost, value -> {
            ConfigManager.config.levelCost = value;
        }, 1, Integer.MAX_VALUE);
        this.addDoubleField(general, "Scaling Cost Multiplier", "The multiplier to increase the level cost by each transaction (vanilla default: 2.0)", ConfigManager.config.levelCostScalingMultiplier, value -> {
            ConfigManager.config.levelCostScalingMultiplier = value;
        }, 1.0, 2.147483647E9);
        this.addIntField(general, "Max Level Cost", "The maximum amount of levels that a transaction can cost", ConfigManager.config.maxLevelCost, value -> {
            ConfigManager.config.maxLevelCost = value;
        }, 1, Integer.MAX_VALUE);
        this.addBoolean(general, "Overwrite Vanilla Enchants", "Overwrite vanilla enchantment max levels", ConfigManager.config.overwriteVanillaEnchants, value -> {
            ConfigManager.config.overwriteVanillaEnchants = value;
        });
        this.addBoolean(general, "Use Global Vanilla Cap", "Use global cap for vanilla enchants", ConfigManager.config.useGlobalVanillaCap, value -> {
            ConfigManager.config.useGlobalVanillaCap = value;
        });
        this.addIntField(general, "Global Vanilla Cap", "Cap for all vanilla enchantments if enabled", ConfigManager.config.globalVanillaCap, value -> {
            ConfigManager.config.globalVanillaCap = value;
        }, 1, 255);
        this.addBoolean(general, "Overwrite Custom Enchants", "Overwrite custom enchantment max levels", ConfigManager.config.overwriteCustomEnchants, value -> {
            ConfigManager.config.overwriteCustomEnchants = value;
        });
        this.addIntField(general, "Custom Enchant Cap", "Global custom enchantment cap if enabled", ConfigManager.config.customEnchantCap, value -> {
            ConfigManager.config.customEnchantCap = value;
        }, 1, 255);
        ConfigCategory enchants = builder.getOrCreateCategory(class_2561.method_30163((String)"Enchant Caps"));
        this.addIntField(enchants, "Aqua Affinity", "", ConfigManager.config.aqua_affinity, value -> {
            ConfigManager.config.aqua_affinity = value;
        }, 1, 255);
        this.addIntField(enchants, "Bane of Arthropods", "", ConfigManager.config.bane_of_arthropods, value -> {
            ConfigManager.config.bane_of_arthropods = value;
        }, 1, 255);
        this.addIntField(enchants, "Binding Curse", "", ConfigManager.config.binding_curse, value -> {
            ConfigManager.config.binding_curse = value;
        }, 1, 255);
        this.addIntField(enchants, "Blast Protection", "", ConfigManager.config.blast_protection, value -> {
            ConfigManager.config.blast_protection = value;
        }, 1, 255);
        this.addIntField(enchants, "Breach", "", ConfigManager.config.breach, value -> {
            ConfigManager.config.breach = value;
        }, 1, 255);
        this.addIntField(enchants, "Channeling", "", ConfigManager.config.channeling, value -> {
            ConfigManager.config.channeling = value;
        }, 1, 255);
        this.addIntField(enchants, "Density", "", ConfigManager.config.density, value -> {
            ConfigManager.config.density = value;
        }, 1, 255);
        this.addIntField(enchants, "Depth Strider", "", ConfigManager.config.depth_strider, value -> {
            ConfigManager.config.depth_strider = value;
        }, 1, 255);
        this.addIntField(enchants, "Efficiency", "", ConfigManager.config.efficiency, value -> {
            ConfigManager.config.efficiency = value;
        }, 1, 255);
        this.addIntField(enchants, "Feather Falling", "", ConfigManager.config.feather_falling, value -> {
            ConfigManager.config.feather_falling = value;
        }, 1, 255);
        this.addIntField(enchants, "Fire Aspect", "", ConfigManager.config.fire_aspect, value -> {
            ConfigManager.config.fire_aspect = value;
        }, 1, 255);
        this.addIntField(enchants, "Fire Protection", "", ConfigManager.config.fire_protection, value -> {
            ConfigManager.config.fire_protection = value;
        }, 1, 255);
        this.addIntField(enchants, "Flame", "", ConfigManager.config.flame, value -> {
            ConfigManager.config.flame = value;
        }, 1, 255);
        this.addIntField(enchants, "Fortune", "", ConfigManager.config.fortune, value -> {
            ConfigManager.config.fortune = value;
        }, 1, 255);
        this.addIntField(enchants, "Frost Walker", "", ConfigManager.config.frost_walker, value -> {
            ConfigManager.config.frost_walker = value;
        }, 1, 255);
        this.addIntField(enchants, "Impaling", "", ConfigManager.config.impaling, value -> {
            ConfigManager.config.impaling = value;
        }, 1, 255);
        this.addIntField(enchants, "Infinity", "", ConfigManager.config.infinity, value -> {
            ConfigManager.config.infinity = value;
        }, 1, 255);
        this.addIntField(enchants, "Knockback", "", ConfigManager.config.knockback, value -> {
            ConfigManager.config.knockback = value;
        }, 1, 255);
        this.addIntField(enchants, "Looting", "", ConfigManager.config.looting, value -> {
            ConfigManager.config.looting = value;
        }, 1, 255);
        this.addIntField(enchants, "Loyalty", "", ConfigManager.config.loyalty, value -> {
            ConfigManager.config.loyalty = value;
        }, 1, 255);
        this.addIntField(enchants, "Luck of the Sea", "", ConfigManager.config.luck_of_the_sea, value -> {
            ConfigManager.config.luck_of_the_sea = value;
        }, 1, 255);
        this.addIntField(enchants, "Lure", "", ConfigManager.config.lure, value -> {
            ConfigManager.config.lure = value;
        }, 1, 255);
        this.addIntField(enchants, "Mending", "", ConfigManager.config.mending, value -> {
            ConfigManager.config.mending = value;
        }, 1, 255);
        this.addIntField(enchants, "Multishot", "", ConfigManager.config.multishot, value -> {
            ConfigManager.config.multishot = value;
        }, 1, 255);
        this.addIntField(enchants, "Piercing", "", ConfigManager.config.piercing, value -> {
            ConfigManager.config.piercing = value;
        }, 1, 255);
        this.addIntField(enchants, "Power", "", ConfigManager.config.power, value -> {
            ConfigManager.config.power = value;
        }, 1, 255);
        this.addIntField(enchants, "Projectile Protection", "", ConfigManager.config.projectile_protection, value -> {
            ConfigManager.config.projectile_protection = value;
        }, 1, 255);
        this.addIntField(enchants, "Protection", "", ConfigManager.config.protection, value -> {
            ConfigManager.config.protection = value;
        }, 1, 255);
        this.addIntField(enchants, "Punch", "", ConfigManager.config.punch, value -> {
            ConfigManager.config.punch = value;
        }, 1, 255);
        this.addIntField(enchants, "Quick Charge", "", ConfigManager.config.quick_charge, value -> {
            ConfigManager.config.quick_charge = value;
        }, 1, 255);
        this.addIntField(enchants, "Respiration", "", ConfigManager.config.respiration, value -> {
            ConfigManager.config.respiration = value;
        }, 1, 255);
        this.addIntField(enchants, "Riptide", "", ConfigManager.config.riptide, value -> {
            ConfigManager.config.riptide = value;
        }, 1, 255);
        this.addIntField(enchants, "Sharpness", "", ConfigManager.config.sharpness, value -> {
            ConfigManager.config.sharpness = value;
        }, 1, 255);
        this.addIntField(enchants, "Silk Touch", "", ConfigManager.config.silk_touch, value -> {
            ConfigManager.config.silk_touch = value;
        }, 1, 255);
        this.addIntField(enchants, "Smite", "", ConfigManager.config.smite, value -> {
            ConfigManager.config.smite = value;
        }, 1, 255);
        this.addIntField(enchants, "Soul Speed", "", ConfigManager.config.soul_speed, value -> {
            ConfigManager.config.soul_speed = value;
        }, 1, 255);
        this.addIntField(enchants, "Sweeping", "", ConfigManager.config.sweeping, value -> {
            ConfigManager.config.sweeping = value;
        }, 1, 255);
        this.addIntField(enchants, "Swift Sneak", "", ConfigManager.config.swift_sneak, value -> {
            ConfigManager.config.swift_sneak = value;
        }, 1, 255);
        this.addIntField(enchants, "Thorns", "", ConfigManager.config.thorns, value -> {
            ConfigManager.config.thorns = value;
        }, 1, 255);
        this.addIntField(enchants, "Unbreaking", "", ConfigManager.config.unbreaking, value -> {
            ConfigManager.config.unbreaking = value;
        }, 1, 255);
        this.addIntField(enchants, "Vanishing Curse", "", ConfigManager.config.vanishing_curse, value -> {
            ConfigManager.config.vanishing_curse = value;
        }, 1, 255);
        this.addIntField(enchants, "Wind Burst", "", ConfigManager.config.wind_burst, value -> {
            ConfigManager.config.wind_burst = value;
        }, 1, 255);
        return builder.build();
    }

    private void addBoolean(ConfigCategory category, String label, String tooltip, boolean currentValue, Consumer<Boolean> onSave) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startBooleanToggle(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(onSave).build());
    }

    private void addIntField(ConfigCategory category, String label, String tooltip, int currentValue, Consumer<Integer> onSave, int min, int max) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startIntField(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(newValue -> {
            if (newValue < min) {
                newValue = min;
            }
            if (newValue > max) {
                newValue = max;
            }
            onSave.accept((Integer)newValue);
            ConfigManager.saveConfig();
        }).build());
    }

    private void addDoubleField(ConfigCategory category, String label, String tooltip, double currentValue, Consumer<Double> onSave, double min, double max) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startDoubleField(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(newValue -> {
            if (newValue < min) {
                newValue = min;
            }
            if (newValue > max) {
                newValue = max;
            }
            onSave.accept((Double)newValue);
            ConfigManager.saveConfig();
        }).build());
    }
}

