/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.enchantmentsunbound.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.notcharrow.enchantmentsunbound.config.EnchantmentsUnboundConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config", "enchantmentsunbound.json");
    public static EnchantmentsUnboundConfig config;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            config = new EnchantmentsUnboundConfig();
            ConfigManager.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            config = (EnchantmentsUnboundConfig)GSON.fromJson((Reader)reader, EnchantmentsUnboundConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            config = new EnchantmentsUnboundConfig();
        }
    }

    public static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

