/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class DialogUtil {
    private DialogUtil() {
    }

    public static String openFileDialog(String title, @Nullable String defaultPath, @Nullable List<String> patterns, @Nullable String filterDesc, boolean allowMultipleSelections) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer patternsBuf = null;
            if (patterns != null) {
                patternsBuf = stack.mallocPointer(patterns.size());
                for (int i = 0; i < patterns.size(); ++i) {
                    stack.nUTF8Safe((CharSequence)patterns.get(i), true);
                    patternsBuf.put(i, stack.getPointerAddress());
                }
            }
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)defaultPath, (PointerBuffer)patternsBuf, (CharSequence)filterDesc, (boolean)allowMultipleSelections);
            return string;
        }
    }

    public static String saveFileDialog(String title, @Nullable String defaultPath, @Nullable List<String> patterns, @Nullable String filterDesc) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer patternsBuf = null;
            if (patterns != null) {
                patternsBuf = stack.mallocPointer(patterns.size());
                for (int i = 0; i < patterns.size(); ++i) {
                    stack.nUTF8Safe((CharSequence)patterns.get(i), true);
                    patternsBuf.put(i, stack.getPointerAddress());
                }
            }
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)defaultPath, (PointerBuffer)patternsBuf, (CharSequence)filterDesc);
            return string;
        }
    }
}

