/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client;

import com.mojang.brigadier.CommandDispatcher;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.GadgetClientEntrypoint;
import io.wispforest.gadget.client.ServerData;
import io.wispforest.gadget.client.command.ChatLogCommand;
import io.wispforest.gadget.client.command.ReloadMappingsCommand;
import io.wispforest.gadget.client.config.GadgetConfigScreen;
import io.wispforest.gadget.client.dump.ClientPacketDumper;
import io.wispforest.gadget.client.dump.handler.ClientPacketHandlers;
import io.wispforest.gadget.client.field.FieldDataScreen;
import io.wispforest.gadget.client.field.RemoteFieldDataSource;
import io.wispforest.gadget.client.gui.ContextMenuScreens;
import io.wispforest.gadget.client.gui.GadgetScreen;
import io.wispforest.gadget.client.log.ChatLogAppender;
import io.wispforest.gadget.client.nbt.StackComponentDataScreen;
import io.wispforest.gadget.client.resource.ViewResourcesScreen;
import io.wispforest.gadget.field.FieldDataSource;
import io.wispforest.gadget.mappings.MappingsManager;
import io.wispforest.gadget.mixin.client.HandledScreenAccessor;
import io.wispforest.gadget.network.BlockEntityTarget;
import io.wispforest.gadget.network.EntityTarget;
import io.wispforest.gadget.network.GadgetNetworking;
import io.wispforest.gadget.network.InspectionTarget;
import io.wispforest.gadget.network.packet.c2s.OpenFieldDataScreenC2SPacket;
import io.wispforest.gadget.network.packet.c2s.RequestResourceC2SPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataErrorS2CPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataResponseS2CPacket;
import io.wispforest.gadget.network.packet.s2c.OpenFieldDataScreenS2CPacket;
import io.wispforest.gadget.network.packet.s2c.ResourceDataS2CPacket;
import io.wispforest.gadget.network.packet.s2c.ResourceListS2CPacket;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layer;
import io.wispforest.owo.ui.layers.Layers;
import java.io.ByteArrayInputStream;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_7417;

public class GadgetClient
implements ClientModInitializer {
    public static final class_304 INSPECT_KEY = new class_304("key.gadget.inspect", 73, class_304.class_11900.field_62556);
    public static final class_304 DUMP_KEY = new class_304("key.gadget.dump", 75, class_304.class_11900.field_62556);

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)INSPECT_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)DUMP_KEY);
        ClientPacketHandlers.init();
        ServerData.init();
        ContextMenuScreens.init();
        ChatLogAppender.init();
        ConfigScreenProviders.register((String)"gadget", GadgetConfigScreen::new);
        GadgetNetworking.CHANNEL.registerClientbound(OpenFieldDataScreenS2CPacket.class, (packet, access) -> access.runtime().method_1507((class_437)new FieldDataScreen(packet.target(), false, true, packet.rootData(), packet.rootChildren())));
        GadgetNetworking.CHANNEL.registerClientbound(FieldDataResponseS2CPacket.class, (packet, access) -> {
            FieldDataSource patt1$temp;
            FieldDataScreen gui;
            class_437 patt0$temp = access.runtime().field_1755;
            if (patt0$temp instanceof FieldDataScreen && (gui = (FieldDataScreen)patt0$temp).target().equals(packet.target()) && (patt1$temp = gui.dataSource()) instanceof RemoteFieldDataSource) {
                RemoteFieldDataSource remote = (RemoteFieldDataSource)patt1$temp;
                remote.acceptPacket((FieldDataResponseS2CPacket)packet);
            }
        });
        GadgetNetworking.CHANNEL.registerClientbound(FieldDataErrorS2CPacket.class, (packet, access) -> {
            FieldDataSource patt1$temp;
            FieldDataScreen gui;
            class_437 patt0$temp = access.runtime().field_1755;
            if (patt0$temp instanceof FieldDataScreen && (gui = (FieldDataScreen)patt0$temp).target().equals(packet.target()) && (patt1$temp = gui.dataSource()) instanceof RemoteFieldDataSource) {
                RemoteFieldDataSource remote = (RemoteFieldDataSource)patt1$temp;
                remote.acceptPacket((FieldDataErrorS2CPacket)packet);
            }
        });
        GadgetNetworking.CHANNEL.registerClientbound(ResourceListS2CPacket.class, (packet, access) -> {
            ViewResourcesScreen screen = new ViewResourcesScreen(access.runtime().field_1755, packet.resources());
            screen.resRequester((id, idx) -> GadgetNetworking.CHANNEL.clientHandle().send((Record)new RequestResourceC2SPacket((class_2960)id, (int)idx)));
            access.runtime().method_1507((class_437)screen);
        });
        GadgetNetworking.CHANNEL.registerClientbound(ResourceDataS2CPacket.class, (packet, access) -> {
            class_437 patt0$temp = access.runtime().field_1755;
            if (!(patt0$temp instanceof ViewResourcesScreen)) {
                return;
            }
            ViewResourcesScreen screen = (ViewResourcesScreen)patt0$temp;
            screen.openFile(packet.id(), () -> new ByteArrayInputStream(packet.data()));
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.method_18506() == null) {
                MappingsManager.init();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            Record target;
            if (!INSPECT_KEY.method_1436()) {
                return;
            }
            if (!client.field_1690.method_31044().method_31034() && client.field_1724 != null) {
                target = new EntityTarget(client.field_1724.method_5628());
            } else {
                class_239 hitResult;
                class_1297 camera = client.method_1560();
                if (camera == null) {
                    camera = client.field_1724;
                }
                if ((hitResult = GadgetClient.raycast(camera, client.method_61966().method_60637(false))) == null) {
                    return;
                }
                if (hitResult instanceof class_3966) {
                    class_3966 ehr = (class_3966)hitResult;
                    target = new EntityTarget(ehr.method_17782().method_5628());
                } else {
                    class_2338 class_23382;
                    if (hitResult instanceof class_3965) {
                        class_3965 blockHitResult = (class_3965)hitResult;
                        class_23382 = blockHitResult.method_17777();
                    } else {
                        class_23382 = class_2338.method_49638((class_2374)hitResult.method_17784());
                    }
                    class_2338 blockPos = class_23382;
                    target = new BlockEntityTarget(blockPos);
                }
            }
            if (!GadgetNetworking.CHANNEL.canSendToServer()) {
                if (target.resolve((class_1937)client.field_1687) == null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.notfound"), true);
                    return;
                }
                client.method_1507((class_437)new FieldDataScreen((InspectionTarget)((Object)target), true, false, null, null));
            } else {
                GadgetNetworking.CHANNEL.clientHandle().send((Record)new OpenFieldDataScreenC2SPacket((InspectionTarget)((Object)target)));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!DUMP_KEY.method_1436()) {
                return;
            }
            if (ClientPacketDumper.isDumping()) {
                ClientPacketDumper.stop();
            } else {
                ClientPacketDumper.start(true);
            }
        });
        List<String> alignToButtons = List.of("menu.multiplayer", "menu.shareToLan", "menu.playerReporting");
        Layers.add(Containers::verticalFlow, instance -> {
            if (!Gadget.CONFIG.menuButtonEnabled()) {
                return;
            }
            ((FlowLayout)instance.adapter.rootComponent).child(Components.button((class_2561)class_2561.method_43471((String)"text.gadget.menu_button"), button -> class_310.method_1551().method_1507((class_437)new GadgetScreen(instance.screen))).configure(button -> {
                button.margins(Insets.left((int)4)).sizing(Sizing.fixed((int)20));
                instance.alignComponentToWidget(widget -> {
                    class_2588 translatable;
                    if (!(widget instanceof class_4185)) {
                        return false;
                    }
                    class_4185 daButton = (class_4185)widget;
                    class_7417 patt0$temp = daButton.method_25369().method_10851();
                    return patt0$temp instanceof class_2588 && alignToButtons.contains((translatable = (class_2588)patt0$temp).method_11022());
                }, Layer.Instance.AnchorSide.RIGHT, 0.0f, (Component)button);
            }));
        }, (Class[])new Class[]{class_442.class, class_433.class});
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 handled = (class_465)screen;
                ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((screen1, input) -> {
                    double mouseY;
                    if (!INSPECT_KEY.method_1417(input)) {
                        return true;
                    }
                    double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
                    class_1735 slot = ((HandledScreenAccessor)handled).callGetSlotAt(mouseX, mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
                    if (slot == null) {
                        return true;
                    }
                    if (slot instanceof class_481.class_482) {
                        return true;
                    }
                    if (slot.method_7677().method_7960()) {
                        return true;
                    }
                    client.method_1507((class_437)new StackComponentDataScreen(handled, slot));
                    return false;
                });
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            ReloadMappingsCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            ChatLogCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("gadget:client_init", GadgetClientEntrypoint.class)) {
            try {
                ((GadgetClientEntrypoint)container.getEntrypoint()).onGadgetClientInit();
            }
            catch (Exception e) {
                Gadget.LOGGER.error("{}'s `gadget:client_init` entrypoint handler threw an exception", (Object)container.getProvider().getMetadata().getId(), (Object)e);
            }
        }
    }

    public static class_239 raycast(class_1297 entity, float tickDelta) {
        class_239 blockTarget = entity.method_5745(5.0, tickDelta, false);
        class_243 maxReach = entity.method_5828(tickDelta).method_1021(5.0);
        class_3966 entityTarget = class_1675.method_18075((class_1297)entity, (class_243)entity.method_33571(), (class_243)entity.method_33571().method_1019(maxReach), (class_238)entity.method_5829().method_18804(maxReach), candidate -> true, (double)25.0);
        return entityTarget != null && entityTarget.method_24801(entity) < blockTarget.method_24801(entity) ? entityTarget : blockTarget;
    }
}

