/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.gadget.client.log.ChatLogAppender;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

public final class ChatLogCommand {
    private ChatLogCommand() {
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"gadget").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"chat-log").then(ClientCommandManager.literal((String)"enable").then(ClientCommandManager.argument((String)"logger-name", (ArgumentType)StringArgumentType.greedyString()).suggests(ChatLogCommand::activeLoggerNames).executes(ChatLogCommand::enable)))).then(ClientCommandManager.literal((String)"disable").then(ClientCommandManager.argument((String)"logger-name", (ArgumentType)StringArgumentType.greedyString()).suggests(ChatLogCommand::enabledLoggerNames).executes(ChatLogCommand::disable)))));
    }

    private static CompletableFuture<Suggestions> activeLoggerNames(CommandContext<FabricClientCommandSource> ctx, SuggestionsBuilder builder) {
        HashSet<String> allLoggerNames = new HashSet<String>();
        for (ExtendedLogger logger : LogManager.getContext((boolean)false).getLoggerRegistry().getLoggers()) {
            allLoggerNames.add(logger.getName());
        }
        return class_2172.method_9265(allLoggerNames, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> enabledLoggerNames(CommandContext<FabricClientCommandSource> ctx, SuggestionsBuilder builder) {
        return class_2172.method_9265(ChatLogAppender.INSTANCE.allowedLoggerNames(), (SuggestionsBuilder)builder);
    }

    private static int enable(CommandContext<FabricClientCommandSource> ctx) {
        String loggerName = StringArgumentType.getString(ctx, (String)"logger-name");
        ChatLogAppender.INSTANCE.allowedLoggerNames().add(loggerName);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.gadget.chat-log.enable.success", (Object[])new Object[]{loggerName}));
        return 0;
    }

    private static int disable(CommandContext<FabricClientCommandSource> ctx) {
        String loggerName = StringArgumentType.getString(ctx, (String)"logger-name");
        ChatLogAppender.INSTANCE.allowedLoggerNames().remove(loggerName);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.gadget.chat-log.disable.success", (Object[])new Object[]{loggerName}));
        return 0;
    }
}

