/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.command;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.wispforest.gadget.mappings.MappingsManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public final class ReloadMappingsCommand {
    private ReloadMappingsCommand() {
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"gadget").then(ClientCommandManager.literal((String)"reload_mappings").executes(ReloadMappingsCommand::reload)));
    }

    private static int reload(CommandContext<FabricClientCommandSource> ctx) {
        Path mappingsDir = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("mappings");
        if (Files.exists(mappingsDir, new LinkOption[0])) {
            try {
                MoreFiles.deleteRecursively((Path)mappingsDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        MappingsManager.reloadMappings();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.gadget.reload_mappings.success"));
        return 1;
    }
}

