/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.config;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Expanded;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class RemappingListOptionContainer
extends CollapsibleContainer
implements Component,
OptionValueProvider {
    protected final Option<List<String>> backingOption;
    protected final List<String> backingList;
    private final Function<String, String> remapper;
    private final Function<String, String> unmapper;
    protected final class_4185 resetButton;

    public RemappingListOptionContainer(Option<List<String>> option, Function<String, String> remapper, Function<String, String> unmapper) {
        super(Sizing.fill((int)100), Sizing.content(), (class_2561)class_2561.method_43471((String)("text.config." + option.configName() + ".option." + option.key().asString())), option.backingField().field().isAnnotationPresent(Expanded.class));
        this.backingOption = option;
        this.backingList = new ArrayList<String>((Collection)option.value());
        this.remapper = remapper;
        this.unmapper = unmapper;
        this.padding(((Insets)this.padding.get()).add(0, 5, 0, 0));
        this.titleLayout.horizontalSizing(Sizing.fill((int)100));
        this.titleLayout.verticalSizing(Sizing.fixed((int)30));
        this.titleLayout.verticalAlignment(VerticalAlignment.CENTER);
        if (!option.detached()) {
            this.titleLayout.child(Components.label((class_2561)class_2561.method_43471((String)"text.owo.config.list.add_entry").method_27692(class_124.field_1080)).configure(label -> {
                label.cursorStyle(CursorStyle.HAND);
                label.mouseEnter().subscribe(() -> label.text((class_2561)label.text().method_27661().method_27694(style -> style.method_10977(class_124.field_1054))));
                label.mouseLeave().subscribe(() -> label.text((class_2561)label.text().method_27661().method_27694(style -> style.method_10977(class_124.field_1080))));
                label.mouseDown().subscribe((click, doubled) -> {
                    UISounds.playInteractionSound();
                    this.backingList.add("");
                    if (!this.expanded) {
                        this.toggleExpansion();
                    }
                    this.refreshOptions();
                    ParentComponent lastEntry = (ParentComponent)this.collapsibleChildren.get(this.collapsibleChildren.size() - 1);
                    this.focusHandler().focus((Component)lastEntry.children().get(lastEntry.children().size() - 1), Component.FocusSource.MOUSE_CLICK);
                    return true;
                });
            }));
        }
        this.resetButton = Components.button((class_2561)class_2561.method_43470((String)"\u21c4"), button -> {
            this.backingList.clear();
            this.backingList.addAll((Collection)option.defaultValue());
            this.refreshOptions();
            button.field_22763 = false;
        });
        this.resetButton.margins(Insets.right((int)10));
        this.resetButton.positioning(Positioning.relative((int)100, (int)50));
        this.titleLayout.child((Component)this.resetButton);
        this.refreshResetButton();
        this.refreshOptions();
        this.titleLayout.child((Component)new SearchAnchorComponent((ParentComponent)this.titleLayout, option.key(), new Supplier[]{() -> class_1074.method_4662((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> this.backingList.stream().map(remapper).collect(Collectors.joining())}));
    }

    protected void refreshOptions() {
        this.collapsibleChildren.clear();
        Class listType = ReflectionUtils.getTypeArgument((Type)this.backingOption.backingField().field().getGenericType(), (int)0);
        if (listType == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < this.backingList.size(); ++i) {
            FlowLayout container = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            container.verticalAlignment(VerticalAlignment.CENTER);
            int optionIndex = i;
            LabelComponent label = Components.label((class_2561)TextOps.withFormatting((String)"- ", (class_124[])new class_124[]{class_124.field_1080}));
            label.margins(Insets.left((int)10));
            if (!this.backingOption.detached()) {
                label.cursorStyle(CursorStyle.HAND);
                label.mouseEnter().subscribe(() -> label.text((class_2561)TextOps.withFormatting((String)"x ", (class_124[])new class_124[]{class_124.field_1080})));
                label.mouseLeave().subscribe(() -> label.text((class_2561)TextOps.withFormatting((String)"- ", (class_124[])new class_124[]{class_124.field_1080})));
                label.mouseDown().subscribe((click, doubled) -> {
                    this.backingList.remove(optionIndex);
                    this.refreshResetButton();
                    this.refreshOptions();
                    UISounds.playInteractionSound();
                    return true;
                });
            }
            container.child((Component)label);
            ConfigTextBox box = new ConfigTextBox();
            box.method_1852(this.remapper.apply(this.backingList.get(i)));
            box.method_1870(false);
            box.method_1858(false);
            box.margins(Insets.vertical((int)2));
            box.horizontalSizing(Sizing.fill((int)95));
            box.verticalSizing(Sizing.fixed((int)8));
            if (!this.backingOption.detached()) {
                box.onChanged().subscribe(s -> {
                    if (!box.isValid()) {
                        return;
                    }
                    this.backingList.set(optionIndex, this.unmapper.apply((String)box.parsedValue()));
                    this.refreshResetButton();
                });
            } else {
                box.field_22763 = false;
            }
            if (NumberReflection.isNumberType((Class)listType)) {
                box.configureForNumber(listType);
            }
            container.child((Component)box);
            this.collapsibleChildren.add(container);
        }
        this.contentLayout.configure(layout -> {
            layout.clearChildren();
            if (this.expanded) {
                layout.children((Collection)this.collapsibleChildren);
            }
        });
        this.refreshResetButton();
    }

    protected void refreshResetButton() {
        this.resetButton.field_22763 = !this.backingOption.detached() && !this.backingList.equals(this.backingOption.defaultValue());
    }

    public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        return mouseY - (double)this.y <= (double)this.titleLayout.height() && super.shouldDrawTooltip(mouseX, mouseY);
    }

    public boolean isValid() {
        return true;
    }

    public Object parsedValue() {
        return this.backingList;
    }
}

