/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.dump;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.gui.NotificationToast;
import io.wispforest.gadget.dump.fake.GadgetDynamicRegistriesPacket;
import io.wispforest.gadget.dump.write.PacketDumpWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_9127;
import net.minecraft.class_9157;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPacketDumper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"gadget/PacketDumper");
    public static final Path DUMP_DIR = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("dumps");
    private static volatile PacketDumpWriter WRITER;

    private ClientPacketDumper() {
    }

    public static void start(boolean doToast) {
        try {
            if (!Files.exists(DUMP_DIR, new LinkOption[0])) {
                Files.createDirectories(DUMP_DIR, new FileAttribute[0]);
            }
            String filename = class_156.method_44893() + ".gdump";
            WRITER = new PacketDumpWriter(DUMP_DIR.resolve(filename));
            LOGGER.info("Started dumping to {}", (Object)filename);
            class_634 handler = class_310.method_1551().method_1562();
            if (handler != null) {
                ClientPacketDumper.dump(GadgetDynamicRegistriesPacket.fromRegistries(handler.method_29091()), class_9157.field_48699);
            }
            if (doToast) {
                new NotificationToast((class_2561)class_2561.method_43471((String)"message.gadget.dump.started"), null).register();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        PacketDumpWriter dumper = WRITER;
        if (dumper == null) {
            return;
        }
        PacketDumpWriter packetDumpWriter = dumper;
        synchronized (packetDumpWriter) {
            if (dumper.isClosed()) {
                return;
            }
            try {
                LOGGER.info("Saved dump to {}", (Object)dumper.path());
                new NotificationToast((class_2561)class_2561.method_43471((String)"message.gadget.dump.stopped"), (class_2561)class_2561.method_43470((String)dumper.path().getFileName().toString())).register();
                dumper.close();
                WRITER = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void dump(class_2596<?> packet, class_9127<?> state) {
        PacketDumpWriter writer = WRITER;
        if (writer == null) {
            return;
        }
        if (packet instanceof class_2672 && Gadget.CONFIG.dropChunkData()) {
            return;
        }
        writer.write(packet, state);
    }

    public static void flushIfNeeded() {
        PacketDumpWriter writer = WRITER;
        if (writer == null) {
            return;
        }
        writer.flush();
        LOGGER.info("Flushing packet dump");
    }

    public static boolean isDumping() {
        return WRITER != null;
    }
}

