/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.dump;

import io.wispforest.gadget.client.gui.BasedVerticalFlowLayout;
import io.wispforest.gadget.client.gui.SidebarBuilder;
import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.read.PacketDumpReader;
import io.wispforest.gadget.dump.read.SearchTextData;
import io.wispforest.gadget.util.NumberUtil;
import io.wispforest.gadget.util.ProgressToast;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;

public class DumpStatsScreen
extends BaseOwoScreen<FlowLayout> {
    private final Map<String, PacketTypeData> packetTypes = new HashMap<String, PacketTypeData>();
    private final class_437 parent;
    private final PacketDumpReader reader;
    private int totalSize = 0;

    public DumpStatsScreen(class_437 parent, PacketDumpReader reader, ProgressToast toast) {
        this.parent = parent;
        this.reader = reader;
        MutableLong progress = new MutableLong(0L);
        toast.followProgress(() -> ((MutableLong)progress).getValue(), reader.packets().size());
        for (DumpedPacket packet : reader.packets()) {
            PacketTypeData type = this.packetTypes.computeIfAbsent(packet.get(SearchTextData.KEY).searchText(), unused -> new PacketTypeData());
            ++type.total;
            type.size += packet.size();
            this.totalSize += packet.size();
            progress.add(1L);
        }
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        BasedVerticalFlowLayout main = new BasedVerticalFlowLayout(Sizing.fill((int)100), Sizing.content());
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)100), (Component)main).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        main.padding(Insets.vertical((int)15));
        this.packetTypes.entrySet().stream().sorted(Comparator.comparing(x -> -((PacketTypeData)x.getValue()).size)).forEachOrdered(x -> {
            double sizePercent = (double)((PacketTypeData)x.getValue()).size / (double)this.totalSize;
            double totalPercent = (double)((PacketTypeData)x.getValue()).total / (double)this.reader.packets().size();
            class_5250 total = class_2561.method_43470((String)((String)x.getKey())).method_10852((class_2561)class_2561.method_43470((String)(" " + ((PacketTypeData)x.getValue()).total + " packets,")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" " + NumberUtil.formatFileSize(((PacketTypeData)x.getValue()).size) + " total")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("\n  " + NumberUtil.formatPercent(sizePercent) + " of size"))).method_10852((class_2561)class_2561.method_43470((String)("\n  " + NumberUtil.formatPercent(totalPercent) + " of packets")));
            main.child((Component)Components.label((class_2561)total).margins(Insets.bottom((int)3)));
        });
        SidebarBuilder sidebar = new SidebarBuilder();
        sidebar.button("text.gadget.back", (mouseX, mouseY) -> this.method_25419());
        rootComponent.child((Component)scroll).child((Component)sidebar.layout());
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private static class PacketTypeData {
        private int total;
        private int size;

        private PacketTypeData() {
        }
    }
}

