/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.dump;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.dump.DumpStatsScreen;
import io.wispforest.gadget.client.dump.RenderedPacketComponent;
import io.wispforest.gadget.client.gui.BasedSliderComponent;
import io.wispforest.gadget.client.gui.BasedVerticalFlowLayout;
import io.wispforest.gadget.client.gui.EventEaterWrapper;
import io.wispforest.gadget.client.gui.NotificationToast;
import io.wispforest.gadget.client.gui.SaveFilePathComponent;
import io.wispforest.gadget.client.gui.SidebarBuilder;
import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.read.PacketDumpReader;
import io.wispforest.gadget.util.CancellationToken;
import io.wispforest.gadget.util.CancellationTokenSource;
import io.wispforest.gadget.util.FormattedDumper;
import io.wispforest.gadget.util.ProgressToast;
import io.wispforest.gadget.util.ReactiveUtils;
import io.wispforest.gadget.util.TimeUtil;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.util.Observable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;

public class OpenDumpScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private ProgressToast toast;
    private final PacketDumpReader reader;
    private final Path path;
    private FlowLayout main;
    private BasedSliderComponent timeSlider;
    private TextBoxComponent searchBox;
    private CancellationTokenSource currentSearchToken = null;
    private CancellationTokenSource screenOpenToken;

    private OpenDumpScreen(class_437 parent, ProgressToast toast, PacketDumpReader reader, Path path) {
        this.parent = parent;
        this.toast = toast;
        this.reader = reader;
        this.path = path;
    }

    public static void openWithProgress(class_437 parent, Path path) {
        ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"message.gadget.loading_dump"));
        class_310 client = class_310.method_1551();
        toast.follow((CompletableFuture<Void>)CompletableFuture.supplyAsync(() -> {
            try {
                toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.reading_packets"));
                PacketDumpReader reader = new PacketDumpReader(path, toast);
                if (reader.readError() != null) {
                    new NotificationToast((class_2561)class_2561.method_43471((String)"message.gadget.dump.error"), (class_2561)class_2561.method_43471((String)"message.gadget.dump.error.desc")).register();
                }
                toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.building_screen"));
                OpenDumpScreen screen = new OpenDumpScreen(parent, toast, reader, path);
                return screen;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).thenAcceptAsync(arg_0 -> ((class_310)client).method_1507(arg_0), (Executor)client), true);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void method_25426() {
        if (this.screenOpenToken == null || this.screenOpenToken.token().cancelled()) {
            this.screenOpenToken = new CancellationTokenSource();
        }
        super.method_25426();
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        this.main = new BasedVerticalFlowLayout(Sizing.fill((int)100), Sizing.content());
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)90), (Component)this.main).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        this.searchBox = Components.textBox((Sizing)Sizing.fill((int)95));
        this.searchBox.onChanged().subscribe(text -> this.rebuild(text, this.currentTime()));
        this.searchBox.margins(Insets.bottom((int)3));
        this.searchBox.method_1880(1000);
        rootComponent.keyPress().subscribe(input -> {
            if (input.comp_4795() != 70 || !input.method_74240()) {
                return false;
            }
            ((FlowLayout)this.uiAdapter.rootComponent).focusHandler().focus((Component)this.searchBox, Component.FocusSource.MOUSE_CLICK);
            return true;
        });
        this.timeSlider = new BasedSliderComponent(Sizing.fill((int)95));
        this.timeSlider.tooltipFactory(value -> class_2561.method_30163((String)TimeUtil.toHMS(this.currentTime((double)value) - this.reader.startTime()))).message(unused -> class_2561.method_30163((String)TimeUtil.toHMS(this.currentTime() - this.reader.startTime())));
        this.timeSlider.onChanged().subscribe(value -> this.rebuild(this.searchBox.method_1882(), this.currentTime()));
        rootComponent.child((Component)this.searchBox);
        if (this.reader.endTime() > this.reader.startTime()) {
            rootComponent.child((Component)this.timeSlider);
        }
        rootComponent.child((Component)scroll.child((Component)this.main).margins(Insets.top((int)5)));
        this.main.padding(Insets.of((int)15));
        this.rebuild("", this.reader.startTime());
        SidebarBuilder sidebar = new SidebarBuilder();
        SidebarBuilder.Button infoButton = new SidebarBuilder.Button((class_2561)class_2561.method_43471((String)"text.gadget.info"), (class_2561)class_2561.method_43473()){
            private int totalComponents;
            private int frameNumber;
            {
                this.totalComponents = -1;
                this.frameNumber = 11;
            }

            public void drawTooltip(OwoUIDrawContext ctx, int mouseX, int mouseY, float partialTicks, float delta) {
                ++this.frameNumber;
                if (!this.shouldDrawTooltip(mouseX, mouseY)) {
                    return;
                }
                if (this.frameNumber > 9) {
                    this.frameNumber = 0;
                    MutableInt total = new MutableInt();
                    ((FlowLayout)((OpenDumpScreen)OpenDumpScreen.this).uiAdapter.rootComponent).forEachDescendant(c -> total.increment());
                    this.totalComponents = total.getValue();
                }
                ArrayList<class_5684> tooltip = new ArrayList<class_5684>();
                tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"text.gadget.info.fps", (Object[])new Object[]{OpenDumpScreen.this.field_22787.method_47599()}).method_30937()));
                tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"text.gadget.info.total_components", (Object[])new Object[]{this.totalComponents}).method_30937()));
                tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"text.gadget.info.total_packets", (Object[])new Object[]{OpenDumpScreen.this.reader.packets().size()}).method_30937()));
                tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"text.gadget.info.packets_on_screen", (Object[])new Object[]{OpenDumpScreen.this.main.children().size()}).method_30937()));
                ctx.drawTooltip(((OpenDumpScreen)OpenDumpScreen.this).field_22787.field_1772, mouseX, mouseY, tooltip);
            }
        };
        sidebar.layout().child((Component)infoButton);
        sidebar.button("text.gadget.stats", (mouseX, mouseY) -> {
            ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"message.gadget.loading_dump_stats"));
            toast.follow((CompletableFuture<Void>)CompletableFuture.supplyAsync(() -> {
                toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.calculating_data"));
                return new DumpStatsScreen((class_437)this, this.reader, toast);
            }).thenAcceptAsync(arg_0 -> ((class_310)this.field_22787).method_1507(arg_0), (Executor)this.field_22787), true);
        });
        sidebar.button("text.gadget.export_button", (mouseX, mouseY) -> this.openExportModal());
        rootComponent.child((Component)sidebar.layout());
        this.toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.mounting_components"));
    }

    public void method_25432() {
        super.method_25432();
        if (this.screenOpenToken != null) {
            this.screenOpenToken.cancel();
        }
    }

    private long currentTime(double value) {
        return (long)class_3532.method_16436((double)value, (double)this.reader.startTime(), (double)this.reader.endTime());
    }

    private long currentTime() {
        return this.currentTime(this.timeSlider.value());
    }

    private void dumpTextToFile(Path savePath, List<DumpedPacket> packets) {
        try {
            OutputStream os = Files.newOutputStream(savePath, new OpenOption[0]);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintStream printStream = new PrintStream((OutputStream)bos, true, StandardCharsets.UTF_8.name());
            FormattedDumper dumper = new FormattedDumper(printStream);
            ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"text.gadget.export.exporting_packet_dump"));
            dumper.write(0, "Packet dump " + this.path.getFileName().toString());
            dumper.write(0, "Search text is " + this.searchBox.method_1882());
            dumper.write(0, packets.size() + " total packets");
            dumper.write(0, "");
            MutableLong progress = new MutableLong();
            toast.force();
            toast.followProgress(() -> ((MutableLong)progress).getValue(), packets.size());
            toast.follow(CompletableFuture.runAsync(() -> {
                for (DumpedPacket packet : packets) {
                    this.reader.dumpPacketToText(packet, dumper, 0);
                    progress.increment();
                    this.screenOpenToken.token().throwIfCancelled();
                }
                try {
                    bos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void openExportModal() {
        FlowLayout exportModal = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        final CancellationTokenSource tokSource = new CancellationTokenSource();
        OverlayContainer<EventEaterWrapper<FlowLayout>> exportOverlay = new OverlayContainer<EventEaterWrapper<FlowLayout>>(this, new EventEaterWrapper<FlowLayout>(exportModal)){

            public void dismount(Component.DismountReason reason) {
                super.dismount(reason);
                if (reason != Component.DismountReason.REMOVED) {
                    return;
                }
                tokSource.cancel();
            }
        };
        exportModal.surface(Surface.DARK_PANEL).padding(Insets.of((int)8));
        exportModal.child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.gadget.export.packet_dump")).margins(Insets.bottom((int)4)));
        SaveFilePathComponent savePath = new SaveFilePathComponent("Export packet dump", this.path.toString() + ".txt").pattern("*.txt").filterDescription("Plain Text file");
        LabelComponent progressLabel = Components.label((class_2561)class_2561.method_43469((String)"text.gadget.export.gather_progress", (Object[])new Object[]{0}));
        Observable count = Observable.of((Object)0);
        ReactiveUtils.throttle(count, TimeUnit.MILLISECONDS.toNanos(100L), (Executor)this.field_22787).observe(progress -> progressLabel.text((class_2561)class_2561.method_43469((String)"text.gadget.export.gather_progress", (Object[])new Object[]{progress})));
        CompletableFuture<List> collected = CompletableFuture.supplyAsync(() -> this.reader.collectFor(this.searchBox.method_1882(), this.currentTime(), Integer.MAX_VALUE, arg_0 -> ((Observable)count).set(arg_0), tokSource.token()));
        exportModal.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.gadget.export.output_path"))).child((Component)savePath).verticalAlignment(VerticalAlignment.CENTER));
        exportModal.child((Component)progressLabel);
        ButtonComponent button = Components.button((class_2561)class_2561.method_43471((String)"text.gadget.export.export_button"), arg_0 -> this.lambda$openExportModal$12(tokSource, exportOverlay, savePath, collected, arg_0));
        button.active(false);
        collected.whenCompleteAsync((r, t) -> {
            if (t != null) {
                exportModal.child(exportModal.children().size() - 1, (Component)Components.label((class_2561)class_2561.method_43471((String)"text.gadget.export.error")));
                Gadget.LOGGER.error("Error occured while gathering packets for export", t);
            } else {
                button.active(true);
            }
        }, (Executor)this.field_22787);
        exportModal.child((Component)button);
        ((FlowLayout)this.uiAdapter.rootComponent).child((Component)exportOverlay);
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4795() == 69 && input.method_74240()) {
            this.openExportModal();
            return true;
        }
        if (input.comp_4795() == 256) {
            for (Component rootChild : ((FlowLayout)this.uiAdapter.rootComponent).children()) {
                OverlayContainer overlay;
                if (!(rootChild instanceof OverlayContainer) || !(overlay = (OverlayContainer)rootChild).closeOnClick()) continue;
                overlay.remove();
                return true;
            }
        }
        return super.method_25404(input);
    }

    private void rebuild(String searchText, long time) {
        if (this.currentSearchToken != null) {
            this.currentSearchToken.cancel();
        }
        this.currentSearchToken = new CancellationTokenSource();
        CancellationToken token = this.currentSearchToken.token();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            ArrayList<Component> neededComponents = new ArrayList<Component>();
            for (DumpedPacket packet : this.reader.collectFor(searchText, time, 300, unused -> {}, token)) {
                token.throwIfCancelled();
                neededComponents.add(packet.get(RenderedPacketComponent.KEY).component());
            }
            return neededComponents;
        }).thenAcceptAsync(components -> this.main.configure(a -> {
            this.main.clearChildren();
            this.main.children((Collection)components);
        }), (Executor)this.field_22787)).whenComplete((r, t) -> {
            if (t != null) {
                if (t.getCause() instanceof CancellationException) {
                    return;
                }
                Gadget.LOGGER.error("Search failed!", t);
            }
        });
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private /* synthetic */ void lambda$openExportModal$12(CancellationTokenSource tokSource, 2 exportOverlay, SaveFilePathComponent savePath, CompletableFuture collected, ButtonComponent b) {
        tokSource.token().throwIfCancelled();
        exportOverlay.remove();
        this.dumpTextToFile(Path.of((String)savePath.path().get(), new String[0]), (List)collected.join());
    }
}

