/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.dump;

import io.wispforest.gadget.client.dump.handler.PacketRenderer;
import io.wispforest.gadget.client.gui.BasedLabelComponent;
import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.gadget.client.gui.LayoutCacheWrapper;
import io.wispforest.gadget.client.gui.SubObjectContainer;
import io.wispforest.gadget.dump.fake.GadgetReadErrorPacket;
import io.wispforest.gadget.dump.fake.GadgetWriteErrorPacket;
import io.wispforest.gadget.dump.read.DumpReaderContext;
import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.read.SearchTextData;
import io.wispforest.gadget.dump.read.UnwrappedPacketData;
import io.wispforest.gadget.util.ContextData;
import io.wispforest.gadget.util.ReflectionUtil;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_5250;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class RenderedPacketComponent {
    public static final ContextData.Key<DumpedPacket, RenderedPacketComponent> KEY = new ContextData.Key<DumpedPacket, RenderedPacketComponent>(RenderedPacketComponent::new);
    private final DumpedPacket packet;
    private SoftReference<Component> component;
    private final List<Throwable> drawErrors = new ArrayList<Throwable>();

    public RenderedPacketComponent(DumpedPacket packet) {
        this.packet = packet;
    }

    public List<Throwable> drawErrors() {
        return this.drawErrors;
    }

    public Component component() {
        if (this.component == null || this.component.get() == null) {
            FlowLayout view = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            view.padding(Insets.of((int)5)).surface(Surface.outline((int)this.packet.color())).margins(Insets.bottom((int)5));
            class_5250 typeText = class_2561.method_43470((String)"");
            class_2596<?> class_25962 = this.packet.packet();
            if (class_25962 instanceof GadgetReadErrorPacket) {
                GadgetReadErrorPacket errorPacket = (GadgetReadErrorPacket)class_25962;
                typeText.method_10852((class_2561)class_2561.method_43469((String)"text.gadget.packet_read_error", (Object[])new Object[]{errorPacket.packetId()}));
            } else {
                class_25962 = this.packet.packet();
                if (class_25962 instanceof GadgetWriteErrorPacket) {
                    GadgetWriteErrorPacket errorPacket = (GadgetWriteErrorPacket)class_25962;
                    typeText.method_10852((class_2561)class_2561.method_43469((String)"text.gadget.packet_write_error", (Object[])new Object[]{errorPacket.packetId()}));
                } else {
                    typeText.method_27693(ReflectionUtil.nameWithoutPackage(this.packet.packet().getClass()));
                    if (this.packet.channelId() != null) {
                        typeText.method_10852((class_2561)class_2561.method_43470((String)(" " + String.valueOf(this.packet.channelId()))).method_27692(class_124.field_1080));
                    }
                }
            }
            DumpReaderContext readerCtx = this.packet.get(DumpReaderContext.KEY);
            if (readerCtx != null) {
                typeText.method_27693(" ");
                typeText.method_10852((class_2561)class_2561.method_43470((String)DurationFormatUtils.formatDuration((long)(this.packet.sentAt() - readerCtx.reader().startTime()), (String)"mm:ss.SSS")).method_27692(class_124.field_1063));
            }
            SubObjectContainer container = new SubObjectContainer(unused -> {}, unused -> {});
            container.padding(Insets.of((int)0)).surface(Surface.BLANK);
            container.toggleExpansion();
            view.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)new BasedLabelComponent((class_2561)typeText)).child(container.getSpinnyBoi()).margins(Insets.bottom((int)3)));
            this.drawErrors.clear();
            ((PacketRenderer)PacketRenderer.EVENT.invoker()).renderPacket(this.packet, container, this.drawErrors::add);
            if (!this.drawErrors.isEmpty() || this.packet.packet() instanceof GadgetReadErrorPacket || this.packet.packet() instanceof GadgetWriteErrorPacket) {
                Record error;
                CollapsibleContainer errors = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (class_2561)class_2561.method_43471((String)"text.gadget.packet_errors"), (boolean)false);
                errors.padding(Insets.of((int)2)).margins(Insets.bottom((int)5));
                ((FlowLayout)errors.children().get(0)).padding(Insets.of((int)2, (int)2, (int)2, (int)0));
                class_2596<?> class_25963 = this.packet.packet();
                if (class_25963 instanceof GadgetReadErrorPacket) {
                    error = (GadgetReadErrorPacket)class_25963;
                    errors.child((Component)GuiUtil.showException(((GadgetReadErrorPacket)error).exception()).margins(Insets.bottom((int)2)));
                }
                if ((class_25963 = this.packet.packet()) instanceof GadgetWriteErrorPacket) {
                    error = (GadgetWriteErrorPacket)class_25963;
                    errors.child((Component)GuiUtil.showExceptionText(((GadgetWriteErrorPacket)error).exceptionText()).margins(Insets.bottom((int)2)));
                }
                for (Throwable e : this.packet.get(SearchTextData.KEY).searchTextErrors()) {
                    errors.child((Component)GuiUtil.showException(e).margins(Insets.bottom((int)2)));
                }
                for (Throwable e : this.packet.get(KEY).drawErrors()) {
                    errors.child((Component)GuiUtil.showException(e).margins(Insets.bottom((int)2)));
                }
                for (Throwable e : this.packet.get(UnwrappedPacketData.KEY).errors()) {
                    errors.child((Component)GuiUtil.showException(e).margins(Insets.bottom((int)2)));
                }
                container.child(0, (Component)errors);
            }
            view.child((Component)container);
            FlowLayout fullRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            fullRow.child((Component)view).horizontalAlignment(this.packet.outbound() ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT);
            this.component = new SoftReference<LayoutCacheWrapper<FlowLayout>>(new LayoutCacheWrapper<FlowLayout>(fullRow));
        }
        return this.component.get();
    }
}

