/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.field;

import com.google.gson.stream.JsonWriter;
import io.wispforest.gadget.client.field.ClientFieldDataNode;
import io.wispforest.gadget.client.field.FieldDataIsland;
import io.wispforest.gadget.client.field.RemoteFieldDataSource;
import io.wispforest.gadget.client.gui.EventEaterWrapper;
import io.wispforest.gadget.client.gui.SaveFilePathComponent;
import io.wispforest.gadget.client.gui.SidebarBuilder;
import io.wispforest.gadget.client.gui.search.SearchGui;
import io.wispforest.gadget.field.FieldDataSource;
import io.wispforest.gadget.field.LocalFieldDataSource;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.network.GadgetNetworking;
import io.wispforest.gadget.network.InspectionTarget;
import io.wispforest.gadget.network.packet.c2s.OpenFieldDataScreenC2SPacket;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.util.FormattedDumper;
import io.wispforest.gadget.util.ProgressToast;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_11908;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDataScreen
extends BaseOwoScreen<FlowLayout> {
    private final InspectionTarget target;
    private final FieldDataSource dataSource;
    private final boolean isClient;
    public final FieldDataIsland island;

    public FieldDataScreen(InspectionTarget target, boolean isClient, boolean isMutable, @Nullable FieldData rootData, @Nullable Map<PathStep, FieldData> initialFields) {
        this.target = target;
        this.isClient = isClient;
        this.dataSource = !isClient ? new RemoteFieldDataSource(target, rootData, initialFields) : new LocalFieldDataSource(target.resolve((class_1937)class_310.method_1551().field_1687), isMutable);
        this.island = new FieldDataIsland(this.dataSource, false, true);
    }

    public InspectionTarget target() {
        return this.target;
    }

    public boolean isClient() {
        return this.isClient;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout verticalFlowLayout) {
        verticalFlowLayout.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        FlowLayout main = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)100), (Component)main).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        verticalFlowLayout.child((Component)scroll.child((Component)main));
        main.padding(Insets.of((int)15, (int)22, (int)15, (int)15));
        main.child((Component)this.island.mainContainer());
        SidebarBuilder sidebar = new SidebarBuilder();
        sidebar.button((class_2561)class_2561.method_43471((String)("text.gadget." + (this.isClient() ? "client" : "server") + "_view.icon")), (class_2561)class_2561.method_43471((String)("text.gadget." + (this.isClient() ? "client" : "server") + "_view" + (GadgetNetworking.CHANNEL.canSendToServer() ? "" : ".no_switch") + ".tooltip")), (mouseX, mouseY) -> {
            if (!GadgetNetworking.CHANNEL.canSendToServer()) {
                return;
            }
            if (this.isClient()) {
                GadgetNetworking.CHANNEL.clientHandle().send((Record)new OpenFieldDataScreenC2SPacket(this.target));
            } else {
                this.field_22787.method_1507((class_437)new FieldDataScreen(this.target, true, true, null, null));
            }
        });
        sidebar.button("text.gadget.export_button", (mouseX, mouseY) -> this.openExportModal());
        SearchGui search = new SearchGui(scroll);
        verticalFlowLayout.child((Component)search.positioning(Positioning.relative((int)0, (int)100)));
        verticalFlowLayout.keyPress().subscribe(input -> {
            if (input.comp_4795() != 70 || !input.method_74240()) {
                return false;
            }
            ((FlowLayout)this.uiAdapter.rootComponent).focusHandler().focus((Component)search.searchBox(), Component.FocusSource.MOUSE_CLICK);
            return true;
        });
        verticalFlowLayout.child((Component)sidebar.layout());
    }

    public void openExportModal() {
        FlowLayout exportModal = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        OverlayContainer exportOverlay = Containers.overlay(new EventEaterWrapper<FlowLayout>(exportModal));
        exportModal.surface(Surface.DARK_PANEL).padding(Insets.of((int)8));
        exportModal.child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.gadget.export.packet_dump")).margins(Insets.bottom((int)4)));
        SaveFilePathComponent savePath = new SaveFilePathComponent(class_1074.method_4662((String)"text.gadget.export.packet_dump", (Object[])new Object[0]), FabricLoader.getInstance().getGameDir().toString() + "/").patterns(List.of("*.txt", "*.json")).filterDescription("Plain text/JSON file");
        exportModal.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.gadget.export.output_path"))).child((Component)savePath).verticalAlignment(VerticalAlignment.CENTER));
        ButtonComponent button = Components.button((class_2561)class_2561.method_43471((String)"text.gadget.export.export_button"), b -> {
            block4: {
                Path path = Path.of((String)savePath.path().get(), new String[0]);
                exportOverlay.remove();
                try {
                    if (path.toString().endsWith(".json")) {
                        this.dumpToJson(path);
                        break block4;
                    }
                    if (path.toString().endsWith(".txt")) {
                        this.dumpToPlainText(path);
                        break block4;
                    }
                    throw new UnsupportedOperationException("Unsupported output file type");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        savePath.path().observe(path -> button.active(path.endsWith(".json") || path.endsWith(".txt")));
        button.active(false);
        exportModal.child((Component)button);
        ((FlowLayout)this.uiAdapter.rootComponent).child((Component)exportOverlay);
    }

    public void dumpToJson(Path path) throws IOException {
        BufferedWriter bw = Files.newBufferedWriter(path, new OpenOption[0]);
        JsonWriter writer = new JsonWriter((Writer)bw);
        ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"text.gadget.exporting_field_dump"));
        CompletionStage future = this.island.dumpToJson(writer, (ClientFieldDataNode)this.island.root(), 5, f -> toast.step((class_2561)class_2561.method_43469((String)"text.gadget.exporting.dumping_path", (Object[])new Object[]{f.toString()}))).whenComplete((ignored1, ignored2) -> {
            try {
                bw.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        toast.follow((CompletableFuture<Void>)future, false);
    }

    public void dumpToPlainText(Path path) throws IOException {
        OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        FormattedDumper dumper = new FormattedDumper(new PrintStream(bos));
        dumper.write(0, "Field data of " + String.valueOf(this.target));
        this.island.dumpToText(dumper, 0, (ClientFieldDataNode)this.island.root(), 5).whenComplete((ignored1, ignored2) -> {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4795() == 69 && input.method_74240()) {
            this.openExportModal();
            return true;
        }
        return super.method_25404(input);
    }

    public FieldDataSource dataSource() {
        return this.dataSource;
    }

    public void method_25432() {
        FieldDataSource fieldDataSource = this.dataSource;
        if (fieldDataSource instanceof RemoteFieldDataSource) {
            RemoteFieldDataSource remote = (RemoteFieldDataSource)fieldDataSource;
            remote.close();
        }
    }
}

