/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.field;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.desc.edit.PrimitiveEditData;
import io.wispforest.gadget.field.FieldDataSource;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.network.GadgetNetworking;
import io.wispforest.gadget.network.InspectionTarget;
import io.wispforest.gadget.network.packet.c2s.FieldDataRequestC2SPacket;
import io.wispforest.gadget.network.packet.c2s.FieldDataSetNbtCompoundC2SPacket;
import io.wispforest.gadget.network.packet.c2s.FieldDataSetPrimitiveC2SPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataErrorS2CPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataResponseS2CPacket;
import io.wispforest.gadget.path.ObjectPath;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.util.CancellationTokenSource;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class RemoteFieldDataSource
implements FieldDataSource,
AutoCloseable {
    private final InspectionTarget target;
    private final FieldData rootData;
    private final Map<PathStep, FieldData> rootFields;
    private final CancellationTokenSource cancelSource = new CancellationTokenSource();
    private final Map<ObjectPath, CompletableFuture<Map<PathStep, FieldData>>> pendingFieldsRequests = new TreeMap<ObjectPath, CompletableFuture<Map<PathStep, FieldData>>>();

    public RemoteFieldDataSource(InspectionTarget target, FieldData rootData, Map<PathStep, FieldData> rootFields) {
        this.target = target;
        this.rootData = rootData;
        this.rootFields = rootFields;
    }

    @Override
    public FieldData rootData() {
        return this.rootData;
    }

    @Override
    public Map<PathStep, FieldData> initialRootFields() {
        return this.rootFields;
    }

    @Override
    public CompletableFuture<Map<PathStep, FieldData>> requestFieldsOf(ObjectPath path, int from, int limit) {
        this.cancelSource.token().throwIfCancelled();
        if (this.pendingFieldsRequests.containsKey(path)) {
            return this.pendingFieldsRequests.get(path);
        }
        CompletableFuture future = new CompletableFuture();
        this.pendingFieldsRequests.put(path, future);
        GadgetNetworking.CHANNEL.clientHandle().send((Record)new FieldDataRequestC2SPacket(this.target, path, from, limit));
        if (Gadget.CONFIG.internalSettings.dumpFieldDataRequests()) {
            Gadget.LOGGER.info("-> {}", (Object)path);
        }
        return this.cancelSource.token().wrapFuture(future.orTimeout(10L, TimeUnit.SECONDS));
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public CompletableFuture<Void> setPrimitiveAt(ObjectPath path, PrimitiveEditData editData) {
        this.cancelSource.token().throwIfCancelled();
        GadgetNetworking.CHANNEL.clientHandle().send((Record)new FieldDataSetPrimitiveC2SPacket(this.target, path, editData));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> setNbtCompoundAt(ObjectPath path, class_2487 tag) {
        this.cancelSource.token().throwIfCancelled();
        GadgetNetworking.CHANNEL.clientHandle().send((Record)new FieldDataSetNbtCompoundC2SPacket(this.target, path, tag));
        return CompletableFuture.completedFuture(null);
    }

    public void acceptPacket(FieldDataResponseS2CPacket packet) {
        CompletableFuture<Map<PathStep, FieldData>> future = this.pendingFieldsRequests.remove(packet.path());
        if (Gadget.CONFIG.internalSettings.dumpFieldDataRequests()) {
            Gadget.LOGGER.info("<- {}", (Object)packet.path());
        }
        if (future == null) {
            Gadget.LOGGER.error("FieldDataResponseS2CPacket received with unknown ObjectPath {}", (Object)packet.path());
            return;
        }
        future.complete(packet.fields());
    }

    public void acceptPacket(FieldDataErrorS2CPacket packet) {
        CompletableFuture<Map<PathStep, FieldData>> future = this.pendingFieldsRequests.remove(packet.path());
        if (Gadget.CONFIG.internalSettings.dumpFieldDataRequests()) {
            Gadget.LOGGER.info("<- {} (err)", (Object)packet.path());
        }
        if (future == null) {
            Gadget.LOGGER.error("FieldDataErrorS2CPacket received with unknown ObjectPath {}", (Object)packet.path());
            return;
        }
        future.completeExceptionally(new RemoteErrorException(packet.message()));
    }

    @Override
    public void close() {
        this.cancelSource.cancel();
    }

    public static class RemoteErrorException
    extends RuntimeException {
        private final class_2561 message;

        public RemoteErrorException(class_2561 message) {
            super(message.getString());
            this.message = message;
        }

        public class_2561 message() {
            return this.message;
        }
    }
}

