/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.DialogUtil;
import io.wispforest.gadget.client.ServerData;
import io.wispforest.gadget.client.dump.ClientPacketDumper;
import io.wispforest.gadget.client.dump.OpenDumpScreen;
import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.gadget.client.resource.ViewClassesScreen;
import io.wispforest.gadget.client.resource.ViewResourcesScreen;
import io.wispforest.gadget.network.GadgetNetworking;
import io.wispforest.gadget.network.packet.c2s.ListResourcesC2SPacket;
import io.wispforest.gadget.util.FileUtil;
import io.wispforest.gadget.util.NumberUtil;
import io.wispforest.gadget.util.ResourceUtil;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class GadgetScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private LabelComponent inspectClasses;

    public GadgetScreen(class_437 parent) {
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        FlowLayout main = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)100), (Component)main).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        rootComponent.child((Component)scroll.child((Component)main));
        main.padding(Insets.of((int)15));
        LabelComponent openOther = Components.label((class_2561)class_2561.method_43471((String)"text.gadget.open_other_dump"));
        openOther.margins(Insets.bottom((int)4));
        GuiUtil.semiButton(openOther, () -> {
            String path = DialogUtil.openFileDialog("Open other dump", null, List.of("*.dump"), "gadget network dumps", false);
            if (path != null) {
                OpenDumpScreen.openWithProgress((class_437)this, Path.of(path, new String[0]));
            }
        });
        main.child((Component)openOther);
        LabelComponent inspectResources = Components.label((class_2561)class_2561.method_43471((String)"text.gadget.inspect_resources"));
        inspectResources.margins(Insets.bottom((int)4));
        GuiUtil.semiButton(inspectResources, () -> {
            Map<class_2960, List<class_3298>> resources = ResourceUtil.collectAllResources(this.field_22787.method_1478());
            HashMap<class_2960, Integer> map = new HashMap<class_2960, Integer>();
            for (Map.Entry<class_2960, List<class_3298>> entry : resources.entrySet()) {
                map.put(entry.getKey(), entry.getValue().size());
            }
            ViewResourcesScreen screen = new ViewResourcesScreen((class_437)this, map);
            screen.resRequester((id, idx) -> screen.openFile((class_2960)id, () -> ((class_3298)((class_3298)this.field_22787.method_1478().method_14489(id).get((int)idx))).method_14482()));
            this.field_22787.method_1507((class_437)screen);
        });
        main.child((Component)inspectResources);
        if (ServerData.canRequestServerData()) {
            LabelComponent inspectServerData = Components.label((class_2561)class_2561.method_43471((String)"text.gadget.inspect_server_data"));
            inspectServerData.margins(Insets.bottom((int)4));
            GuiUtil.semiButton(inspectServerData, () -> GadgetNetworking.CHANNEL.clientHandle().send((Record)new ListResourcesC2SPacket()));
            main.child((Component)inspectServerData);
        }
        if (Gadget.CONFIG.inspectClasses()) {
            this.inspectClasses = Components.label((class_2561)class_2561.method_43471((String)"text.gadget.inspect_exported_classes"));
            this.inspectClasses.margins(Insets.bottom((int)4));
            GuiUtil.semiButton(this.inspectClasses, () -> ViewClassesScreen.openWithProgress((class_437)this));
            main.child((Component)this.inspectClasses);
        }
        try {
            if (!Files.exists(ClientPacketDumper.DUMP_DIR, new LinkOption[0])) {
                Files.createDirectories(ClientPacketDumper.DUMP_DIR, new FileAttribute[0]);
            }
            for (Path dump : FileUtil.listSortedByFileName(ClientPacketDumper.DUMP_DIR)) {
                String filename = dump.getFileName().toString();
                if (!filename.endsWith(".gdump") && !filename.endsWith(".dump")) continue;
                FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
                class_5250 labelText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"d ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)(filename + " "))).method_10852((class_2561)class_2561.method_43470((String)(NumberUtil.formatFileSize(Files.size(dump)) + " ")).method_27692(class_124.field_1080));
                row.child((Component)Components.label((class_2561)labelText)).padding(Insets.bottom((int)2));
                LabelComponent openLabel = Components.label((class_2561)class_2561.method_43471((String)"text.gadget.open"));
                GuiUtil.semiButton(openLabel, () -> OpenDumpScreen.openWithProgress((class_437)this, dump));
                row.child((Component)openLabel);
                main.child((Component)row);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4795() == 340 || input.comp_4795() == 344) {
            this.inspectClasses.text((class_2561)class_2561.method_43471((String)"text.gadget.inspect_all_classes"));
        }
        return super.method_25404(input);
    }

    public boolean method_16803(class_11908 input) {
        if (input.comp_4795() == 340 || input.comp_4795() == 344) {
            this.inspectClasses.text((class_2561)class_2561.method_43471((String)"text.gadget.inspect_exported_classes"));
        }
        return super.method_16803(input);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

