/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.util.ThrowableUtil;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_11719;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public final class GuiUtil {
    private static final int INVALID_COLOR = 15408438;
    private static final int VALID_COLOR = 2686911;

    private GuiUtil() {
    }

    public static void hoverBlue(LabelComponent label) {
        label.mouseEnter().subscribe(() -> label.text((class_2561)((class_5250)label.text()).method_27692(class_124.field_1078)));
        label.mouseLeave().subscribe(() -> label.text((class_2561)((class_5250)label.text()).method_27692(class_124.field_1068)));
    }

    public static void semiButton(LabelComponent label, Runnable onPressed) {
        GuiUtil.hoverBlue(label);
        label.cursorStyle(CursorStyle.HAND);
        label.mouseDown().subscribe((click, doubled) -> {
            if (click.method_74245() != 0) {
                return false;
            }
            UISounds.playButtonSound();
            onPressed.run();
            return true;
        });
    }

    public static void semiButton(LabelComponent label, BiConsumer<Double, Double> onPressed) {
        GuiUtil.hoverBlue(label);
        label.cursorStyle(CursorStyle.HAND);
        label.mouseDown().subscribe((click, doubled) -> {
            if (click.method_74245() != 0) {
                return false;
            }
            UISounds.playButtonSound();
            onPressed.accept(click.comp_4798(), click.comp_4799());
            return true;
        });
    }

    public static ParentComponent root(Component component) {
        ParentComponent parent;
        ParentComponent root;
        ParentComponent parentComponent = root = component instanceof ParentComponent ? (parent = (ParentComponent)component) : component.parent();
        if (root == null) {
            throw new IllegalStateException();
        }
        while (root.hasParent()) {
            root = root.parent();
        }
        return root;
    }

    public static DropdownComponent contextMenu(Component at, double mouseX, double mouseY) {
        FlowLayout root = (FlowLayout)GuiUtil.root(at);
        DropdownComponent dropdown = Components.dropdown((Sizing)Sizing.content());
        dropdown.positioning(Positioning.absolute((int)((int)mouseX + at.x()), (int)((int)mouseY + at.y())));
        ((ParentComponent)dropdown.children().get(0)).padding(Insets.of((int)3));
        dropdown.focusLost().subscribe(() -> dropdown.queue(() -> root.removeChild((Component)dropdown)));
        root.child((Component)dropdown);
        root.focusHandler().focus((Component)dropdown, Component.FocusSource.MOUSE_CLICK);
        return dropdown;
    }

    public static void textFieldVerifier(class_342 textField, Predicate<String> verifier) {
        textField.method_1863(text -> textField.method_1868(verifier.test((String)text) ? 2686911 : 15408438));
    }

    public static LabelComponent showException(Throwable e) {
        return GuiUtil.showExceptionText(ThrowableUtil.throwableToString(e));
    }

    public static LabelComponent showExceptionText(String fullExceptionText) {
        LabelComponent label = Components.label((class_2561)class_2561.method_43470((String)fullExceptionText.replace("\t", "    ")).method_27692(class_124.field_1061));
        label.horizontalSizing(Sizing.fill((int)99));
        return label;
    }

    public static void showMonospaceText(FlowLayout container, String all) {
        List<String> lines = all.lines().toList();
        int maxWidth = Integer.toString(lines.size() - 1).length();
        int i = 0;
        for (String line : lines) {
            container.child(Components.label((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(StringUtils.leftPad((String)Integer.toString(i), (int)maxWidth) + " ")).method_27692(class_124.field_1080).method_27694(x -> x.method_27704((class_11719)new class_11719.class_11721(Gadget.id("monocraft"))))).method_10852((class_2561)class_2561.method_43470((String)line.replace("\t", "    ")).method_27694(x -> x.method_27704((class_11719)new class_11719.class_11721(Gadget.id("monocraft")))))).horizontalSizing(Sizing.fill((int)99)));
            ++i;
        }
    }

    public static FlowLayout hexDump(byte[] bytes, boolean doEllipsis) {
        FlowLayout view = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        ArrayList<BaseComponent> expandedChildren = new ArrayList<BaseComponent>();
        int index = 0;
        while (index < bytes.length) {
            int i;
            StringBuilder line = new StringBuilder();
            line.append(String.format("%04x  ", index));
            for (i = 0; i < 16 && index < bytes.length; ++index, ++i) {
                short b = (short)(bytes[index] & 0xFF);
                line.append(String.format("%02x ", b));
            }
            line.append("   ".repeat(Math.max(0, 16 - i)));
            for (int j = 0; j < i; ++j) {
                short b = (short)(bytes[index - i + j] & 0xFF);
                if (b >= 32 && b < 127) {
                    line.append((char)b);
                    continue;
                }
                line.append('.');
            }
            BaseComponent label = Components.label((class_2561)class_2561.method_43470((String)line.toString()).method_27694(x -> x.method_27704((class_11719)new class_11719.class_11721(Gadget.id("monocraft"))))).margins(Insets.bottom((int)3));
            if (view.children().size() > 10 && doEllipsis) {
                expandedChildren.add(label);
                continue;
            }
            view.child((Component)label);
        }
        if (expandedChildren.size() > 0) {
            LabelComponent ellipsis = Components.label((class_2561)class_2561.method_43470((String)"..."));
            GuiUtil.semiButton(ellipsis, () -> {
                view.removeChild((Component)ellipsis);
                view.children((Collection)expandedChildren);
            });
            view.child((Component)ellipsis);
        }
        return view;
    }
}

