/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui;

import io.wispforest.gadget.client.DialogUtil;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2561;

public class SaveFilePathComponent
extends FlowLayout {
    private final String title;
    private final Observable<String> path;
    private final LabelComponent label;
    private List<String> patterns = new ArrayList<String>();
    private String filterDescription = null;

    public SaveFilePathComponent(String title, String defaultPath) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        this.title = title;
        this.path = Observable.of((Object)defaultPath);
        this.label = Components.label((class_2561)class_2561.method_43470((String)"breh"));
        this.configureLabel(defaultPath);
        this.path.observe(this::configureLabel);
        this.child((Component)this.label);
        this.padding(Insets.of((int)2));
        this.surface(Surface.flat((int)0x55555555));
        this.mouseEnter().subscribe(() -> this.surface(Surface.flat((int)-1431655766)));
        this.mouseLeave().subscribe(() -> this.surface(Surface.flat((int)0x55555555)));
        this.cursorStyle(CursorStyle.HAND);
        this.label.cursorStyle(CursorStyle.HAND);
    }

    private void configureLabel(String newPath) {
        int neededSlash = ((String)newPath).lastIndexOf(47, 40);
        if (neededSlash != -1) {
            newPath = "..." + ((String)newPath).substring(neededSlash);
        }
        this.label.text((class_2561)class_2561.method_43470((String)newPath));
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public SaveFilePathComponent patterns(List<String> patterns) {
        this.patterns = patterns;
        return this;
    }

    public SaveFilePathComponent pattern(String pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public String filterDescription() {
        return this.filterDescription;
    }

    public SaveFilePathComponent filterDescription(String description) {
        this.filterDescription = description;
        return this;
    }

    public boolean onMouseDown(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0) {
            Thread thread = new Thread(() -> {
                String selected = DialogUtil.saveFileDialog(this.title, (String)this.path.get(), this.patterns.isEmpty() ? null : this.patterns, this.filterDescription);
                if (selected != null) {
                    this.path.set((Object)selected);
                }
            }, "Save File Dialog Thread for " + String.valueOf((Object)this));
            thread.start();
            return true;
        }
        return super.onMouseDown(click, doubled);
    }

    public Observable<String> path() {
        return this.path;
    }
}

