/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui;

import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import org.joml.Matrix3x2fStack;

public class SubObjectContainer
extends FlowLayout {
    public static final Surface SURFACE = (ctx, component) -> ctx.method_25294(component.x() + 5, component.y(), component.x() + 6, component.y() + component.height(), 0x77FFFFFF);
    private final Consumer<SubObjectContainer> loader;
    private final Consumer<SubObjectContainer> unloader;
    protected final List<Component> collapsibleChildren = new ArrayList<Component>();
    protected boolean expanded;
    protected final SpinnyBoiComponent spinnyBoi;

    public SubObjectContainer(Consumer<SubObjectContainer> loader, Consumer<SubObjectContainer> unloader) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.loader = loader;
        this.unloader = unloader;
        this.surface(SURFACE);
        this.padding(Insets.left((int)15));
        this.allowOverflow(true);
        this.spinnyBoi = new SpinnyBoiComponent();
        this.spinnyBoi.cursorStyle(CursorStyle.HAND);
        this.expanded = false;
        this.spinnyBoi.rotation = this.spinnyBoi.targetRotation = 0.0f;
        GuiUtil.hoverBlue(this.spinnyBoi);
        this.spinnyBoi.mouseDown().subscribe((click, doubled) -> {
            this.toggleExpansion();
            UISounds.playInteractionSound();
            return true;
        });
    }

    public Component getSpinnyBoi() {
        return this.spinnyBoi;
    }

    public void toggleExpansion() {
        if (this.expanded) {
            this.children.removeAll(this.collapsibleChildren);
            this.spinnyBoi.targetRotation = 0.0f;
        } else {
            this.children.addAll(this.collapsibleChildren);
            this.spinnyBoi.targetRotation = 90.0f;
        }
        this.updateLayout();
        boolean bl = this.expanded = !this.expanded;
        if (this.expanded) {
            this.loader.accept(this);
        } else {
            this.unloader.accept(this);
        }
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.KEYBOARD_CYCLE;
    }

    public boolean onKeyPress(class_11908 input) {
        if (input.comp_4795() == 32 || input.comp_4795() == 257 || input.comp_4795() == 335) {
            this.toggleExpansion();
            super.onKeyPress(input);
            return true;
        }
        return super.onKeyPress(input);
    }

    public FlowLayout child(Component child) {
        this.collapsibleChildren.add(child);
        if (this.expanded) {
            super.child(child);
        }
        return this;
    }

    public FlowLayout child(int index, Component child) {
        this.collapsibleChildren.add(index, child);
        if (this.expanded) {
            super.child(index, child);
        }
        return this;
    }

    public FlowLayout removeChild(Component child) {
        this.collapsibleChildren.remove(child);
        return super.removeChild(child);
    }

    public FlowLayout clearChildren() {
        this.collapsibleChildren.clear();
        return super.clearChildren();
    }

    public List<Component> collapsibleChildren() {
        return this.collapsibleChildren;
    }

    protected static class SpinnyBoiComponent
    extends LabelComponent {
        protected float rotation = 90.0f;
        protected float targetRotation = 90.0f;

        public SpinnyBoiComponent() {
            super((class_2561)class_2561.method_43470((String)">"));
            this.margins(Insets.horizontal((int)4));
        }

        public void update(float delta, int mouseX, int mouseY) {
            super.update(delta, mouseX, mouseY);
            this.rotation = (float)((double)this.rotation + (double)((this.targetRotation - this.rotation) * delta) * 0.65);
        }

        public void draw(OwoUIDrawContext ctx, int mouseX, int mouseY, float partialTicks, float delta) {
            Matrix3x2fStack matrices = ctx.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)this.x + (float)this.width / 2.0f - 1.0f, (float)this.y + (float)this.height / 2.0f - 1.0f);
            matrices.rotate((float)Math.toRadians(this.rotation));
            matrices.translate(-((float)this.x + (float)this.width / 2.0f - 1.0f), -((float)this.y + (float)this.height / 2.0f - 1.0f));
            super.draw(ctx, mouseX, mouseY, partialTicks, delta);
            matrices.popMatrix();
        }
    }
}

