/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui.inspector;

import io.wispforest.gadget.client.gui.inspector.ElementSupport;
import io.wispforest.gadget.client.gui.inspector.REISupport;
import io.wispforest.gadget.client.gui.inspector.VanillaSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_339;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;

public class ElementUtils {
    private static final List<class_3545<Class<?>, ElementSupport<?>>> ELEMENT_SUPPORTS = new ArrayList();
    private static final List<BiConsumer<class_437, List<class_4069>>> ROOT_LISTERS = new ArrayList<BiConsumer<class_437, List<class_4069>>>();

    private static int getThroughSupport(class_364 element, ElementSupportGetter getter) {
        for (class_3545<Class<?>, ElementSupport<?>> pair : ELEMENT_SUPPORTS) {
            ElementSupport support;
            int val;
            if (!((Class)pair.method_15442()).isInstance(element) || (val = getter.get(support = (ElementSupport)pair.method_15441(), element)) == -1) continue;
            return val;
        }
        return -1;
    }

    public static <T extends class_364> void registerElementSupport(Class<T> klass, ElementSupport<T> support) {
        ELEMENT_SUPPORTS.add(new class_3545(klass, support));
    }

    public static void registerRootLister(BiConsumer<class_437, List<class_4069>> rootLister) {
        ROOT_LISTERS.add(rootLister);
    }

    public static List<class_4069> listRootElements(class_437 screen) {
        ArrayList<class_4069> parents = new ArrayList<class_4069>();
        for (BiConsumer<class_437, List<class_4069>> rootLister : ROOT_LISTERS) {
            rootLister.accept(screen, parents);
        }
        return parents;
    }

    public static int x(class_364 element) {
        return ElementUtils.getThroughSupport(element, ElementSupport::getX);
    }

    public static int y(class_364 element) {
        return ElementUtils.getThroughSupport(element, ElementSupport::getY);
    }

    public static int width(class_364 element) {
        return ElementUtils.getThroughSupport(element, ElementSupport::getWidth);
    }

    public static int height(class_364 element) {
        return ElementUtils.getThroughSupport(element, ElementSupport::getHeight);
    }

    public static boolean isVisible(class_364 element) {
        if (element instanceof class_339) {
            class_339 widget = (class_339)element;
            return widget.field_22764;
        }
        return true;
    }

    public static boolean inBoundingBox(class_364 e, int x, int y) {
        if (ElementUtils.x(e) == -1) {
            return false;
        }
        return x >= ElementUtils.x(e) && y >= ElementUtils.y(e) && x < ElementUtils.x(e) + ElementUtils.width(e) && y < ElementUtils.y(e) + ElementUtils.height(e);
    }

    public static void collectChildren(class_4069 root, List<class_364> children) {
        for (class_364 child : root.method_25396()) {
            if (child instanceof class_4069) {
                class_4069 parent = (class_4069)child;
                ElementUtils.collectChildren(parent, children);
            }
            children.add(child);
        }
    }

    static {
        VanillaSupport.init();
        if (FabricLoader.getInstance().isModLoaded("roughlyenoughitems")) {
            REISupport.init();
        }
    }

    private static interface ElementSupportGetter {
        public <T extends class_364> int get(ElementSupport<T> var1, T var2);
    }
}

