/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui.search;

import blue.endless.jankson.annotation.Nullable;
import io.wispforest.gadget.client.gui.search.SearchAnchorComponent;
import io.wispforest.gadget.client.gui.search.SearchHighlighterComponent;
import io.wispforest.gadget.client.gui.search.SearchMatches;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class SearchGui
extends FlowLayout {
    private final ScrollContainer<?> scroll;
    @Nullable
    protected SearchMatches currentMatches = null;
    private int currentMatchIndex;
    private final TextBoxComponent searchBox;

    public SearchGui(ScrollContainer<?> scroll) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        this.scroll = scroll;
        FlowLayout searchRow = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        this.searchBox = Components.textBox((Sizing)Sizing.fill((int)50));
        this.searchBox.method_1858(false);
        this.searchBox.verticalSizing(Sizing.fixed((int)9));
        LabelComponent matchIndicator = Components.label((class_2561)class_2561.method_43473());
        matchIndicator.margins(Insets.horizontal((int)5));
        searchRow.child((Component)this.searchBox).child((Component)matchIndicator).surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)3));
        this.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"owo", (String)"textures/gui/config_search.png"), (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).margins(Insets.of((int)2))).child((Component)searchRow);
        String searchHint = class_1074.method_4662((String)"text.owo.config.search", (Object[])new Object[0]);
        this.searchBox.method_1887(searchHint);
        this.searchBox.onChanged().subscribe(s -> {
            this.searchBox.method_1887(s.isEmpty() ? searchHint : "");
            this.searchBox.method_1868(-2039584);
            matchIndicator.text((class_2561)class_2561.method_43473());
        });
        this.searchBox.keyPress().subscribe(input -> {
            if (input.comp_4795() != 257) {
                return false;
            }
            String query = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
            if (query.isBlank()) {
                return false;
            }
            if (this.currentMatches != null && this.currentMatches.query().equals(query)) {
                this.currentMatchIndex = this.currentMatches.matches().isEmpty() ? -1 : (this.currentMatchIndex + 1) % this.currentMatches.matches().size();
            } else {
                String[] splitQuery = query.split(" ");
                this.currentMatchIndex = 0;
                this.currentMatches = new SearchMatches(query, this.collectSearchAnchors().stream().filter(anchor -> Arrays.stream(splitQuery).allMatch(anchor.currentSearchText()::contains)).toList());
            }
            if (this.currentMatches.matches().isEmpty()) {
                matchIndicator.text((class_2561)class_2561.method_43471((String)"text.owo.config.search.no_matches"));
                this.searchBox.method_1868(15408438);
            } else {
                matchIndicator.text((class_2561)class_2561.method_43469((String)"text.owo.config.search.matches", (Object[])new Object[]{this.currentMatchIndex + 1, this.currentMatches.matches().size()}));
                this.searchBox.method_1868(2686911);
                SearchAnchorComponent selectedMatch = this.currentMatches.matches().get(this.currentMatchIndex);
                ParentComponent anchorFrame = selectedMatch.anchorFrame();
                if (anchorFrame instanceof FlowLayout) {
                    FlowLayout flow = (FlowLayout)anchorFrame;
                    flow.child(0, (Component)new SearchHighlighterComponent());
                }
                if (anchorFrame.y() < scroll.y() || anchorFrame.y() + anchorFrame.height() > scroll.y() + scroll.height()) {
                    scroll.scrollTo((Component)selectedMatch.anchorFrame());
                }
            }
            return true;
        });
    }

    public TextBoxComponent searchBox() {
        return this.searchBox;
    }

    protected List<SearchAnchorComponent> collectSearchAnchors() {
        ArrayList<SearchAnchorComponent> discovered = new ArrayList<SearchAnchorComponent>();
        ArrayDeque candidates = new ArrayDeque(this.scroll.children());
        while (!candidates.isEmpty()) {
            Component candidate = (Component)candidates.poll();
            if (candidate instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)candidate;
                candidates.addAll(parentComponent.children());
                continue;
            }
            if (!(candidate instanceof SearchAnchorComponent)) continue;
            SearchAnchorComponent anchor = (SearchAnchorComponent)candidate;
            discovered.add(anchor);
        }
        return discovered;
    }
}

