/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.gui.search;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;

public class SearchHighlighterComponent
extends BaseComponent {
    private final Color startColor = Color.ofArgb((int)9280480);
    private final Color endColor = Color.ofArgb((int)1284348896);
    private float age = 0.0f;

    public SearchHighlighterComponent() {
        this.positioning(Positioning.absolute((int)0, (int)0));
        this.sizing(Sizing.fill((int)100), Sizing.fill((int)100));
    }

    public void draw(OwoUIDrawContext ctx, int mouseX, int mouseY, float partialTicks, float delta) {
        int mainColor = this.startColor.interpolate(this.endColor, (float)Math.sin((double)(this.age / 25.0f) * Math.PI)).argb();
        int segmentWidth = (int)((float)this.width * 0.3f);
        int baseX = (int)((float)(this.x - segmentWidth) + Easing.CUBIC.apply(this.age / 25.0f) * (float)(this.width + segmentWidth * 2));
        ctx.drawGradientRect(baseX - segmentWidth, this.y, segmentWidth, this.height, 0, mainColor, mainColor, 0);
        ctx.drawGradientRect(baseX, this.y, segmentWidth, this.height, mainColor, 0, 0, mainColor);
    }

    public void update(float delta, int mouseX, int mouseY) {
        float f;
        super.update(delta, mouseX, mouseY);
        this.age += delta;
        if (f > 25.0f) {
            this.parent.queue(() -> this.parent.removeChild((Component)this));
        }
    }
}

