/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.log;

import io.wispforest.gadget.mixin.client.ChatHudAccessor;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7591;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ChatLogAppender
extends AbstractAppender {
    public static final ChatLogAppender INSTANCE = new ChatLogAppender();
    public static final class_7591 MESSAGE_INDICATOR = new class_7591(38655, null, (class_2561)class_2561.method_43471((String)"chat.tag.gadget.loud_logging"), "Why are you seeing this?");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
    private final Layout<String> layout = PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss} %level] (%logger{1}) %msg{nolookups}").build();
    private final Set<String> allowedLoggerNames = new HashSet<String>();

    protected ChatLogAppender() {
        super("gadget:chat_log", null, null, false, null);
    }

    public static void init() {
        INSTANCE.start();
        ((Logger)LogManager.getRootLogger()).addAppender((Appender)INSTANCE);
    }

    public Set<String> allowedLoggerNames() {
        return this.allowedLoggerNames;
    }

    private String shortenLoggerName(String orig) {
        CharSequence[] split = orig.split("\\.");
        for (int j = 0; j < split.length; ++j) {
            String part = split[j];
            for (int i = 0; i < part.length(); ++i) {
                if (Character.isLetterOrDigit(part.charAt(i))) continue;
                return orig;
            }
            if (j >= split.length - 1) continue;
            split[j] = String.valueOf(part.charAt(0));
        }
        return String.join((CharSequence)".", split);
    }

    private class_2561 fromLogEvent(LogEvent event) {
        String formatDate = TIME_FORMATTER.format(Instant.ofEpochMilli(event.getInstant().getEpochMillisecond()).atZone(ZoneId.systemDefault()));
        return class_2561.method_43469((String)"text.gadget.log_entry", (Object[])new Object[]{formatDate, class_2561.method_43471((String)("text.gadget.log_level." + event.getLevel().getStandardLevel().name().toLowerCase(Locale.ROOT))), this.shortenLoggerName(event.getLoggerName()), event.getMessage().getFormattedMessage()});
    }

    public void append(LogEvent event) {
        if (!this.allowedLoggerNames.contains(event.getLoggerName())) {
            return;
        }
        class_2561 text = this.fromLogEvent(event);
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            if (client.field_1724 == null) {
                return;
            }
            ((ChatHudAccessor)client.field_1705.method_1743()).callAddMessage(text, null, MESSAGE_INDICATOR);
        });
    }
}

