/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.nbt;

import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.gadget.client.gui.TabTextBoxComponent;
import io.wispforest.gadget.client.nbt.NbtDataIsland;
import io.wispforest.gadget.client.nbt.NbtPath;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import java.util.function.Predicate;
import net.minecraft.class_11908;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4614;

public class KeyAdderWidget
extends FlowLayout {
    private final NbtDataIsland island;
    private final NbtPath parentPath;
    private final class_4614<?> type;
    private final Predicate<String> nameVerifier;
    private final TextBoxComponent nameField;
    private final TextBoxComponent valueField;
    private boolean wasMounted = false;

    public KeyAdderWidget(NbtDataIsland island, NbtPath parentPath, class_4614<?> type, Predicate<String> nameVerifier) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        this.island = island;
        this.parentPath = parentPath;
        this.type = type;
        this.nameVerifier = nameVerifier;
        this.child((Component)Components.label((class_2561)island.typeText(type, "").method_27693(" ")));
        this.nameField = new TabTextBoxComponent(Sizing.fixed((int)75));
        this.child(this.nameField.verticalSizing(Sizing.fixed((int)8)));
        if (KeyAdderWidget.typeNeedsValue(type)) {
            this.child((Component)Components.label((class_2561)class_2561.method_30163((String)" = ")));
            this.valueField = new TabTextBoxComponent(Sizing.fixed((int)75));
            this.child(this.valueField.verticalSizing(Sizing.fixed((int)8)));
        } else if (KeyAdderWidget.typeNeedsSize(type)) {
            this.child((Component)Components.label((class_2561)class_2561.method_30163((String)"[")).margins(Insets.horizontal((int)2)));
            this.valueField = new TabTextBoxComponent(Sizing.fixed((int)50));
            this.child(this.valueField.verticalSizing(Sizing.fixed((int)8)));
            this.child((Component)Components.label((class_2561)class_2561.method_30163((String)"]")).margins(Insets.horizontal((int)2)));
        } else {
            this.valueField = null;
        }
        this.nameField.keyPress().subscribe(this::onNameFieldKeyPressed);
        this.nameField.focusLost().subscribe(this::onFieldFocusLost);
        GuiUtil.textFieldVerifier((class_342)this.nameField, nameVerifier);
        if (this.valueField != null) {
            this.valueField.keyPress().subscribe(this::onValueFieldKeyPressed);
            this.valueField.focusLost().subscribe(this::onFieldFocusLost);
            GuiUtil.textFieldVerifier((class_342)this.valueField, this::verifyValue);
        }
    }

    public void mount(ParentComponent parent, int x, int y) {
        super.mount(parent, x, y);
        if (!this.wasMounted) {
            this.wasMounted = true;
            this.island.focusHandler().focus((Component)this.nameField, Component.FocusSource.MOUSE_CLICK);
            this.nameField.method_25365(true);
        }
    }

    private void onFieldFocusLost() {
        class_310.method_1551().method_63588(() -> {
            if (this.focusHandler() == null) {
                return;
            }
            Component newFocused = this.focusHandler().focused();
            if (newFocused == this.nameField || newFocused == this.valueField) {
                return;
            }
            this.parent().removeChild((Component)this);
        });
    }

    private void commit() {
        class_2487 element;
        if (!this.nameVerifier.test(this.nameField.method_1882())) {
            return;
        }
        if (this.valueField != null && !this.verifyValue(this.valueField.method_1882())) {
            return;
        }
        if (this.type == class_2487.field_21029) {
            element = new class_2487();
        } else if (this.type == class_2499.field_21039) {
            element = new class_2499();
        } else if (this.type == class_2479.field_21024) {
            element = new class_2479(new byte[Integer.parseInt(this.valueField.method_1882())]);
        } else if (this.type == class_2495.field_21036) {
            element = new class_2495(new int[Integer.parseInt(this.valueField.method_1882())]);
        } else if (this.type == class_2501.field_21040) {
            element = new class_2501(new long[Integer.parseInt(this.valueField.method_1882())]);
        } else if (this.type == class_2519.field_21045) {
            element = class_2519.method_23256((String)this.valueField.method_1882());
        } else if (this.type == class_2481.field_21025) {
            element = class_2481.method_23233((byte)Byte.parseByte(this.valueField.method_1882()));
        } else if (this.type == class_2516.field_21043) {
            element = class_2516.method_23254((short)Short.parseShort(this.valueField.method_1882()));
        } else if (this.type == class_2497.field_21037) {
            element = class_2497.method_23247((int)Integer.parseInt(this.valueField.method_1882()));
        } else if (this.type == class_2503.field_21041) {
            element = class_2503.method_23251((long)Long.parseLong(this.valueField.method_1882()));
        } else if (this.type == class_2494.field_21035) {
            element = class_2494.method_23244((float)Float.parseFloat(this.valueField.method_1882()));
        } else if (this.type == class_2489.field_21031) {
            element = class_2489.method_23241((double)Double.parseDouble(this.valueField.method_1882()));
        } else if (this.type == class_2491.field_21032) {
            element = class_2491.field_21033;
        } else {
            throw new IllegalStateException("Unknown NbtType");
        }
        NbtPath path = this.parentPath.then(this.nameField.method_1882());
        path.add((class_2520)this.island.data, (class_2520)element);
        this.island.makeComponent(path, (class_2520)element);
        this.island.reloader.accept(this.island.data);
        this.parent().removeChild((Component)this);
    }

    private boolean onNameFieldKeyPressed(class_11908 input) {
        if (input.comp_4795() == 257) {
            if (this.valueField == null) {
                this.commit();
            } else {
                this.island.focusHandler().focus((Component)this.valueField, Component.FocusSource.MOUSE_CLICK);
                this.valueField.method_25365(true);
            }
            return true;
        }
        return false;
    }

    private boolean onValueFieldKeyPressed(class_11908 input) {
        if (input.comp_4795() == 257) {
            this.commit();
            return true;
        }
        return false;
    }

    private static boolean typeNeedsValue(class_4614<?> type) {
        return type != class_2491.field_21032 && type != class_2487.field_21029 && type != class_2499.field_21039 && type != class_2479.field_21024 && type != class_2495.field_21036 && type != class_2501.field_21040;
    }

    private static boolean typeNeedsSize(class_4614<?> type) {
        return type == class_2479.field_21024 || type == class_2495.field_21036 || type == class_2501.field_21040;
    }

    private boolean verifyValue(String value) {
        if (this.type == class_2479.field_21024 || this.type == class_2495.field_21036 || this.type == class_2501.field_21040) {
            return this.tryRun(() -> Integer.parseInt(value));
        }
        if (this.type == class_2481.field_21025) {
            return this.tryRun(() -> Byte.parseByte(value));
        }
        if (this.type == class_2516.field_21043) {
            return this.tryRun(() -> Short.parseShort(value));
        }
        if (this.type == class_2497.field_21037) {
            return this.tryRun(() -> Integer.parseInt(value));
        }
        if (this.type == class_2503.field_21041) {
            return this.tryRun(() -> Long.parseLong(value));
        }
        if (this.type == class_2494.field_21035) {
            return this.tryRun(() -> Float.parseFloat(value));
        }
        if (this.type == class_2489.field_21031) {
            return this.tryRun(() -> Double.parseDouble(value));
        }
        return true;
    }

    private boolean tryRun(Runnable runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

