/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.resource;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.DialogUtil;
import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.gadget.client.gui.LayoutCacheWrapper;
import io.wispforest.gadget.client.gui.SubObjectContainer;
import io.wispforest.gadget.decompile.KnotUtil;
import io.wispforest.gadget.decompile.QuiltflowerHandler;
import io.wispforest.gadget.decompile.QuiltflowerManager;
import io.wispforest.gadget.early.GadgetMixinExtension;
import io.wispforest.gadget.util.ProgressToast;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.UISounds;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ViewClassesScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private final boolean showAll;
    private ProgressToast toast;
    private ScrollContainer<FlowLayout> contentsScroll;
    private final FlowLayout contents = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
    private final QuiltflowerHandler decompiler;
    private String currentFileName = null;
    private String currentFileContents = null;

    public ViewClassesScreen(class_437 parent, boolean showAll, ProgressToast toast) {
        this.parent = parent;
        this.showAll = showAll;
        this.toast = toast;
        toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.loading_quiltflower"));
        this.decompiler = QuiltflowerManager.loadHandler(toast, text -> {
            assert (this.field_22787 != null);
            this.field_22787.execute(() -> {
                LabelComponent label = Components.label((class_2561)text);
                this.contents.child(new LayoutCacheWrapper<LabelComponent>(label));
                this.contentsScroll.scrollTo((Component)label);
            });
        });
    }

    public static void openWithProgress(class_437 parent) {
        ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"message.gadget.loading_classes"));
        class_310 client = class_310.method_1551();
        boolean showAll = class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)340);
        toast.follow((CompletableFuture<Void>)((CompletableFuture)QuiltflowerManager.ensureInstalled(toast).thenApplyAsync(unused -> {
            ViewClassesScreen screen = new ViewClassesScreen(parent, showAll, toast);
            screen.method_25423(client, parent.field_22789, parent.field_22790);
            screen.toast = null;
            return screen;
        })).thenAcceptAsync(arg_0 -> ((class_310)client).method_1507(arg_0), (Executor)client), true);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        Set<String> allClasses;
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)5));
        FlowLayout tree = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        ScrollContainer treeScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)25), (Sizing)Sizing.fill((int)100), (Component)tree).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        this.contentsScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)72), (Sizing)Sizing.fill((int)100), (Component)this.contents).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        rootComponent.child((Component)treeScroll.margins(Insets.right((int)3))).child(this.contentsScroll);
        this.toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.building_screen"));
        TreeEntry root = new TreeEntry("", tree);
        if (this.showAll) {
            allClasses = new TreeSet<String>();
            for (Class clazz : KnotUtil.INSTRUMENTATION.getInitiatedClasses(Gadget.class.getClassLoader())) {
                if (clazz.isHidden() || clazz.isArray()) continue;
                Class<?> clazz2 = clazz.getNestHost();
                allClasses.add(clazz2.getName());
            }
        } else {
            allClasses = GadgetMixinExtension.DUMPED_CLASSES;
        }
        for (String name : allClasses) {
            String fullPath = this.decompiler.mapClass(name.replace('.', '/')) + ".class";
            String[] stringArray = fullPath.split("/");
            TreeEntry parent = root;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                parent = parent.directory(stringArray[i]);
            }
            parent.container.child((Component)this.makeRecipeRow(stringArray[stringArray.length - 1], fullPath));
        }
        this.toast.step((class_2561)class_2561.method_43470((String)""));
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4795() == 83 && input.method_74240()) {
            if (this.currentFileContents == null) {
                return false;
            }
            String path = DialogUtil.saveFileDialog("Save as .java", this.currentFileName.replace(".class", ".java"), List.of("*.java"), "Java source files");
            if (path != null) {
                try {
                    Files.writeString(Path.of(path, new String[0]), (CharSequence)this.currentFileContents, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return super.method_25404(input);
    }

    private FlowLayout makeRecipeRow(String name, String fullPath) {
        FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        LabelComponent fileLabel = Components.label((class_2561)class_2561.method_43470((String)name));
        row.child((Component)fileLabel);
        row.mouseEnter().subscribe(() -> row.surface(Surface.flat((int)-2130706433)));
        row.mouseLeave().subscribe(() -> row.surface(Surface.BLANK));
        row.mouseDown().subscribe((click, doubled) -> {
            if (click.method_74245() == 0) {
                UISounds.playInteractionSound();
                this.contents.clearChildren();
                ForkJoinPool.commonPool().execute(() -> {
                    try {
                        String text = this.decompiler.decompileClass(Class.forName(this.decompiler.unmapClass(fullPath.replace(".class", "").replace('/', '.'))));
                        this.field_22787.execute(() -> {
                            this.currentFileName = fullPath.substring(fullPath.lastIndexOf(47) + 1);
                            this.currentFileContents = text;
                            this.contents.configure(unused -> {
                                this.contents.clearChildren();
                                GuiUtil.showMonospaceText(this.contents, text);
                            });
                            this.contentsScroll.scrollTo((Component)this.contents);
                        });
                    }
                    catch (Exception e) {
                        this.field_22787.execute(() -> this.contents.configure(unused -> {
                            this.contents.clearChildren();
                            this.contents.child((Component)GuiUtil.showException(e));
                        }));
                    }
                });
            } else {
                String filename = fullPath.substring(fullPath.lastIndexOf(47) + 1);
                GuiUtil.contextMenu((Component)row, click.comp_4798(), click.comp_4799()).button((class_2561)class_2561.method_43471((String)"text.gadget.save_as_java"), unused -> {
                    String path = DialogUtil.saveFileDialog("Save as .java", filename.replace(".class", ".java"), List.of("*.java"), "Java source files");
                    if (path != null) {
                        try {
                            Files.writeString(Path.of(path, new String[0]), (CharSequence)this.currentFileContents, StandardCharsets.UTF_8, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).button((class_2561)class_2561.method_43471((String)"text.gadget.save_as_class"), unused -> {
                    String path = DialogUtil.saveFileDialog("Save as .class", filename, List.of("*.class"), "JVM class files");
                    if (path != null) {
                        try {
                            this.contents.clearChildren();
                            Files.write(Path.of(path, new String[0]), this.decompiler.getClassBytes(fullPath.replace(".class", "")), new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            return true;
        });
        return row;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private static class TreeEntry {
        private final String name;
        private final List<TreeEntry> children = new ArrayList<TreeEntry>();
        private final FlowLayout container;

        private TreeEntry(String name, FlowLayout container) {
            this.name = name;
            this.container = container;
        }

        public TreeEntry directory(String name) {
            for (TreeEntry entry : this.children) {
                if (!entry.name.equals(name)) continue;
                return entry;
            }
            SubObjectContainer sub = new SubObjectContainer(unused -> {}, unused -> {});
            FlowLayout entryContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            this.container.child((Component)entryContainer.child((Component)row.child((Component)Components.label((class_2561)class_2561.method_43470((String)name))).child(sub.getSpinnyBoi().margins(Insets.left((int)3)))).child((Component)sub));
            TreeEntry entry = new TreeEntry(name, sub);
            this.children.add(entry);
            return entry;
        }
    }
}

