/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.client.resource;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.gui.GuiUtil;
import io.wispforest.gadget.client.gui.SubObjectContainer;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.UISounds;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ViewResourcesScreen
extends BaseOwoScreen<FlowLayout> {
    private static final class_2960 FILE_TEXTURE_ID = Gadget.id("file_texture");
    private final class_437 parent;
    private final Map<class_2960, Integer> resourcePaths;
    private BiConsumer<class_2960, Integer> resRequester;
    private class_1043 prevTexture;
    private FlowLayout contents;

    public ViewResourcesScreen(class_437 parent, Map<class_2960, Integer> resourcePaths) {
        this.parent = parent;
        this.resourcePaths = resourcePaths;
    }

    public void resRequester(BiConsumer<class_2960, Integer> resRequester) {
        this.resRequester = resRequester;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)5));
        FlowLayout tree = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        ScrollContainer treeScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)25), (Sizing)Sizing.fill((int)100), (Component)tree).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        this.contents = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        ScrollContainer contentsScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)72), (Sizing)Sizing.fill((int)100), (Component)this.contents).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1593835521)));
        rootComponent.child((Component)treeScroll.margins(Insets.right((int)3))).child((Component)contentsScroll);
        TreeEntry root = new TreeEntry("", tree);
        for (Map.Entry<class_2960, Integer> pair : this.resourcePaths.entrySet()) {
            String fullPath = pair.getKey().method_12836() + "/" + pair.getKey().method_12832();
            String[] split = fullPath.split("/");
            TreeEntry parent = root;
            for (int i = 0; i < split.length - 1; ++i) {
                parent = parent.directory(split[i]);
            }
            if (pair.getValue() > 1) {
                SubObjectContainer sub = new SubObjectContainer(unused -> {}, unused -> {});
                FlowLayout entryContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                parent.container.child((Component)entryContainer.child((Component)row.child((Component)Components.label((class_2561)class_2561.method_43470((String)split[split.length - 1]))).child(sub.getSpinnyBoi().margins(Insets.left((int)3)))).child((Component)sub));
                for (int i = 0; i < pair.getValue(); ++i) {
                    sub.child((Component)this.makeRecipeRow(String.valueOf(i), pair.getKey(), i));
                }
                continue;
            }
            parent.container.child((Component)this.makeRecipeRow(split[split.length - 1], pair.getKey(), 0));
        }
    }

    private FlowLayout makeRecipeRow(String name, class_2960 key, int index) {
        FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        LabelComponent fileLabel = Components.label((class_2561)class_2561.method_43470((String)name));
        row.child((Component)fileLabel);
        row.mouseEnter().subscribe(() -> row.surface(Surface.flat((int)-2130706433)));
        row.mouseLeave().subscribe(() -> row.surface(Surface.BLANK));
        row.mouseDown().subscribe((click, doubled) -> {
            if (click.method_74245() != 0) {
                return false;
            }
            UISounds.playInteractionSound();
            this.resRequester.accept(key, index);
            return true;
        });
        return row;
    }

    public void openFile(class_2960 id, Callable<InputStream> isGetter) {
        if (this.prevTexture != null) {
            this.prevTexture.close();
            this.prevTexture = null;
        }
        this.contents.configure(unused -> {
            try {
                boolean isText;
                InputStream is = (InputStream)isGetter.call();
                this.contents.clearChildren();
                if (id.method_12832().endsWith(".png")) {
                    this.prevTexture = new class_1043(() -> ((class_2960)id).toString(), class_1011.method_4309((InputStream)is));
                    this.field_22787.method_1531().method_4616(FILE_TEXTURE_ID, (class_1044)this.prevTexture);
                    this.contents.child((Component)Components.texture((class_2960)FILE_TEXTURE_ID, (int)0, (int)0, (int)this.prevTexture.method_4525().method_4307(), (int)this.prevTexture.method_4525().method_4323(), (int)this.prevTexture.method_4525().method_4307(), (int)this.prevTexture.method_4525().method_4323())).child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.gadget.image_size", (Object[])new Object[]{this.prevTexture.method_4525().method_4307(), this.prevTexture.method_4525().method_4323(), "PNG"})));
                    return;
                }
                is = new BufferedInputStream(is);
                boolean bl = isText = id.method_12832().endsWith(".txt") || id.method_12832().endsWith(".json") || id.method_12832().endsWith(".fsh") || id.method_12832().endsWith(".vsh") || id.method_12832().endsWith(".snbt");
                if (!isText) {
                    try {
                        is.mark(128);
                        byte[] bytes = is.readNBytes(128);
                        CharBuffer chars = StandardCharsets.UTF_8.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(bytes));
                        isText = true;
                        for (int i = 0; i < chars.length(); ++i) {
                            char codepoint = chars.charAt(i);
                            if (codepoint > '\u007f' || Character.isDigit((int)codepoint) || Character.isAlphabetic(codepoint) || Character.isSpaceChar((int)codepoint)) continue;
                            isText = false;
                            break;
                        }
                    }
                    catch (CharacterCodingException characterCodingException) {
                        // empty catch block
                    }
                    is.reset();
                }
                if (isText) {
                    GuiUtil.showMonospaceText(this.contents, new String(is.readAllBytes(), StandardCharsets.UTF_8));
                    return;
                }
                this.contents.child((Component)GuiUtil.hexDump(is.readAllBytes(), false));
            }
            catch (Exception e) {
                this.contents.child((Component)GuiUtil.showException(e));
            }
        });
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        if (this.prevTexture != null) {
            this.prevTexture.close();
        }
    }

    private static class TreeEntry {
        private final String name;
        private final List<TreeEntry> children = new ArrayList<TreeEntry>();
        private final FlowLayout container;

        private TreeEntry(String name, FlowLayout container) {
            this.name = name;
            this.container = container;
        }

        public TreeEntry directory(String name) {
            for (TreeEntry entry : this.children) {
                if (!entry.name.equals(name)) continue;
                return entry;
            }
            SubObjectContainer sub = new SubObjectContainer(unused -> {}, unused -> {});
            FlowLayout entryContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            this.container.child((Component)entryContainer.child((Component)row.child((Component)Components.label((class_2561)class_2561.method_43470((String)name))).child(sub.getSpinnyBoi().margins(Insets.left((int)3)))).child((Component)sub));
            TreeEntry entry = new TreeEntry(name, sub);
            this.children.add(entry);
            return entry;
        }
    }
}

