/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile;

import io.wispforest.gadget.Gadget;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import net.auoeke.reflect.ClassTransformer;
import net.auoeke.reflect.Reflect;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;

public final class KnotUtil {
    public static final Instrumentation INSTRUMENTATION = (Instrumentation)Reflect.instrument().value();
    private static final Object KNOT_DELEGATE;
    private static final MethodHandle POST_MIXIN_BYTES_GETTER;

    private KnotUtil() {
    }

    public static byte[] getPostMixinClassByteArray(final String name, boolean allowFromParent) {
        try {
            byte[] bytes = POST_MIXIN_BYTES_GETTER.invokeExact(name, allowFromParent);
            if (bytes != null) {
                return bytes;
            }
        }
        catch (Throwable e) {
            Gadget.LOGGER.error("Got error while loading {}", (Object)name, (Object)e);
        }
        if (INSTRUMENTATION != null) {
            var transformer = new ClassTransformer(){
                private byte[] bytes;

                public byte[] transform(Module module, ClassLoader loader, String name1, Class<?> type, ProtectionDomain domain, byte[] classFile) {
                    if (name.equals(name1.replace('/', '.'))) {
                        this.bytes = classFile;
                    }
                    return null;
                }
            };
            INSTRUMENTATION.addTransformer((ClassFileTransformer)((Object)transformer), true);
            try {
                INSTRUMENTATION.retransformClasses(Class.forName(name));
                INSTRUMENTATION.removeTransformer((ClassFileTransformer)((Object)transformer));
                if (transformer.bytes != null) {
                    return transformer.bytes;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (UnmodifiableClassException unmodifiableClassException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            FabricLauncher launcher = FabricLauncherBase.getLauncher();
            Field delegateField = launcher.getClass().getDeclaredField("classLoader");
            delegateField.setAccessible(true);
            KNOT_DELEGATE = delegateField.get(launcher);
            Method getter = KNOT_DELEGATE.getClass().getDeclaredMethod("getPostMixinClassByteArray", String.class, Boolean.TYPE);
            getter.setAccessible(true);
            POST_MIXIN_BYTES_GETTER = MethodHandles.lookup().unreflect(getter).bindTo(KNOT_DELEGATE);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

